/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataFrameValidator$
implements LazyLogging {
    public static DataFrameValidator$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DataFrameValidator$();
    }

    private Logger logger$lzycompute() {
        DataFrameValidator$ dataFrameValidator$ = this;
        synchronized (dataFrameValidator$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean checkSchemaContains(StructType schema, StructType subSchema) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.assertSchemaContains(schema, subSchema));
        if (try_ instanceof Success) {
            bl = true;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error evaluating if schema contains other", exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public void assertSchemaContains(StructType schema, StructType subSchema) {
        Map existingColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subSchema.fields())).foreach((Function1 & Serializable & scala.Serializable)requiredField -> {
            Tuple2 tuple2 = new Tuple2((Object)existingColumns.get((Object)requiredField.name()), requiredField);
            if (tuple2 != null) {
                DataType foundType;
                Some some;
                StructField structField;
                Option option = (Option)tuple2._1();
                StructField structField2 = (StructField)tuple2._2();
                if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null && (foundType = structField.dataType()) instanceof StructType) {
                    DataType requiredType;
                    StructType structType = (StructType)foundType;
                    if (structField2 != null && (requiredType = structField2.dataType()) instanceof StructType) {
                        StructType structType2 = (StructType)requiredType;
                        MODULE$.assertSchemaContains(structType, structType2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return requiredField.name();
                    }
                }
            }
            if (tuple2 != null) {
                ArrayType arrayType;
                DataType foundElementType;
                DataType foundType;
                Some some;
                StructField structField;
                Option option = (Option)tuple2._1();
                StructField structField3 = (StructField)tuple2._2();
                if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null && (foundType = structField.dataType()) instanceof ArrayType && (foundElementType = (arrayType = (ArrayType)foundType).elementType()) instanceof StructType) {
                    ArrayType arrayType2;
                    DataType requiredElementType;
                    DataType requiredType;
                    StructType structType = (StructType)foundElementType;
                    if (structField3 != null && (requiredType = structField3.dataType()) instanceof ArrayType && (requiredElementType = (arrayType2 = (ArrayType)requiredType).elementType()) instanceof StructType) {
                        StructType structType3 = (StructType)requiredElementType;
                        MODULE$.assertSchemaContains(structType, structType3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return requiredField.name();
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                StructField structField;
                Option option = (Option)tuple2._1();
                StructField structField4 = (StructField)tuple2._2();
                if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null) {
                    String foundName = structField.name();
                    DataType foundType = structField.dataType();
                    if (foundType instanceof ArrayType) {
                        DataType requiredType;
                        ArrayType arrayType = (ArrayType)foundType;
                        DataType foundElementType = arrayType.elementType();
                        if (structField4 != null && (requiredType = structField4.dataType()) instanceof ArrayType) {
                            ArrayType arrayType3 = (ArrayType)requiredType;
                            DataType requiredElementType = arrayType3.elementType();
                            if (TypeCoercion$.MODULE$.findWiderTypeForTwo(foundElementType, requiredElementType).isEmpty()) {
                                throw new Exception(new StringBuilder(53).append("Field ").append(foundName).append(" has incompatible types. Found ").append(arrayType).append(", but ").append(arrayType3).append(" expected.").toString());
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return requiredField.name();
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Some some;
                StructField structField;
                Option option = (Option)tuple2._1();
                StructField structField5 = (StructField)tuple2._2();
                if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null) {
                    String foundName = structField.name();
                    DataType foundType = structField.dataType();
                    if (structField5 != null) {
                        DataType requiredType = structField5.dataType();
                        if (TypeCoercion$.MODULE$.findWiderTypeForTwo(foundType, requiredType).isEmpty()) {
                            throw new Exception(new StringBuilder(53).append("Field ").append(foundName).append(" has incompatible types. Found ").append(foundType).append(", but ").append(requiredType).append(" expected.").toString());
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return requiredField.name();
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option option = (Option)tuple2._1();
            StructField structField = (StructField)tuple2._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            if (structField == null) throw new MatchError((Object)tuple2);
            String requiredName = structField.name();
            throw new Exception(new StringBuilder(24).append("Missing required field ").append(requiredName).append(".").toString());
        });
    }

    private DataFrameValidator$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

