/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.Uri$;
import akka.stream.Materializer$;
import io.prophecy.libs.RestAPIUtils;
import io.prophecy.libs.RestAPIUtils$Result$;
import io.prophecy.libs.utils.package$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RestAPIUtils$ {
    public static RestAPIUtils$ MODULE$;
    private final Logger io$prophecy$libs$RestAPIUtils$$logger;
    private final ActorSystem system;
    private final ExecutionContextExecutor executionContext;
    private Duration defaultTimeout;
    private volatile byte bitmap$init$0;

    static {
        new RestAPIUtils$();
    }

    public Logger io$prophecy$libs$RestAPIUtils$$logger() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/akka-2.5.32/io/prophecy/libs/RestAPIUtils.scala: 35");
        }
        return this.io$prophecy$libs$RestAPIUtils$$logger;
    }

    public ActorSystem system() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/akka-2.5.32/io/prophecy/libs/RestAPIUtils.scala: 37");
        }
        return this.system;
    }

    public ExecutionContextExecutor executionContext() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/akka-2.5.32/io/prophecy/libs/RestAPIUtils.scala: 38");
        }
        return this.executionContext;
    }

    public Duration defaultTimeout() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/akka-2.5.32/io/prophecy/libs/RestAPIUtils.scala: 39");
        }
        return this.defaultTimeout;
    }

    public void defaultTimeout_$eq(Duration x$1) {
        this.defaultTimeout = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private List<String> httpMethods() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONNECT", "DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE"}));
    }

    public Either<RestAPIUtils.Result, String> io$prophecy$libs$RestAPIUtils$$verifyUrl(String url) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> io.prophecy.libs.actor.package$.MODULE$.HttpRequest().verifyUri(Uri$.MODULE$.apply(url)));
        if (try_ instanceof Success) {
            right = scala.package$.MODULE$.Right().apply((Object)url);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringBuilder(35).append("Parsing the url failed with error: ").append(error.getMessage()).toString()));
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public Either<RestAPIUtils.Result, HttpMethod> io$prophecy$libs$RestAPIUtils$$parseMethod(String method) {
        Right right;
        Option option = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().getForKeyCaseInsensitive(method, Predef$.MODULE$.$conforms());
        if (option instanceof Some) {
            Some some = (Some)option;
            HttpMethod value = (HttpMethod)some.value();
            right = scala.package$.MODULE$.Right().apply((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringBuilder(45).append("Unsupported method ").append(method).append(", expected one of (").append(this.httpMethods().mkString(", ")).append(" etc.).").toString()));
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    public Right<Nothing$, HttpEntity.Strict> io$prophecy$libs$RestAPIUtils$$createEntity(HttpMethod method, String content) {
        HttpEntity.Strict strict;
        Right$ right$ = scala.package$.MODULE$.Right();
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().CONNECT();
        HttpMethod httpMethod3 = httpMethod;
        if (!(httpMethod2 != null ? !httpMethod2.equals(httpMethod3) : httpMethod3 != null)) {
            strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
        } else {
            HttpMethod httpMethod4 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().DELETE();
            HttpMethod httpMethod5 = httpMethod;
            if (!(httpMethod4 != null ? !httpMethod4.equals(httpMethod5) : httpMethod5 != null)) {
                strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
            } else {
                HttpMethod httpMethod6 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().GET();
                HttpMethod httpMethod7 = httpMethod;
                if (!(httpMethod6 != null ? !httpMethod6.equals(httpMethod7) : httpMethod7 != null)) {
                    strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                } else {
                    HttpMethod httpMethod8 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().HEAD();
                    HttpMethod httpMethod9 = httpMethod;
                    if (!(httpMethod8 != null ? !httpMethod8.equals(httpMethod9) : httpMethod9 != null)) {
                        strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                    } else {
                        HttpMethod httpMethod10 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().OPTIONS();
                        HttpMethod httpMethod11 = httpMethod;
                        if (!(httpMethod10 != null ? !httpMethod10.equals(httpMethod11) : httpMethod11 != null)) {
                            strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                        } else {
                            HttpMethod httpMethod12 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().PATCH();
                            HttpMethod httpMethod13 = httpMethod;
                            if (!(httpMethod12 != null ? !httpMethod12.equals(httpMethod13) : httpMethod13 != null)) {
                                strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                            } else {
                                HttpMethod httpMethod14 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().POST();
                                HttpMethod httpMethod15 = httpMethod;
                                if (!(httpMethod14 != null ? !httpMethod14.equals(httpMethod15) : httpMethod15 != null)) {
                                    strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().apply(io.prophecy.libs.actor.package$.MODULE$.ContentTypes().application$divjson(), content);
                                } else {
                                    HttpMethod httpMethod16 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().PUT();
                                    HttpMethod httpMethod17 = httpMethod;
                                    if (!(httpMethod16 != null ? !httpMethod16.equals(httpMethod17) : httpMethod17 != null)) {
                                        strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().apply(io.prophecy.libs.actor.package$.MODULE$.ContentTypes().application$divjson(), content);
                                    } else {
                                        HttpMethod httpMethod18 = io.prophecy.libs.actor.package$.MODULE$.HttpMethods().TRACE();
                                        HttpMethod httpMethod19 = httpMethod;
                                        if (!(httpMethod18 != null ? !httpMethod18.equals(httpMethod19) : httpMethod19 != null)) {
                                            strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                                        } else if (httpMethod != null) {
                                            strict = io.prophecy.libs.actor.package$.MODULE$.HttpEntity().Empty();
                                        } else {
                                            throw new MatchError((Object)httpMethod);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return right$.apply((Object)strict);
    }

    public Either<RestAPIUtils.Result, scala.collection.immutable.Seq<HttpHeader>> io$prophecy$libs$RestAPIUtils$$parseHeaders(Seq<String> headers) {
        Right right;
        Either either = package$.MODULE$.EitherSeq((Seq)headers.map((Function1 & Serializable & scala.Serializable)header -> {
            Right right;
            Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(header)).splitAt(header.indexOf(":"));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)name, (Object)value);
            Tuple2 tuple23 = tuple22;
            String name2 = (String)tuple23._1();
            String value2 = (String)tuple23._2();
            HttpHeader.ParsingResult parsingResult = io.prophecy.libs.actor.package$.MODULE$.HttpHeader().parse(name2, value2, io.prophecy.libs.actor.package$.MODULE$.HttpHeader().parse$default$3());
            if (parsingResult instanceof HttpHeader.ParsingResult$.Ok) {
                HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
                HttpHeader header2 = ok.header();
                right = scala.package$.MODULE$.Right().apply((Object)header2);
            } else if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                ErrorInfo error2 = error.error();
                right = scala.package$.MODULE$.Left().apply((Object)RestAPIUtils$Result$.MODULE$.error(new StringBuilder(43).append("Parsing a header ").append(error2.errorHeaderName()).append(" failed with an error `").append(error2.summary()).append("`. ").append(error2.detail()).toString()));
            } else {
                throw new MatchError((Object)parsingResult);
            }
            return right;
        }, scala.collection.Seq$.MODULE$.canBuildFrom())).toEither();
        if (either instanceof Right) {
            Right right2 = (Right)either;
            Seq value = (Seq)right2.value();
            right = scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply(value));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Seq value = (Seq)left.value();
            right = scala.package$.MODULE$.Left().apply(value.head());
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public Future<String> getContent(HttpMessage message) {
        return message.entity().dataBytes().runFold((Object)io.prophecy.libs.actor.package$.MODULE$.ByteString().apply(""), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus(x$3), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.utf8String(), (ExecutionContext)this.executionContext());
    }

    private RestAPIUtils$() {
        MODULE$ = this;
        this.io$prophecy$libs$RestAPIUtils$$logger = LoggerFactory.getLogger(RestAPIUtils.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.system = io.prophecy.libs.actor.package$.MODULE$.ActorSystem().apply();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.executionContext = this.system().dispatcher();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.defaultTimeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).minute();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

