/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.utils.ExceptionExtensions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Py4JWhitelist;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.MetricsCollector$;
import org.apache.spark.sql.ProphecySparkSession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.executionmetrics.InMemoryStore;
import org.apache.spark.sql.executionmetrics.InMemoryStore$;
import org.apache.spark.sql.executionmetrics.InMemoryStore$TimestampedOutput$;
import org.apache.spark.sql.prophecy.ProphecyGemProgressEvent;
import org.apache.spark.sql.prophecy.ProphecyPipelineProgressEvent;
import org.apache.spark.sql.prophecy.SerializableException;
import org.apache.spark.sql.prophecy.SerializableException$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ProphecySparkSession$
implements LazyLogging,
ExceptionExtensions,
scala.Serializable {
    public static ProphecySparkSession$ MODULE$;
    private final String ProphecyJobId;
    private final String CatalystOptimizersPackage;
    private final Seq<String> CatalystOptimizerExcludedRules;
    private final String CatalystExcludedRules;
    private final String DatabricksCatalystOptimizersPackage;
    private final Seq<String> DatabricksCatalystOptimizerExcludedRules;
    private final String DatabricksCatalystExcludedRules;
    private final String AllExcludesRules;
    private transient Logger logger;
    private volatile int bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ProphecySparkSession$();
    }

    @Override
    public ExceptionExtensions.ExceptionExtension ExceptionExtension(Throwable e) {
        return ExceptionExtensions.ExceptionExtension$(this, e);
    }

    private Logger logger$lzycompute() {
        ProphecySparkSession$ prophecySparkSession$ = this;
        synchronized (prophecySparkSession$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Option<InMemoryStore> getInMemoryStore(SparkSession spark, String _session) {
        String sessionUUID = (String)MetricsCollector$.MODULE$.getListenerFromSparkSession(spark).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metricsCollector().recordUID()).getOrElse((Function0 & Serializable & scala.Serializable)() -> _session);
        return MetricsCollector$.MODULE$.sessionDataStore().get((Object)sessionUUID);
    }

    @Py4JWhitelist
    public String getProcessFromGem(SparkSession spark, String gemName, String _session) {
        if (gemName == null) {
            return null;
        }
        String executionSession = (String)MetricsCollector$.MODULE$.getUniqueSessionId(spark).getOrElse((Function0 & Serializable & scala.Serializable)() -> _session);
        Option<InMemoryStore> inMemoryStore = this.getInMemoryStore(spark, _session);
        return (String)((Option)inMemoryStore.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.getProcessFromCode(spark, gemName, executionSession), (Function1 & Serializable & scala.Serializable)store -> store.getProcessIdFromHierarchicalGemName((Option<String>)new Some((Object)gemName)))).orNull(Predef$.MODULE$.$conforms());
    }

    private Option<String> getProcessFromCode(SparkSession spark, String gemName, String executionSession) {
        return InMemoryStore$.MODULE$.getSlugToProcessMap((Option<Map<String, String>>)new Some(MetricsCollector$.MODULE$.getRunningCode(spark, executionSession))).flatMap((Function1 & Serializable & scala.Serializable)map -> map.get((Object)gemName).orElse((Function0 & Serializable & scala.Serializable)() -> map.collectFirst((PartialFunction)new scala.Serializable(gemName){
            public static final long serialVersionUID = 0L;
            private final String gemName$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String slug = (String)A1._1();
                    String process2 = (String)A1._2();
                    if (slug.endsWith(this.gemName$2)) {
                        object = process2;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String slug;
                Tuple2<String, String> tuple2 = x1;
                boolean bl = tuple2 != null && (slug = (String)tuple2._1()).endsWith(this.gemName$2);
                return bl;
            }
            {
                this.gemName$2 = gemName$2;
            }
        })));
    }

    public Option<String> org$apache$spark$sql$ProphecySparkSession$$getProcessFromGem(SparkSession spark, Option<String> gemName) {
        return gemName.flatMap((Function1 & Serializable & scala.Serializable)gem -> Option$.MODULE$.apply((Object)MODULE$.getProcessFromGem(spark, (String)gem, "")));
    }

    @Py4JWhitelist
    public void sendPipelineProgressEvent(SparkSession spark, String session, String pipelineId, String state, String startTime, String endTime) {
        this.sendPipelineProgressEventInternal(spark, session, pipelineId, state, startTime, endTime, (Option<SerializableException>)None$.MODULE$);
    }

    @Py4JWhitelist
    public void sendPipelineProgressEvent(SparkSession spark, String session, String pipelineId, String state, String startTime, String endTime, Throwable throwable) {
        this.sendPipelineProgressEventInternal(spark, session, pipelineId, state, startTime, endTime, (Option<SerializableException>)Option$.MODULE$.apply((Object)throwable).map((Function1 & Serializable & scala.Serializable)e -> SerializableException$.MODULE$.fromThrowable((Throwable)e)));
    }

    @Py4JWhitelist
    public void sendPipelineProgressEvent(SparkSession spark, String session, String pipelineId, String state, String startTime, String endTime, String exceptionType, String msg, String causeMsg, String stackTrace) {
        SerializableException serializableException = SerializableException$.MODULE$.apply(exceptionType, msg, causeMsg, stackTrace);
        this.sendPipelineProgressEventInternal(spark, session, pipelineId, state, startTime, endTime, (Option<SerializableException>)new Some((Object)serializableException));
    }

    public void sendPipelineProgressEventInternal(SparkSession spark, String session, String pipelineId, String state, String startTime, String endTime, Option<SerializableException> exception) {
        String executionSession = (String)MetricsCollector$.MODULE$.getUniqueSessionId(spark).getOrElse((Function0 & Serializable & scala.Serializable)() -> session);
        String key = MetricsCollector$.MODULE$.getSessionAppendedKey(MetricsCollector$.MODULE$.SparkConfPipelineSubmissionTime(), executionSession);
        Option<String> conf = MetricsCollector$.MODULE$.getSparkPropertyWithLogging(key, spark);
        Option submissionTime = conf.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ProphecySparkSession$.$anonfun$sendPipelineProgressEventInternal$2(x$2)));
        None$ optEndTime = endTime.isEmpty() ? None$.MODULE$ : new Some((Object)endTime).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)ProphecySparkSession$.$anonfun$sendPipelineProgressEventInternal$3(x$3)));
        this.sendPipelineProgressEventInternal(spark, session, pipelineId, state, (Option<Object>)submissionTime, new StringOps(Predef$.MODULE$.augmentString(startTime)).toLong(), (Option<Object>)optEndTime, exception);
    }

    public void sendPipelineProgressEventInternal(SparkSession spark, String session, String pipelineId, String state, Option<Object> submissionTime, long startTime, Option<Object> endTime, Option<SerializableException> exception) {
        spark.sparkContext().listenerBus().post((SparkListenerEvent)new ProphecyPipelineProgressEvent(session, pipelineId, state, submissionTime, startTime, endTime, exception));
    }

    public Option<Object> sendPipelineProgressEventInternal$default$7() {
        return None$.MODULE$;
    }

    public Option<SerializableException> sendPipelineProgressEventInternal$default$8() {
        return None$.MODULE$;
    }

    @Py4JWhitelist
    public void sendGemProgressEvent(SparkSession spark, String session, String processId, String taskState, String startTime, String endTime, String stdout, String stderr) {
        None$ optEndTime = endTime.isEmpty() ? None$.MODULE$ : new Some((Object)endTime).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ProphecySparkSession$.$anonfun$sendGemProgressEvent$1(x$4)));
        this.relayGemProgressForValidProcess(spark, session, (Option<String>)Option$.MODULE$.apply((Object)processId), taskState, new StringOps(Predef$.MODULE$.augmentString(startTime)).toLong(), (Option<Object>)optEndTime, (Option<List<InMemoryStore.TimestampedOutput>>)Option$.MODULE$.apply((Object)stdout).map((Function1 & Serializable & scala.Serializable)x$5 -> (List)Json$.MODULE$.parse(x$5).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format()))), (Option<List<InMemoryStore.TimestampedOutput>>)Option$.MODULE$.apply((Object)stderr).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)Json$.MODULE$.parse(x$6).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format()))), (Option<SerializableException>)None$.MODULE$);
    }

    @Py4JWhitelist
    public void sendGemProgressEvent(SparkSession spark, String session, String processId, String taskState, String startTime, String endTime, String stdout, String stderr, String exceptionType, String msg, String causeMsg, String stackTrace) {
        None$ optEndTime = endTime.isEmpty() ? None$.MODULE$ : new Some((Object)endTime).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ProphecySparkSession$.$anonfun$sendGemProgressEvent$4(x$7)));
        SerializableException serializableException = SerializableException$.MODULE$.apply(exceptionType, msg, causeMsg, stackTrace);
        SparkSession x$1 = spark;
        Option x$2 = Option$.MODULE$.apply((Object)processId);
        String x$3 = taskState;
        long x$4 = new StringOps(Predef$.MODULE$.augmentString(startTime)).toLong();
        None$ x$5 = optEndTime;
        Option x$6 = Option$.MODULE$.apply((Object)stdout).map((Function1 & Serializable & scala.Serializable)x$8 -> (List)Json$.MODULE$.parse(x$8).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format())));
        Option x$72 = Option$.MODULE$.apply((Object)stderr).map((Function1 & Serializable & scala.Serializable)x$9 -> (List)Json$.MODULE$.parse(x$9).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format())));
        Some x$82 = new Some((Object)serializableException);
        String x$92 = session;
        this.relayGemProgressForValidProcess(x$1, x$92, (Option<String>)x$2, x$3, x$4, (Option<Object>)x$5, (Option<List<InMemoryStore.TimestampedOutput>>)x$6, (Option<List<InMemoryStore.TimestampedOutput>>)x$72, (Option<SerializableException>)x$82);
    }

    @Py4JWhitelist
    public void sendGemProgressEvent(SparkSession spark, String session, String processId, String taskState, String startTime, String endTime, String stdout, String stderr, Throwable throwable) {
        None$ none$;
        Some some;
        Throwable e;
        None$ optEndTime = endTime.isEmpty() ? None$.MODULE$ : new Some((Object)endTime).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)ProphecySparkSession$.$anonfun$sendGemProgressEvent$7(x$10)));
        Option option = Option$.MODULE$.apply((Object)throwable);
        if (option instanceof Some && (e = (Throwable)(some = (Some)option).value()) != null) {
            Throwable throwable2 = e;
            none$ = new Some((Object)SerializableException$.MODULE$.apply(throwable2.getClass().getSimpleName(), this.ExceptionExtension(throwable2).getNonNullMessage(), (String)Option$.MODULE$.apply((Object)throwable2.getCause()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$11 -> x$11.getMessage()), this.ExceptionExtension(throwable2).getStackTraceLines().mkString("\n")));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Expected valid spark throwable, got nothing");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        None$ exception = none$;
        SparkSession x$1 = spark;
        Option x$2 = Option$.MODULE$.apply((Object)processId);
        String x$3 = taskState;
        long x$4 = new StringOps(Predef$.MODULE$.augmentString(startTime)).toLong();
        None$ x$5 = optEndTime;
        Option x$6 = Option$.MODULE$.apply((Object)stdout).map((Function1 & Serializable & scala.Serializable)x$12 -> (List)Json$.MODULE$.parse(x$12).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format())));
        Option x$7 = Option$.MODULE$.apply((Object)stderr).map((Function1 & Serializable & scala.Serializable)x$13 -> (List)Json$.MODULE$.parse(x$13).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), InMemoryStore$TimestampedOutput$.MODULE$.format())));
        None$ x$8 = exception;
        String x$9 = session;
        this.relayGemProgressForValidProcess(x$1, x$9, (Option<String>)x$2, x$3, x$4, (Option<Object>)x$5, (Option<List<InMemoryStore.TimestampedOutput>>)x$6, (Option<List<InMemoryStore.TimestampedOutput>>)x$7, (Option<SerializableException>)x$8);
    }

    public void org$apache$spark$sql$ProphecySparkSession$$sendGemProgressEvent(SparkSession spark, Option<String> processId, String taskState, long startTime, Option<Object> endTime, Option<List<InMemoryStore.TimestampedOutput>> stdout, Option<List<InMemoryStore.TimestampedOutput>> stderr, Option<ProphecySparkSession.ProphecySparkThrowable> prophecyThrowable) {
        Option serializableException = prophecyThrowable.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.originalException()).map((Function1 & Serializable & scala.Serializable)e -> SerializableException$.MODULE$.fromThrowable((Throwable)e));
        SparkSession x$1 = spark;
        Option<String> x$2 = processId;
        String x$3 = taskState;
        long x$4 = startTime;
        Option<Object> x$5 = endTime;
        Option<List<InMemoryStore.TimestampedOutput>> x$6 = stdout;
        Option<List<InMemoryStore.TimestampedOutput>> x$7 = stderr;
        Option x$8 = serializableException;
        String x$9 = "";
        this.relayGemProgressForValidProcess(x$1, x$9, x$2, x$3, x$4, x$5, x$6, x$7, (Option<SerializableException>)x$8);
    }

    public Option<Object> org$apache$spark$sql$ProphecySparkSession$$sendGemProgressEvent$default$5() {
        return None$.MODULE$;
    }

    public Option<List<InMemoryStore.TimestampedOutput>> org$apache$spark$sql$ProphecySparkSession$$sendGemProgressEvent$default$6() {
        return None$.MODULE$;
    }

    public Option<List<InMemoryStore.TimestampedOutput>> org$apache$spark$sql$ProphecySparkSession$$sendGemProgressEvent$default$7() {
        return None$.MODULE$;
    }

    public Option<ProphecySparkSession.ProphecySparkThrowable> org$apache$spark$sql$ProphecySparkSession$$sendGemProgressEvent$default$8() {
        return None$.MODULE$;
    }

    private void relayGemProgressForValidProcess(SparkSession spark, String _session, Option<String> processId, String taskState, long startTime, Option<Object> endTime, Option<List<InMemoryStore.TimestampedOutput>> _stdout, Option<List<InMemoryStore.TimestampedOutput>> _stderr, Option<SerializableException> serializableException) {
        processId.foreach((Function1 & Serializable & scala.Serializable)process2 -> {
            ProphecySparkSession$.$anonfun$relayGemProgressForValidProcess$1(spark, _session, _stdout, _stderr, startTime, endTime, taskState, serializableException, processId, process2);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Object> relayGemProgressForValidProcess$default$6() {
        return None$.MODULE$;
    }

    private Option<List<InMemoryStore.TimestampedOutput>> relayGemProgressForValidProcess$default$7() {
        return None$.MODULE$;
    }

    private Option<List<InMemoryStore.TimestampedOutput>> relayGemProgressForValidProcess$default$8() {
        return None$.MODULE$;
    }

    private Option<SerializableException> relayGemProgressForValidProcess$default$9() {
        return None$.MODULE$;
    }

    public String ProphecyJobId() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 330");
        }
        return this.ProphecyJobId;
    }

    private String CatalystOptimizersPackage() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 332");
        }
        return this.CatalystOptimizersPackage;
    }

    private Seq<String> CatalystOptimizerExcludedRules() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 333");
        }
        return this.CatalystOptimizerExcludedRules;
    }

    private String CatalystExcludedRules() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 346");
        }
        return this.CatalystExcludedRules;
    }

    private String DatabricksCatalystOptimizersPackage() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 349");
        }
        return this.DatabricksCatalystOptimizersPackage;
    }

    private Seq<String> DatabricksCatalystOptimizerExcludedRules() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 350");
        }
        return this.DatabricksCatalystOptimizerExcludedRules;
    }

    private String DatabricksCatalystExcludedRules() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 351");
        }
        return this.DatabricksCatalystExcludedRules;
    }

    public String AllExcludesRules() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /mnt/jenkins-temp/ReleaseProphecyLibsScala/src/main/scala/org/apache/spark/sql/ProphecySparkSession.scala: 354");
        }
        return this.AllExcludesRules;
    }

    @Py4JWhitelist
    public String getAllExcludesRules() {
        return this.AllExcludesRules();
    }

    public ProphecySparkSession.ProphecySparkThrowable getProphecyThrowable(Option<String> gemName, Throwable throwable) {
        ProphecySparkSession.ProphecySparkThrowable prophecySparkThrowable;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ProphecySparkSession.ProphecySparkThrowable) {
            ProphecySparkSession.ProphecySparkThrowable prophecySparkThrowable2;
            prophecySparkThrowable = prophecySparkThrowable2 = (ProphecySparkSession.ProphecySparkThrowable)((Object)throwable2);
        } else if (throwable2 instanceof AnalysisException) {
            AnalysisException analysisException = (AnalysisException)throwable2;
            prophecySparkThrowable = new ProphecySparkSession.ProphecySparkAnalysisThrowable(gemName, analysisException);
        } else if (throwable2 instanceof SparkException) {
            SparkException sparkException = (SparkException)throwable2;
            prophecySparkThrowable = new ProphecySparkSession.ProphecySparkCoreException(gemName, sparkException);
        } else if (throwable2 instanceof Exception) {
            Exception exception = (Exception)throwable2;
            prophecySparkThrowable = new ProphecySparkSession.ProphecySparkInternalException(gemName, exception);
        } else if (throwable2 != null) {
            Throwable throwable3 = throwable2;
            prophecySparkThrowable = new ProphecySparkSession.ProphecySparkInternalException(gemName, new Exception(throwable3));
        } else {
            throw new MatchError((Object)throwable2);
        }
        return prophecySparkThrowable;
    }

    public String extractHierarchicalGemName(String fullClassName) {
        Tuple2 tuple2;
        String string;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Full class name for gem name extraction {}", new Object[]{fullClassName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String databricksKeyword = "iw$Interactive";
        String livyKeyword = "$iw";
        String jobKeyword = ".graph";
        int n = fullClassName.indexOf(jobKeyword);
        block0 : switch (n) {
            case -1: {
                int n2 = fullClassName.lastIndexOf(46);
                switch (n2) {
                    case -1: {
                        string = fullClassName;
                        break block0;
                    }
                }
                string = fullClassName.substring(n2 + 1);
                break;
            }
            default: {
                string = fullClassName.substring(n + jobKeyword.length() + 1);
                break;
            }
        }
        String className = string;
        Tuple2 tuple22 = tuple2 = className.indexOf(databricksKeyword) != -1 ? Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(className.indexOf(databricksKeyword) + databricksKeyword.length()))), (Object)databricksKeyword) : Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(className.lastIndexOf(livyKeyword) + livyKeyword.length()))), (Object)livyKeyword);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int startIndex = tuple2._1$mcI$sp();
        String keyword = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)startIndex), (Object)keyword);
        Tuple2 tuple24 = tuple23;
        int startIndex2 = tuple24._1$mcI$sp();
        String keyword2 = (String)tuple24._2();
        String relevantPart = startIndex2 > keyword2.length() - 1 && startIndex2 < className.length() ? className.substring(startIndex2) : className;
        String[] parts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])relevantPart.split("\\$"))).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ProphecySparkSession$.$anonfun$extractHierarchicalGemName$1(x$17)));
        String string2 = keyword2;
        String string3 = databricksKeyword;
        String[] filteredParts = !(string2 != null ? !string2.equals(string3) : string3 != null) && parts.length > 1 ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).drop(1) : parts;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredParts)).mkString(".");
    }

    public long org$apache$spark$sql$ProphecySparkSession$$preciseTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public ProphecySparkSession apply(SparkSession spark) {
        return new ProphecySparkSession(spark);
    }

    public Option<SparkSession> unapply(ProphecySparkSession x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.spark());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$sendPipelineProgressEventInternal$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ long $anonfun$sendPipelineProgressEventInternal$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ long $anonfun$sendGemProgressEvent$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$sendGemProgressEvent$4(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ long $anonfun$sendGemProgressEvent$7(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toLong();
    }

    public static final /* synthetic */ void $anonfun$relayGemProgressForValidProcess$1(SparkSession spark$3, String _session$3, Option _stdout$1, Option _stderr$1, long startTime$1, Option endTime$1, String taskState$1, Option serializableException$1, Option processId$1, String process2) {
        Some some;
        List empty;
        Some some2;
        List empty2;
        String executionSession = (String)MetricsCollector$.MODULE$.getUniqueSessionId(spark$3).getOrElse((Function0 & Serializable & scala.Serializable)() -> _session$3);
        Option<InMemoryStore> store = MODULE$.getInMemoryStore(spark$3, _session$3);
        Option option = _stdout$1;
        Object object = option instanceof Some && (empty2 = (List)(some2 = (Some)option).value()).isEmpty() ? None$.MODULE$ : option;
        Option stdout = object;
        Option option2 = _stderr$1;
        Object object2 = option2 instanceof Some && (empty = (List)(some = (Some)option2).value()).isEmpty() ? None$.MODULE$ : option2;
        Option stderr = object2;
        store.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.updateGemProgress(process2, startTime$1, (Option<Object>)endTime$1, (Option<List<InMemoryStore.TimestampedOutput>>)stdout, (Option<List<InMemoryStore.TimestampedOutput>>)stderr, taskState$1, (Option<SerializableException>)serializableException$1);
            return BoxedUnit.UNIT;
        });
        spark$3.sparkContext().listenerBus().post((SparkListenerEvent)new ProphecyGemProgressEvent(executionSession, (Option<String>)processId$1, taskState$1, startTime$1, (Option<Object>)endTime$1, (Option<List<InMemoryStore.TimestampedOutput>>)stdout, (Option<List<InMemoryStore.TimestampedOutput>>)stderr, (Option<SerializableException>)serializableException$1));
    }

    public static final /* synthetic */ boolean $anonfun$extractHierarchicalGemName$1(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).nonEmpty();
    }

    private ProphecySparkSession$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        ExceptionExtensions.$init$(this);
        this.ProphecyJobId = "prophecy.job.id";
        this.bitmap$init$0 |= 2;
        this.CatalystOptimizersPackage = "org.apache.spark.sql.catalyst.optimizer";
        this.bitmap$init$0 |= 4;
        this.CatalystOptimizerExcludedRules = (Seq)new .colon.colon((Object)"ColumnPruning", (List)new .colon.colon((Object)"CollapseProject", (List)new .colon.colon((Object)"CombineFilters", (List)new .colon.colon((Object)"EliminateLimits", (List)new .colon.colon((Object)"PruneFilters", (List)new .colon.colon((Object)"RemoveDispensableExpressions", (List)new .colon.colon((Object)"PushDownPredicates", (List)Nil$.MODULE$)))))));
        this.bitmap$init$0 |= 8;
        this.CatalystExcludedRules = ((TraversableOnce)this.CatalystOptimizerExcludedRules().map((Function1 & Serializable & scala.Serializable)rule -> new StringBuilder(1).append(MODULE$.CatalystOptimizersPackage()).append(".").append((String)rule).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        this.bitmap$init$0 |= 0x10;
        this.DatabricksCatalystOptimizersPackage = "com.databricks.sql.optimizer";
        this.bitmap$init$0 |= 0x20;
        this.DatabricksCatalystOptimizerExcludedRules = (Seq)new .colon.colon((Object)"PushProjectThroughLimit", (List)Nil$.MODULE$);
        this.bitmap$init$0 |= 0x40;
        this.DatabricksCatalystExcludedRules = ((TraversableOnce)this.DatabricksCatalystOptimizerExcludedRules().map((Function1 & Serializable & scala.Serializable)rule -> new StringBuilder(1).append(MODULE$.DatabricksCatalystOptimizersPackage()).append(".").append((String)rule).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        this.bitmap$init$0 |= 0x80;
        this.AllExcludesRules = new StringBuilder(2).append(this.CatalystExcludedRules()).append(", ").append(this.DatabricksCatalystExcludedRules()).toString();
        this.bitmap$init$0 |= 0x100;
    }
}

