/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.crosssupport;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.abinitio.ScalaFunctions$;
import io.prophecy.abinitio.dml.DMLSchema$;
import io.prophecy.libs.AbinitioDMLs;
import io.prophecy.libs.AbinitioDMLs$file_information_type$;
import io.prophecy.libs.FFAST;
import io.prophecy.libs.FFCompoundSchemaRow;
import io.prophecy.libs.FFCompoundType;
import io.prophecy.libs.FFConditionalSchemaRow;
import io.prophecy.libs.FFDefaultVal;
import io.prophecy.libs.FFDoubleDefaultVal;
import io.prophecy.libs.FFIncludeFileRow;
import io.prophecy.libs.FFIntDefaultVal;
import io.prophecy.libs.FFSchemaRecord;
import io.prophecy.libs.FFSchemaRow;
import io.prophecy.libs.FFSimpleSchemaList;
import io.prophecy.libs.FFSimpleSchemaRow;
import io.prophecy.libs.FFStringDefaultVal;
import io.prophecy.libs.FFStructArrayType;
import io.prophecy.libs.FFStructType;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ozone.OzoneFileSystem;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Slice;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkFunctionsCrossSupport$
implements LazyLogging {
    public static SparkFunctionsCrossSupport$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SparkFunctionsCrossSupport$();
    }

    private Logger logger$lzycompute() {
        SparkFunctionsCrossSupport$ sparkFunctionsCrossSupport$ = this;
        synchronized (sparkFunctionsCrossSupport$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Column string_join(Column column, String delimiter) {
        return functions$.MODULE$.array_join(column, delimiter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Column, String> replaceNullWithDefaultValue(Column input, FFSchemaRow row2) {
        Tuple2 res;
        FFSchemaRow fFSchemaRow;
        FFCompoundSchemaRow fFCompoundSchemaRow;
        boolean bl;
        while (true) {
            FFSchemaRow schemaRow;
            boolean bl2 = false;
            FFSimpleSchemaRow fFSimpleSchemaRow = null;
            bl = false;
            fFCompoundSchemaRow = null;
            fFSchemaRow = row2;
            if (fFSchemaRow instanceof FFSimpleSchemaRow) {
                bl2 = true;
                fFSimpleSchemaRow = (FFSimpleSchemaRow)fFSchemaRow;
                String name = fFSimpleSchemaRow.name();
                FFDefaultVal value = fFSimpleSchemaRow.value();
                if (value instanceof FFIntDefaultVal) {
                    FFIntDefaultVal fFIntDefaultVal = (FFIntDefaultVal)value;
                    return new Tuple2((Object)functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{input, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)fFIntDefaultVal.value()))})), (Object)name);
                }
            }
            if (bl2) {
                String name = fFSimpleSchemaRow.name();
                FFDefaultVal value = fFSimpleSchemaRow.value();
                if (value instanceof FFStringDefaultVal) {
                    FFStringDefaultVal fFStringDefaultVal = (FFStringDefaultVal)value;
                    return new Tuple2((Object)functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{input, functions$.MODULE$.lit((Object)fFStringDefaultVal.value())})), (Object)name);
                }
            }
            if (bl2) {
                String name = fFSimpleSchemaRow.name();
                FFDefaultVal value = fFSimpleSchemaRow.value();
                if (value instanceof FFDoubleDefaultVal) {
                    FFDoubleDefaultVal fFDoubleDefaultVal = (FFDoubleDefaultVal)value;
                    return new Tuple2((Object)functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{input, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)fFDoubleDefaultVal.value()))})), (Object)name);
                }
            }
            if (bl2) {
                String name = fFSimpleSchemaRow.name();
                return new Tuple2((Object)input, (Object)name);
            }
            if (fFSchemaRow instanceof FFSimpleSchemaList) {
                FFSimpleSchemaList fFSimpleSchemaList = (FFSimpleSchemaList)fFSchemaRow;
                Seq<FFSimpleSchemaRow> rows = fFSimpleSchemaList.rows();
                return new Tuple2((Object)functions$.MODULE$.struct((Seq)((TraversableLike)rows.map((Function1 & Serializable & scala.Serializable)row -> MODULE$.replaceNullWithDefaultValue(input, (FFSchemaRow)row), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> new StringOps(Predef$.MODULE$.augmentString((String)e._2())).nonEmpty() ? ((Column)e._1()).as((String)e._2()) : (Column)e._1(), Seq$.MODULE$.canBuildFrom())), (Object)"");
            }
            if (!(fFSchemaRow instanceof FFConditionalSchemaRow)) break;
            FFConditionalSchemaRow fFConditionalSchemaRow = (FFConditionalSchemaRow)fFSchemaRow;
            row2 = schemaRow = fFConditionalSchemaRow.schemaRow();
        }
        if (fFSchemaRow instanceof FFIncludeFileRow) {
            return new Tuple2((Object)input, (Object)"");
        }
        if (fFSchemaRow instanceof FFCompoundSchemaRow) {
            bl = true;
            fFCompoundSchemaRow = (FFCompoundSchemaRow)fFSchemaRow;
            FFCompoundType compound = fFCompoundSchemaRow.compound();
            Seq<FFSchemaRow> rows = fFCompoundSchemaRow.rows();
            if (compound instanceof FFStructArrayType) {
                FFStructArrayType fFStructArrayType = (FFStructArrayType)compound;
                Column column = functions$.MODULE$.transform(input, (Function1 & Serializable & scala.Serializable)x -> (Column)MODULE$.replaceNullWithDefaultValue((Column)x, new FFCompoundSchemaRow(new FFStructType(fFStructArrayType.name1(), fFStructArrayType.typeName()), rows))._1());
                return new Tuple2((Object)column, (Object)fFStructArrayType.name1());
            }
        }
        if (!bl) return new Tuple2((Object)input, (Object)"");
        FFCompoundType compound = fFCompoundSchemaRow.compound();
        Seq<FFSchemaRow> rows = fFCompoundSchemaRow.rows();
        Seq innerColNames = (Seq)rows.flatMap((Function1 & Serializable & scala.Serializable)row -> ScalaFunctions$.MODULE$.getRowName((FFSchemaRow)row), Seq$.MODULE$.canBuildFrom());
        return rows.length() == innerColNames.length() ? (res = new Tuple2((Object)functions$.MODULE$.struct((Seq)((TraversableLike)((TraversableLike)rows.zip((GenIterable)innerColNames, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FFSchemaRow row = (FFSchemaRow)tuple2._1();
            String colName = (String)tuple2._2();
            Tuple2<Column, String> tuple22 = MODULE$.replaceNullWithDefaultValue(input.getField(colName), row);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> new StringOps(Predef$.MODULE$.augmentString((String)e._2())).nonEmpty() ? ((Column)e._1()).as((String)e._2()) : (Column)e._1(), Seq$.MODULE$.canBuildFrom())), compound.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))) : new Tuple2((Object)input, compound.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public Column replaceNullWithDefaultValues(Column input, String schema) {
        Column column;
        try {
            Column column2;
            FFAST fFAST = DMLSchema$.MODULE$.parse(schema, true, true, DMLSchema$.MODULE$.parse$default$4(), DMLSchema$.MODULE$.parse$default$5());
            if (fFAST instanceof FFSchemaRecord) {
                FFSchemaRecord fFSchemaRecord = (FFSchemaRecord)fFAST;
                column2 = this.replaceNullWithDefaultValues(input, fFSchemaRecord);
            } else {
                column2 = input;
            }
            column = column2;
        }
        catch (Throwable throwable) {
            column = input;
        }
        return column;
    }

    private Column replaceNullWithDefaultValues(Column input, FFSchemaRecord schema) {
        Column res;
        Seq columnWithName;
        Seq<String> innerColNames = ScalaFunctions$.MODULE$.getTopLevelColumns((Option<FFAST>)new Some((Object)schema));
        return schema.rows().length() == innerColNames.length() ? (schema.rows().length() == 1 ? (Column)this.replaceNullWithDefaultValue(input, (FFSchemaRow)schema.rows().head())._1() : ((columnWithName = (Seq)((TraversableLike)schema.rows().zip(innerColNames, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FFSchemaRow row = (FFSchemaRow)tuple2._1();
            String colName = (String)tuple2._2();
            Tuple2<Column, String> tuple22 = MODULE$.replaceNullWithDefaultValue(input.getField(colName), row);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).length() == 1 ? (Column)((Tuple2)columnWithName.head())._1() : (res = functions$.MODULE$.struct((Seq)columnWithName.map((Function1 & Serializable & scala.Serializable)e -> new StringOps(Predef$.MODULE$.augmentString((String)e._2())).nonEmpty() ? ((Column)e._1()).as((String)e._2()) : (Column)e._1(), Seq$.MODULE$.canBuildFrom()))))) : input;
    }

    public Column array_except(Column column1, Column column2) {
        return functions$.MODULE$.array_except(column1, column2);
    }

    public Column array_position(Column column, Object value) {
        return functions$.MODULE$.array_position(column, value);
    }

    public Column element_at(Column input, Column index) {
        return functions$.MODULE$.element_at(input, (Object)index);
    }

    public String removeNonFileExtension(String inputPath) {
        String result = inputPath.startsWith("hdfs://") ? inputPath.substring(6) : (inputPath.startsWith("hdfs:/") ? inputPath.substring(5) : (inputPath.startsWith("file:///") ? inputPath.substring(7) : (inputPath.startsWith("file://") ? inputPath.substring(6) : (inputPath.startsWith("file:/") ? inputPath.substring(5) : (inputPath.startsWith("mfs") ? inputPath.substring(3) : inputPath)))));
        return result.replaceAll("\\$\\{", "").replaceAll("}", "");
    }

    public AbinitioDMLs.file_information_type file_information_def(String inputPath, boolean useLocalFileSystem) {
        AbinitioDMLs.file_information_type file_information_type2;
        byte readable = 0;
        byte writable = 0;
        byte executable = 0;
        byte found = 0;
        String[][] hosts = (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        String fileType = "FILE";
        try {
            FileStatus[] fileStatusArray;
            if (inputPath.startsWith("o3fs:")) {
                OzoneFileSystem ozoneFS = new OzoneFileSystem();
                ozoneFS.initialize(new URI(inputPath), new Configuration());
                Path path = new Path(inputPath);
                try {
                    hosts = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ozoneFS.getFileBlockLocations(path, 0L, Integer.MAX_VALUE))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHosts(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                fileStatusArray = ozoneFS.exists(path) ? ozoneFS.listStatus(path) : (FileStatus[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileStatus.class));
            } else if (useLocalFileSystem) {
                LocalFileSystem localFS = new LocalFileSystem();
                String modifiedPath = this.removeNonFileExtension(inputPath);
                localFS.initialize(new URI(new StringBuilder(7).append("file://").append(modifiedPath).toString()), new Configuration());
                Path path = new Path(modifiedPath);
                try {
                    hosts = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localFS.getFileBlockLocations(path, 0L, Integer.MAX_VALUE))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHosts(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                fileStatusArray = localFS.exists(path) ? localFS.listStatus(path) : (FileStatus[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileStatus.class));
            } else if (inputPath.startsWith("hdfs:")) {
                fileType = "HDFS";
                Path sourcePath = new Path(inputPath);
                FileSystem sourceFileSystem = sourcePath.getFileSystem(new Configuration());
                try {
                    hosts = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFileSystem.getFileBlockLocations(sourcePath, 0L, Integer.MAX_VALUE))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHosts(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                fileStatusArray = sourceFileSystem.exists(sourcePath) ? sourceFileSystem.listStatus(sourcePath) : (FileStatus[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileStatus.class));
            } else if (inputPath.startsWith("file:")) {
                BoxedUnit boxedUnit;
                LocalFileSystem localFS = new LocalFileSystem();
                String modifiedPath = this.removeNonFileExtension(inputPath);
                localFS.initialize(new URI(new StringBuilder(7).append("file://").append(modifiedPath).toString()), new Configuration());
                Configuration configuration = new Configuration();
                FileSystem fs = FileSystem.get((Configuration)configuration);
                Path curPath = new Path(modifiedPath);
                try {
                    hosts = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localFS.getFileBlockLocations(curPath, 0L, Integer.MAX_VALUE))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getHosts(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error calling getFileBlockLocations", e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                fileStatusArray = fs.exists(curPath) ? fs.listStatus(curPath) : (FileStatus[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileStatus.class));
            } else {
                Path sourcePath = new Path(inputPath);
                FileSystem sourceFileSystem = sourcePath.getFileSystem(new Configuration());
                try {
                    fileType = sourceFileSystem.getScheme().toUpperCase();
                    hosts = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFileSystem.getFileBlockLocations(sourcePath, 0L, Integer.MAX_VALUE))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getHosts(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                fileStatusArray = sourceFileSystem.exists(sourcePath) ? sourceFileSystem.listStatus(sourcePath) : (FileStatus[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileStatus.class));
            }
            FileStatus[] fileList = fileStatusArray;
            FileStatus status = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileList)).head();
            String userPermission = status.getPermission().getUserAction().SYMBOL;
            String groupPermission = status.getPermission().getGroupAction().SYMBOL;
            String otherPermission = status.getPermission().getOtherAction().SYMBOL;
            found = 1;
            if (userPermission.charAt(0) == 'r' && groupPermission.charAt(0) == 'r' && otherPermission.charAt(0) == 'r') {
                readable = 1;
            }
            if (userPermission.charAt(1) == 'w' && groupPermission.charAt(1) == 'w' && otherPermission.charAt(1) == 'w') {
                writable = 1;
            }
            if (otherPermission.charAt(2) == 'x' && groupPermission.charAt(2) == 'x' && otherPermission.charAt(2) == 'x') {
                executable = 1;
            }
            long x$12 = status.getModificationTime() / 1000L;
            long x$22 = status.getLen();
            String x$32 = status.getGroup();
            String x$42 = status.getOwner();
            String[][] x$52 = hosts;
            long x$6 = status.getLen() / status.getBlockSize();
            long x$7 = status.getBlockSize();
            String x$8 = status.isDirectory() ? "DIR " : fileType;
            byte x$9 = readable;
            byte x$10 = writable;
            byte x$11 = executable;
            byte x$122 = found;
            long x$13 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$10();
            long x$14 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$11();
            long x$15 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$12();
            long x$16 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$13();
            long x$17 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$14();
            String x$18 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$18();
            file_information_type2 = new AbinitioDMLs.file_information_type(x$122, x$9, x$10, x$11, x$8, x$52, x$22, x$7, x$6, x$13, x$14, x$15, x$16, x$17, x$12, x$42, x$32, x$18);
        }
        catch (Throwable e) {
            String x$19 = "";
            byte x$20 = readable;
            byte x$21 = writable;
            byte x$22 = executable;
            byte x$23 = found;
            String[][] x$24 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$6();
            long x$25 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$7();
            long x$26 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$8();
            long x$27 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$9();
            long x$28 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$10();
            long x$29 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$11();
            long x$30 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$12();
            long x$31 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$13();
            long x$32 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$14();
            long x$33 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$15();
            String x$34 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$16();
            String x$35 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$17();
            String x$36 = AbinitioDMLs$file_information_type$.MODULE$.apply$default$18();
            file_information_type2 = new AbinitioDMLs.file_information_type(x$23, x$20, x$21, x$22, x$19, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
        }
        return file_information_type2;
    }

    public boolean file_information_def$default$2() {
        return false;
    }

    public Column zip_eventInfo_arrays(Column column1, Column column2) {
        return functions$.MODULE$.arrays_zip((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{column1, column2}));
    }

    public Column getFieldFromStructByPosition(Column column, int position) {
        return column.getField(String.valueOf(BoxesRunTime.boxToInteger((int)(position - 1))));
    }

    public Column slice(Column x, Column start, Column length) {
        return Column$.MODULE$.apply((Expression)new Slice(x.expr(), start.expr(), length.expr()));
    }

    private SparkFunctionsCrossSupport$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

