/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.executionmetrics;

import com.databricks.dbutils_v1.DBUtilsHolder$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.executionmetrics.package;
import org.apache.spark.sql.executionmetrics.package$FileContent$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ZipFileExtractor$
implements LazyLogging {
    public static ZipFileExtractor$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ZipFileExtractor$();
    }

    private Logger logger$lzycompute() {
        ZipFileExtractor$ zipFileExtractor$ = this;
        synchronized (zipFileExtractor$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private Either<Throwable, ZipFile> zipFile(File file) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ZipFile zipFile;
            String string = file.getName();
            if (string.endsWith(".jar")) {
                zipFile = new JarFile(file);
            } else if (string.endsWith(".whl")) {
                zipFile = new ZipFile(file);
            } else {
                throw new RuntimeException(new StringBuilder(21).append("Unknown Extension ").append(string).append("!! ").toString());
            }
            return zipFile;
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(21).append("error opening zip `").append(file).append("``").toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Left().apply((Object)exception);
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            ZipFile value = (ZipFile)success.value();
            right = package$.MODULE$.Right().apply((Object)value);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    private Either<Throwable, List<package.FileContent>> unzip(String zipPath) {
        Left left;
        Either<Throwable, ZipFile> either = this.zipFile(new File(zipPath));
        if (either instanceof Right) {
            Right right = (Right)either;
            ZipFile zip = (ZipFile)right.value();
            left = package$.MODULE$.Right().apply((Object)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(zip.entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)package$FileContent$.MODULE$.isCodeOrConfig(entry.getName()))).map((Function1 & Serializable & scala.Serializable)entry -> {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zip.getInputStream((ZipEntry)entry)));
                String content = package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> bufferedReader.readLine()).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZipFileExtractor$.$anonfun$unzip$4(x$1))).mkString("\n");
                return new package.FileContent(entry.getName(), content);
            }).toList());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            Throwable err = (Throwable)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public Either<Throwable, List<package.FileContent>> extract(String path) {
        Left left;
        File file = new File(path);
        String toPath = new StringBuilder(33).append("/tmp/prophecy/workspaces/package/").append(file.getName()).toString();
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String toLocalDiskPath = new StringBuilder(7).append("file://").append(toPath).toString();
            return DBUtilsHolder$.MODULE$.dbutils().fs().cp(path, toLocalDiskPath, DBUtilsHolder$.MODULE$.dbutils().fs().cp$default$3());
        }).map((Function1 & Serializable & scala.Serializable)x0$1 -> ZipFileExtractor$.$anonfun$extract$2(path, toPath, BoxesRunTime.unboxToBoolean((Object)x0$1))).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            FileSystem fs = FileSystem.get((URI)URI.create(path), (Configuration)new Configuration());
            fs.copyToLocalFile(new Path(path), new Path(toPath));
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }));
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(29).append("Failed to copy file from ").append(path).append(" to ").append(toPath).toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = package$.MODULE$.Left().apply((Object)new RuntimeException(new StringBuilder(29).append("Failed to copy file from ").append(path).append(" to ").append(toPath).toString(), exception));
        } else if (try_ instanceof Success) {
            left = this.unzip(toPath);
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$unzip$4(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ Either $anonfun$extract$2(String path$1, String toPath$1, boolean x0$1) {
        Right right;
        boolean bl = x0$1;
        if (bl) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Successfully copied file from {} to {}", (Object[])new String[]{path$1, toPath$1});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (!bl) {
            right = package$.MODULE$.Left().apply((Object)new RuntimeException("Couldn't copy file."));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return right;
    }

    private ZipFileExtractor$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

