/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.prophecy.util.fuzzy;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.prophecy.util.fuzzy.FuzzyMatch;
import org.apache.spark.sql.prophecy.util.fuzzy.FuzzyMatch$;
import org.apache.spark.sql.prophecy.util.fuzzy.FuzzyMatchMerge$;
import org.apache.spark.sql.prophecy.util.fuzzy.MatchField;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\t\u0013\u0001\u0005B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u00039\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!Q1A\u0005\u00025C\u0001B\u0017\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006E\u0002!\te\u0019\u0005\bs\u0002\t\n\u0011\"\u0001{\u000f\u001d\tYA\u0005E\u0001\u0003\u001b1a!\u0005\n\t\u0002\u0005=\u0001BB.\u000e\t\u0003\t\t\u0002C\u0004\u0002\u00145!\t!!\u0006\t\u000f\u0005MQ\u0002\"\u0001\u0002 \tya)\u001e>{s6\u000bGo\u00195NKJ<WM\u0003\u0002\u0014)\u0005)a-\u001e>{s*\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u00181\u0005A\u0001O]8qQ\u0016\u001c\u0017P\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001E!b\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\t!#\u0003\u0002,%\tQa)\u001e>{s6\u000bGo\u00195\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001D:dC2\fGn\\4hS:<'BA\u00193\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001a\u0002\u0007\r|W.\u0003\u00026]\tYA*\u0019>z\u0019><w-\u001b8h\u0003!\u0011XmY8sI&#W#\u0001\u001d\u0011\u0005e\u0002eB\u0001\u001e?!\tYD%D\u0001=\u0015\ti\u0004%\u0001\u0004=e>|GOP\u0005\u0003\u007f\u0011\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011q\bJ\u0001\ne\u0016\u001cwN\u001d3JI\u0002\n\u0001b]8ve\u000e,\u0017\nZ\u0001\ng>,(oY3JI\u0002\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u0003!\u0003\"aI%\n\u0005)##A\u0002#pk\ndW-\u0001\u0006uQJ,7\u000f[8mI\u0002\n1\"\\1uG\"4\u0015.\u001a7egV\ta\nE\u0002P)^s!\u0001\u0015*\u000f\u0005m\n\u0016\"A\u0013\n\u0005M#\u0013a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019F\u0005\u0005\u0002*1&\u0011\u0011L\u0005\u0002\u000b\u001b\u0006$8\r\u001b$jK2$\u0017\u0001D7bi\u000eDg)[3mIN\u0004\u0013A\u0002\u001fj]&$h\bF\u0003^=~\u0003\u0017\r\u0005\u0002*\u0001!)a'\u0003a\u0001q!)A)\u0003a\u0001q!)a)\u0003a\u0001\u0011\")A*\u0003a\u0001\u001d\u0006\u0019!/\u001e8\u0015\u0007\u0011\u0014H\u000f\u0005\u0002f_:\u0011aM\u001c\b\u0003O6t!\u0001\u001b7\u000f\u0005%\\gBA\u001ek\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$\u0003\u0002\u001a5%\u00111\u000bG\u0005\u0003aF\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005MC\u0002\"B:\u000b\u0001\u0004!\u0017!\u00033bi\u00064%/Y7f\u0011\u001d)(\u0002%AA\u0002Y\fa#\u001b8dYV$WmU5nS2\f'/\u001b;z'\u000e|'/\u001a\t\u0003G]L!\u0001\u001f\u0013\u0003\u000f\t{w\u000e\\3b]\u0006i!/\u001e8%I\u00164\u0017-\u001e7uII*\u0012a\u001f\u0016\u0003mr\\\u0013! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0002%\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0013y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ya)\u001e>{s6\u000bGo\u00195NKJ<W\r\u0005\u0002*\u001bM\u0011QB\t\u000b\u0003\u0003\u001b\tQ!\u00199qYf$\u0012\"XA\f\u00033\tY\"!\b\t\u000bYz\u0001\u0019\u0001\u001d\t\u000b\u0011{\u0001\u0019\u0001\u001d\t\u000b\u0019{\u0001\u0019\u0001%\t\u000b1{\u0001\u0019\u0001(\u0015\u0013u\u000b\t#a\t\u0002&\u0005\u001d\u0002\"\u0002\u001c\u0011\u0001\u0004A\u0004\"\u0002#\u0011\u0001\u0004A\u0004\"\u0002$\u0011\u0001\u0004A\u0005bBA\u0015!\u0001\u0007\u00111F\u0001\u000f[\u0006$8\r\u001b$jK2$7/T1q!\u0015I\u0014Q\u0006\u001d9\u0013\r\tyC\u0011\u0002\u0004\u001b\u0006\u0004\b")
public class FuzzyMatchMerge
implements FuzzyMatch,
LazyLogging {
    private final String recordId;
    private final String sourceId;
    private final double threshold;
    private final Seq<MatchField> matchFields;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static FuzzyMatchMerge apply(String string, String string2, double d, Map<String, String> map) {
        return FuzzyMatchMerge$.MODULE$.apply(string, string2, d, map);
    }

    public static FuzzyMatchMerge apply(String string, String string2, double d, Seq<MatchField> seq) {
        return FuzzyMatchMerge$.MODULE$.apply(string, string2, d, seq);
    }

    @Override
    public Column similarityDistance(Seq<MatchField> matchFields, Dataset<Row> debugDF) {
        return FuzzyMatch.similarityDistance$(this, matchFields, debugDF);
    }

    @Override
    public Dataset<Row> similarityDistance$default$2() {
        return FuzzyMatch.similarityDistance$default$2$(this);
    }

    private Logger logger$lzycompute() {
        FuzzyMatchMerge fuzzyMatchMerge = this;
        synchronized (fuzzyMatchMerge) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String recordId() {
        return this.recordId;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public double threshold() {
        return this.threshold;
    }

    public Seq<MatchField> matchFields() {
        return this.matchFields;
    }

    @Override
    public Dataset<Row> run(Dataset<Row> dataFrame, boolean includeSimilarityScore) {
        BoxedUnit boxedUnit;
        Seq selectedColumns = (Seq)new .colon.colon((Object)functions$.MODULE$.col((String)FuzzyMatch$.MODULE$.df1().apply((Object)this.recordId())).as(this.recordId()), (List)new .colon.colon((Object)functions$.MODULE$.col((String)FuzzyMatch$.MODULE$.df2().apply((Object)this.recordId())).as((String)FuzzyMatch$.MODULE$.col2().apply((Object)this.recordId())), (List)Nil$.MODULE$));
        Seq outputCols = includeSimilarityScore ? (Seq)selectedColumns.$colon$plus((Object)functions$.MODULE$.col("similarityScore"), Seq$.MODULE$.canBuildFrom()) : selectedColumns;
        Dataset distinctSourcesDF = dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.sourceId())})).distinct().filter(functions$.MODULE$.col(this.sourceId()).isNotNull()).cache();
        String[] distinctSources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distinctSourcesDF.collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(0).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (distinctSources.length < 2) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("At least two distinct sourceIds are required, found {}", new Object[]{BoxesRunTime.boxToInteger((int)distinctSources.length)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        IndexedSeq sourcePairs = (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distinctSources)).indices().flatMap((Function1 & Serializable & scala.Serializable)i -> FuzzyMatchMerge.$anonfun$run$2(distinctSources, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq matchedDataFrames = (IndexedSeq)sourcePairs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Dataset outputDF;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String sourceA = (String)tuple2._1();
            String sourceB = (String)tuple2._2();
            Dataset firstSourceDF = dataFrame.filter(functions$.MODULE$.col(this.sourceId()).$eq$eq$eq((Object)sourceA));
            Dataset secondSourceDF = dataFrame.filter(functions$.MODULE$.col(this.sourceId()).$eq$eq$eq((Object)sourceB));
            Dataset crossJoinedDF = firstSourceDF.alias("df1").crossJoin(secondSourceDF.alias("df2")).where(functions$.MODULE$.col((String)FuzzyMatch$.MODULE$.df1().apply((Object)this.recordId())).$eq$bang$eq((Object)functions$.MODULE$.col((String)FuzzyMatch$.MODULE$.df2().apply((Object)this.recordId()))));
            Dataset dataset = outputDF = crossJoinedDF.withColumn("similarityScore", this.similarityDistance(this.matchFields(), null)).filter(functions$.MODULE$.col("similarityScore").$greater((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)this.threshold())))).select(outputCols);
            return dataset;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Dataset finalResultDF = (Dataset)matchedDataFrames.reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.union(x$3));
        finalResultDF.show(false);
        return FuzzyMatch$.MODULE$.removePairDuplicates(this.recordId(), (Dataset<Row>)finalResultDF);
    }

    public boolean run$default$2() {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$run$3(String[] distinctSources$1, int i$1, int j) {
        return new Tuple2((Object)distinctSources$1[i$1], (Object)distinctSources$1[j]);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$run$2(String[] distinctSources$1, int i) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(i + 1), distinctSources$1.length).map((Function1 & Serializable & scala.Serializable)j -> FuzzyMatchMerge.$anonfun$run$3(distinctSources$1, i, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public FuzzyMatchMerge(String recordId, String sourceId, double threshold, Seq<MatchField> matchFields) {
        this.recordId = recordId;
        this.sourceId = sourceId;
        this.threshold = threshold;
        this.matchFields = matchFields;
        FuzzyMatch.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

