/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs;

import io.prophecy.libs.SparkTestingUtils;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.io.FileUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class SparkTestingUtils$ {
    public static SparkTestingUtils$ MODULE$;

    static {
        new SparkTestingUtils$();
    }

    public SparkTestingUtils.StringColumnExtensions addDTMethods(String s) {
        return new SparkTestingUtils.StringColumnExtensions(s);
    }

    public String readResource(String path) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(Paths.get(this.getClass().getResource(path).toURI()))).asScala()).mkString("\n");
    }

    public scala.collection.immutable.Map<String, DataType> schemaToFieldMap(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField == null) {
                throw new MatchError((Object)structField);
            }
            String name = structField.name();
            DataType dataType = structField.dataType();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)name.toLowerCase()), (Object)dataType);
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Object> defaultsForSchema(StructType schema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField == null) {
                throw new MatchError((Object)structField);
            }
            String name = structField.name();
            DataType dataType = structField.dataType();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)name.toLowerCase()), MODULE$.defaultForDatatype().apply((Object)dataType));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public PartialFunction<DataType, Object> defaultForDatatype() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (StringType$.MODULE$.equals(A1)) {
                    object = "";
                } else if (IntegerType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToInteger((int)0);
                } else if (ShortType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToShort((short)((short)0));
                } else if (LongType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToLong((long)0L);
                } else if (ByteType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToByte((byte)((byte)0));
                } else if (FloatType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToFloat((float)((float)0.0));
                } else if (DoubleType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToDouble((double)0.0);
                } else if (BinaryType$.MODULE$.equals(A1)) {
                    object = new byte[]{(byte)0};
                } else if (BooleanType$.MODULE$.equals(A1)) {
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                } else if (DateType$.MODULE$.equals(A1)) {
                    object = new Date(System.currentTimeMillis());
                } else if (TimestampType$.MODULE$.equals(A1)) {
                    object = new Timestamp(System.currentTimeMillis());
                } else if (A1 instanceof DecimalType) {
                    object = new BigDecimal(0);
                } else if (A1 != null) {
                    A1 A12 = A1;
                    object = new Exception(new StringBuilder(38).append("default value for datatype: ").append(A12).append(" not found").toString());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(DataType x1) {
                DataType dataType = x1;
                boolean bl = StringType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (BinaryType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (dataType instanceof DecimalType ? true : dataType != null)))))))))));
                return bl;
            }
        };
    }

    public Object convertStringValueToDatatype(DataType dataType, String value) {
        Object object;
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2)) {
            object = value;
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string2 = "null";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? null : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string3 = "null";
            object = !(string != null ? !string.equals(string3) : string3 != null) ? null : BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(value)).toShort());
        } else if (LongType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string4 = "null";
            object = !(string != null ? !string.equals(string4) : string4 != null) ? null : BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string5 = "null";
            object = !(string != null ? !string.equals(string5) : string5 != null) ? null : BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(value)).toByte());
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string6 = "null";
            object = !(string != null ? !string.equals(string6) : string6 != null) ? null : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(value)).toFloat());
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string7 = "null";
            object = !(string != null ? !string.equals(string7) : string7 != null) ? null : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value)).toDouble());
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string8 = "null";
            object = !(string != null ? !string.equals(string8) : string8 != null) ? null : (Object[])new scala.collection.immutable.IndexedSeq[]{(scala.collection.immutable.IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(value)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)SparkTestingUtils$.$anonfun$convertStringValueToDatatype$1(BoxesRunTime.unboxToChar((Object)x$1))), Predef$.MODULE$.fallbackStringCanBuildFrom())};
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string9 = "null";
            object = !(string != null ? !string.equals(string9) : string9 != null) ? null : BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean());
        } else if (DateType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string10 = "null";
            object = !(string != null ? !string.equals(string10) : string10 != null) ? null : Date.valueOf(value);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            String string = value.toLowerCase();
            String string11 = "null";
            object = !(string != null ? !string.equals(string11) : string11 != null) ? null : this.addDTMethods(value).toDateTime();
        } else if (dataType2 instanceof DecimalType) {
            String string = value.toLowerCase();
            String string12 = "null";
            object = !(string != null ? !string.equals(string12) : string12 != null) ? null : new BigDecimal(value);
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(49).append("Unrecognized type: ").append(dataType).append(", returning same value for it.").toString());
            object = value;
        }
        return object;
    }

    public boolean rowEquals(Row r1, Row r2, double tol) {
        boolean bl;
        Object object = new Object();
        try {
            if (r1.length() != r2.length()) {
                return false;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), r1.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                block2: {
                    if (r1.isNullAt(idx) != r2.isNullAt(idx)) {
                        throw new NonLocalReturnControl.mcZ.sp(object, false);
                    }
                    if (r1.isNullAt(idx)) break block2;
                    Object o1 = r1.get(idx);
                    Object o2 = r2.get(idx);
                    Object object = o1;
                    String string = o1.toString();
                    String string2 = o2.toString();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new NonLocalReturnControl.mcZ.sp(object, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Dataset<Row> nullify(Dataset<Row> df) {
        Seq exprs = (Seq)df.schema().map((Function1 & Serializable & scala.Serializable)f -> {
            DataType dataType = f.dataType();
            Column column = StringType$.MODULE$.equals(dataType) ? functions$.MODULE$.when(functions$.MODULE$.col(f.name()).$eq$eq$eq((Object)"null"), (Object)functions$.MODULE$.lit(null).cast((DataType)StringType$.MODULE$)).otherwise((Object)functions$.MODULE$.col(f.name())).as(f.name()) : functions$.MODULE$.col(f.name());
            return column;
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        return df.select(exprs);
    }

    public Dataset<Row> createDF(SparkSession spark, Seq<String> columns, Seq<Seq<Object>> values2, scala.collection.immutable.Map<String, Object> defaults, scala.collection.immutable.Map<String, DataType> typeMap, String port) {
        Seq loweredColumns = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toLowerCase(), scala.collection.Seq$.MODULE$.canBuildFrom());
        List missingColumns = (List)((TraversableOnce)defaults.keySet().$minus$minus((GenTraversableOnce)columns.toSet())).toList().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SparkTestingUtils$.$anonfun$createDF$2(loweredColumns, x)));
        Seq allColumns = (Seq)columns.$plus$plus((GenTraversableOnce)missingColumns, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq allValues = (Seq)values2.map((Function1 & Serializable & scala.Serializable)row -> {
            Seq rowWithData = (Seq)((TraversableLike)columns.zipWithIndex(scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String columnName = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                Object object = ((Option)row.lift().apply((Object)BoxesRunTime.boxToInteger((int)idx))).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaults.apply((Object)columnName));
                return object;
            }, scala.collection.Seq$.MODULE$.canBuildFrom());
            return (Seq)rowWithData.$plus$plus((GenTraversableOnce)missingColumns.map((Function1 & Serializable & scala.Serializable)column -> defaults.apply(column), List$.MODULE$.canBuildFrom()), scala.collection.Seq$.MODULE$.canBuildFrom());
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        RDD rdd = spark.sparkContext().parallelize((Seq)allValues.map((Function1 & Serializable & scala.Serializable)values -> Row$.MODULE$.fromSeq(values), scala.collection.Seq$.MODULE$.canBuildFrom()), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = StructType$.MODULE$.apply((Seq)allColumns.map((Function1 & Serializable & scala.Serializable)column -> new StructField(column, (DataType)typeMap.getOrElse(column, (Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), scala.collection.Seq$.MODULE$.canBuildFrom()));
        Dataset<Row> df = spark.createDataFrame(rdd, schema);
        return port.startsWith("out") ? this.nullify(df) : df;
    }

    public Dataset<Row> postProcess(Dataset<Row> origDf) {
        Dataset df = origDf.na().fill("null");
        return df.sqlContext().createDataFrame(df.rdd(), StructType$.MODULE$.apply((Seq)df.schema().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean x$1 = true;
            String x$2 = x$3.copy$default$1();
            DataType x$32 = x$3.copy$default$2();
            Metadata x$4 = x$3.copy$default$4();
            return x$3.copy(x$2, x$32, x$1, x$4);
        }, scala.collection.Seq$.MODULE$.canBuildFrom())));
    }

    public Either<Error, String> assertDFEquals(Dataset<Row> expectedUnsorted, Dataset<Row> resultUnsorted, int maxUnequalRowsToShow, double tol) {
        Either either;
        Dataset expected = SparkTestingUtils$._sort$1(this.postProcess(expectedUnsorted));
        Dataset result = SparkTestingUtils$._sort$1(this.postProcess(resultUnsorted));
        try {
            expected.rdd().cache();
            result.rdd().cache();
            either = (Either)SparkTestingUtils$._assertEqualsCount$1(expected, result, maxUnequalRowsToShow).fold((Function1 & Serializable & scala.Serializable)x$4 -> package$.MODULE$.Left().apply(x$4), (Function1 & Serializable & scala.Serializable)x$5 -> (Either)SparkTestingUtils$._assertEqualsTypes$1(expected, result).fold((Function1 & Serializable & scala.Serializable)x$6 -> package$.MODULE$.Left().apply(x$6), (Function1 & Serializable & scala.Serializable)x$7 -> (Either)SparkTestingUtils$._assertEqualsValues$1(expected, result, tol, maxUnequalRowsToShow).fold((Function1 & Serializable & scala.Serializable)x$8 -> package$.MODULE$.Left().apply(x$8), (Function1 & Serializable & scala.Serializable)x -> package$.MODULE$.Right().apply(x))));
        }
        finally {
            expected.rdd().unpersist(expected.rdd().unpersist$default$1());
            result.rdd().unpersist(result.rdd().unpersist$default$1());
        }
        return either;
    }

    public double assertDFEquals$default$4() {
        return 0.0;
    }

    public Dataset<Row> createDfFromSchemaFile(SparkSession spark, String schemaDefinitionPath, String port, Seq<String> columns, Seq<Seq<Object>> values) {
        StructType schema = (StructType)DataType$.MODULE$.fromJson(this.readResource(schemaDefinitionPath));
        return this.createDF(spark, columns, values, this.defaultsForSchema(schema), this.schemaToFieldMap(schema), port);
    }

    public Dataset<Row> createDfFromResourceFiles(SparkSession spark, String schemaDefinitionPath, String dataPath, String port) {
        StructType schema = (StructType)DataType$.MODULE$.fromJson(this.readResource(schemaDefinitionPath));
        scala.collection.immutable.Map colDataMap = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)col -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)col.name().toLowerCase()), (Object)col.dataType()), scala.collection.Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        JsValue jsonData = Json$.MODULE$.parse(this.readResource(dataPath));
        IndexedSeq cols = (IndexedSeq)((JsArray)JsLookup$.MODULE$.apply$extension1(JsValue$.MODULE$.jsValueToJsLookup(jsonData), "columns").as((Reads)Reads$.MODULE$.JsArrayReads())).value().map((Function1 & Serializable & scala.Serializable)x$9 -> ((String)x$9.as((Reads)Reads$.MODULE$.StringReads())).toLowerCase(), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq data = (IndexedSeq)((JsArray)JsLookup$.MODULE$.apply$extension1(JsValue$.MODULE$.jsValueToJsLookup(jsonData), "values").as((Reads)Reads$.MODULE$.JsArrayReads())).value().map((Function1 & Serializable & scala.Serializable)row -> (IndexedSeq)((JsArray)row.as((Reads)Reads$.MODULE$.JsArrayReads())).value().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            JsValue jsValue = x0$1;
            if (JsNull$.MODULE$.equals(jsValue)) {
                string = "null";
            } else if (jsValue instanceof JsBoolean) {
                JsBoolean jsBoolean = (JsBoolean)jsValue;
                string = Boolean.toString(jsBoolean.value());
            } else if (jsValue instanceof JsNumber) {
                JsNumber jsNumber = (JsNumber)jsValue;
                scala.math.BigDecimal value = jsNumber.value();
                string = value.toString();
            } else if (jsValue instanceof JsString) {
                String value;
                JsString jsString = (JsString)jsValue;
                string = value = jsString.value();
            } else if (jsValue instanceof JsArray) {
                JsArray jsArray = (JsArray)jsValue;
                IndexedSeq value = jsArray.value();
                string = value;
            } else if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                Map value = jsObject.underlying$access$0();
                string = value;
            } else {
                throw new MatchError((Object)jsValue);
            }
            return string;
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        List values = ((TraversableOnce)data.map((Function1 & Serializable & scala.Serializable)row -> ((TraversableOnce)((TraversableLike)row.zip((GenIterable)cols, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object value = tuple2._1();
                String colName = (String)tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    if (colName != null) {
                        Object object;
                        String string2 = colName;
                        DataType dataType = (DataType)colDataMap.apply((Object)string2);
                        if (StringType$.MODULE$.equals(dataType)) {
                            String string3 = string;
                            String string4 = "";
                            if (string3 == null) {
                                if (string4 == null) return "";
                            } else if (string3.equals(string4)) {
                                return "";
                            }
                            String string5 = string;
                            object = string5;
                            return object;
                        } else if (IntegerType$.MODULE$.equals(dataType)) {
                            String string6 = string;
                            String string7 = "";
                            object = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(string)).toInt());
                            return object;
                        } else if (ShortType$.MODULE$.equals(dataType)) {
                            String string8 = string;
                            String string9 = "";
                            object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? BoxesRunTime.boxToShort((short)((short)0)) : BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(string)).toShort());
                            return object;
                        } else if (LongType$.MODULE$.equals(dataType)) {
                            String string10 = string;
                            String string11 = "";
                            object = !(string10 != null ? !string10.equals(string11) : string11 != null) ? BoxesRunTime.boxToLong((long)0L) : BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(string)).toLong());
                            return object;
                        } else if (ByteType$.MODULE$.equals(dataType)) {
                            String string12 = string;
                            String string13 = "";
                            object = !(string12 != null ? !string12.equals(string13) : string13 != null) ? BoxesRunTime.boxToByte((byte)((byte)0)) : BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(string)).toByte());
                            return object;
                        } else if (FloatType$.MODULE$.equals(dataType)) {
                            String string14 = string;
                            String string15 = "";
                            object = !(string14 != null ? !string14.equals(string15) : string15 != null) ? BoxesRunTime.boxToFloat((float)((float)0.0)) : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat());
                            return object;
                        } else if (DoubleType$.MODULE$.equals(dataType)) {
                            String string16 = string;
                            String string17 = "";
                            object = !(string16 != null ? !string16.equals(string17) : string17 != null) ? BoxesRunTime.boxToDouble((double)0.0) : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                            return object;
                        } else if (BinaryType$.MODULE$.equals(dataType)) {
                            Object[] objectArray;
                            String string18 = string;
                            String string19 = "";
                            if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                byte[] byArray = new byte[1];
                                objectArray = byArray;
                                byArray[0] = (byte)0;
                            } else {
                                objectArray = new scala.collection.immutable.IndexedSeq[]{(scala.collection.immutable.IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(string)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToByte((byte)SparkTestingUtils$.$anonfun$createDfFromResourceFiles$7(BoxesRunTime.unboxToChar((Object)x$10))), Predef$.MODULE$.fallbackStringCanBuildFrom())};
                            }
                            object = objectArray;
                            return object;
                        } else if (BooleanType$.MODULE$.equals(dataType)) {
                            String string20 = string;
                            String string21 = "";
                            object = !(string20 != null ? !string20.equals(string21) : string21 != null) ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(string)).toBoolean());
                            return object;
                        } else if (DateType$.MODULE$.equals(dataType)) {
                            String string22 = string;
                            String string23 = "";
                            object = !(string22 != null ? !string22.equals(string23) : string23 != null) ? new Date(System.currentTimeMillis()) : MODULE$.addDTMethods(string).toDate();
                            return object;
                        } else if (TimestampType$.MODULE$.equals(dataType)) {
                            String string24 = string;
                            String string25 = "";
                            object = !(string24 != null ? !string24.equals(string25) : string25 != null) ? new Timestamp(System.currentTimeMillis()) : MODULE$.addDTMethods(string).toDateTime();
                            return object;
                        } else {
                            if (!DecimalType$.MODULE$.unapply(dataType)) throw new MatchError((Object)dataType);
                            String string26 = string;
                            String string27 = "";
                            object = !(string26 != null ? !string26.equals(string27) : string27 != null) ? new BigDecimal(0) : new BigDecimal(string);
                        }
                        return object;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            return "";
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList(), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        return this.createDF(spark, (Seq<String>)cols, (Seq<Seq<Object>>)values, this.defaultsForSchema(schema), this.schemaToFieldMap(schema), port);
    }

    public Dataset<Row> readData(SparkSession spark, StructType schema, String path) {
        scala.collection.immutable.Seq dataArray = (scala.collection.immutable.Seq)Json$.MODULE$.parse(FileUtils.readFileToString((File)new File(path), (Charset)Charset.defaultCharset())).as(Reads$.MODULE$.traversableReads(List$.MODULE$.canBuildFrom(), (Reads)Reads$.MODULE$.JsArrayReads()));
        scala.collection.immutable.Seq rowSeq = (scala.collection.immutable.Seq)dataArray.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.fromSeq(SparkTestingUtils$.asSeq$1(row, schema)), Seq$.MODULE$.canBuildFrom());
        return spark.createDataFrame(spark.sparkContext().parallelize((Seq)rowSeq, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), schema);
    }

    public void writeData(String pathPrefix, String fileName, Dataset<Row> df, String separator, int maxRows) {
        Files.createDirectories(Paths.get(pathPrefix, new String[0]), new FileAttribute[0]);
        String headers = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).mkString(separator).concat("\n");
        String fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.take(maxRows))).map((Function1 & Serializable & scala.Serializable)row -> MODULE$.mkString((Row)row, separator), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
        FileUtils.writeStringToFile((File)new File(new StringBuilder(1).append(pathPrefix).append("/").append(fileName).toString()), (String)new StringBuilder(0).append(headers).append(fields).toString(), (String)StandardCharsets.UTF_8.name());
    }

    public int writeData$default$5() {
        return 100;
    }

    public String mkString(Row row, String sep) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.size()).map((Function1 & Serializable & scala.Serializable)i -> SparkTestingUtils$.$anonfun$mkString$1(row, BoxesRunTime.unboxToInt((Object)i)), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).mkString(sep);
    }

    public static final /* synthetic */ byte $anonfun$convertStringValueToDatatype$1(char x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ boolean $anonfun$createDF$2(Seq loweredColumns$1, String x) {
        return !loweredColumns$1.contains((Object)x.toLowerCase());
    }

    private static final Dataset _sort$1(Dataset df) {
        return df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
    }

    private static final Tuple2[] fetchTypes$1(Dataset df) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    private static final Either _assertEqualsTypes$1(Dataset dfExpected, Dataset dfActual) {
        Tuple2[] expectedTypes = SparkTestingUtils$.fetchTypes$1(dfExpected);
        Tuple2[] actualTypes = SparkTestingUtils$.fetchTypes$1(dfActual);
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedTypes)).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])actualTypes)))).isEmpty() ? package$.MODULE$.Left().apply((Object)new Error(new StringBuilder(21).append("Types NOT equal! ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedTypes)).mkString(",")).append("\t!=\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualTypes)).mkString(",")).toString())) : package$.MODULE$.Right().apply((Object)"");
    }

    private static final Either _assertEqualsCount$1(Dataset dfExpected, Dataset dfActual, int maxUnequalRowsToShow$1) {
        return dfExpected.rdd().count() != dfActual.rdd().count() ? package$.MODULE$.Left().apply((Object)new Error(new StringBuilder(37).append("Length not Equal.").append("\nExpected: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dfExpected.take(maxUnequalRowsToShow$1))).mkString(",")).append("\nActual: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dfActual.take(maxUnequalRowsToShow$1))).mkString(",")).toString())) : package$.MODULE$.Right().apply((Object)"");
    }

    public static final /* synthetic */ boolean $anonfun$assertDFEquals$5(double tol$1, Tuple2 x0$3) {
        Row r2;
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$3;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        Row r1 = (Row)tuple2._1();
        boolean bl = !MODULE$.rowEquals(r1, r2 = (Row)tuple2._2(), tol$1);
        return bl;
    }

    private static final Either _assertEqualsValues$1(Dataset dfExpected, Dataset dfActual, double tol$1, int maxUnequalRowsToShow$1) {
        RDD expectedVal = dfExpected.rdd().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row row = (Row)tuple2._1();
            long idx = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)idx), (Object)row);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD resultVal = dfActual.rdd().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row row = (Row)tuple2._1();
            long idx = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)idx), (Object)row);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD unequalRDD = RDD$.MODULE$.rddToPairRDDFunctions(expectedVal, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Long$.MODULE$).join(resultVal).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)SparkTestingUtils$.$anonfun$assertDFEquals$5(tol$1, x0$3)));
        return ((Tuple2[])unequalRDD.take(maxUnequalRowsToShow$1)).length != 0 ? package$.MODULE$.Left().apply((Object)new Error(new StringBuilder(29).append("Expected != Actual\nMismatch: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unequalRDD.take(maxUnequalRowsToShow$1))).mkString("    +    ")).toString())) : package$.MODULE$.Right().apply((Object)"");
    }

    public static final /* synthetic */ byte $anonfun$createDfFromResourceFiles$7(char x$10) {
        return (byte)x$10;
    }

    private static final Seq asSeq$1(JsArray values, StructType schema) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)field -> {
            String value = JsLookup$.MODULE$.apply$extension0(JsValue$.MODULE$.jsValueToJsLookup((JsValue)values), field._2$mcI$sp()).toString();
            String trimmed = value.substring(1, value.length() - 1);
            return MODULE$.convertStringValueToDatatype(((StructField)field._1()).dataType(), trimmed);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public static final /* synthetic */ Object $anonfun$mkString$1(Row row$2, int i) {
        Object object;
        Object object2 = row$2.get(i);
        if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = timestamp.toLocalDateTime();
        } else {
            object = object2 == null ? "null" : object2.toString();
        }
        return object;
    }

    private SparkTestingUtils$() {
        MODULE$ = this;
    }
}

