/*
 * Decompiled with CFR 0.152.
 */
package io.prophecy.libs;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.response.HealthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.response.LookupResponse;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.prophecy.libs.secrets.package;
import java.io.Serializable;
import java.util.Collections;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class VaultUtils$
implements LazyLogging {
    public static VaultUtils$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new VaultUtils$();
    }

    private Logger logger$lzycompute() {
        VaultUtils$ vaultUtils$ = this;
        synchronized (vaultUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public VaultConfig getVaultConfig(Option<String> address, Option<String> token) {
        VaultConfig vaultConfig;
        VaultConfig vaultConfig2;
        VaultConfig config = new VaultConfig();
        Option<String> option = address;
        if (option instanceof Some) {
            Some some = (Some)option;
            String addr = (String)some.value();
            vaultConfig2 = config.address(addr);
        } else if (None$.MODULE$.equals(option)) {
            vaultConfig2 = config;
        } else {
            throw new MatchError(option);
        }
        config = vaultConfig2;
        Option<String> option2 = token;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String tok = (String)some.value();
            vaultConfig = config.token(tok);
        } else if (None$.MODULE$.equals(option2)) {
            vaultConfig = config;
        } else {
            throw new MatchError(option2);
        }
        config = vaultConfig;
        return config.build();
    }

    public Option<String> getVaultConfig$default$1() {
        return None$.MODULE$;
    }

    public Option<String> getVaultConfig$default$2() {
        return None$.MODULE$;
    }

    public Vault getVaultClient(Option<String> address, Option<String> token) {
        VaultConfig config = this.getVaultConfig(address, token);
        return new Vault(config).withRetries(3, 25);
    }

    public Option<String> getVaultClient$default$1() {
        return None$.MODULE$;
    }

    public Option<String> getVaultClient$default$2() {
        return None$.MODULE$;
    }

    public HealthResponse vaultHealth(package.HashiCorpConnectionDetails connection) {
        return this.getVaultClient(connection.address(), connection.token()).debug().health();
    }

    public LookupResponse tokenHealth(package.HashiCorpConnectionDetails connection) {
        return this.getVaultClient(connection.address(), connection.token()).auth().lookupSelf();
    }

    public String getVaultSecret(String scope, String key, Option<Vault> vault, Option<String> address, Option<String> token) {
        String string;
        Option<Vault> option = vault;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vault v = (Vault)some.value();
            string = (String)v.logical().read(scope).getData().get(key);
        } else if (None$.MODULE$.equals(option)) {
            Vault vault2 = this.getVaultClient(address, token);
            string = (String)vault2.logical().read(scope).getData().get(key);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public Option<Vault> getVaultSecret$default$3() {
        return None$.MODULE$;
    }

    public Option<String> getVaultSecret$default$4() {
        return None$.MODULE$;
    }

    public Option<String> getVaultSecret$default$5() {
        return None$.MODULE$;
    }

    public Option<String> getSecret(String path, String key, package.HashiCorpConnectionDetails connection) {
        Vault vault = this.getVaultClient(connection.address(), connection.token());
        return Option$.MODULE$.apply(vault.withRetries(3, 100).logical().read(path).getData().get(key));
    }

    public Map<String, List<String>> listSecrets(package.HashiCorpConnectionDetails connection) {
        Vault vault = this.getVaultClient(connection.address(), connection.token());
        List mounts = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(vault.mounts().list().getMounts().keySet()).asScala()).toList().sorted((Ordering)Ordering.String$.MODULE$);
        Logical logical = vault.logical();
        return ((TraversableOnce)((List)mounts.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.recurseSecretHoldersFromPath(logical, (String)x$1), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String basePath = (String)tuple2._1();
            List secretHolderPaths = (List)tuple2._2();
            List list = (List)secretHolderPaths.map((Function1 & Serializable & scala.Serializable)subPath -> {
                String fullPath = new StringBuilder(0).append(basePath).append((String)subPath).toString();
                return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)fullPath), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(MODULE$.secretsAtPath(logical, fullPath)).asScala()).keys().toList());
            }, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public LogicalResponse overwriteSecret(String path, String key, String value, package.HashiCorpConnectionDetails connection) {
        return this.getVaultClient(connection.address(), connection.token()).logical().write(path, Collections.singletonMap(key, value));
    }

    public LogicalResponse appendSecret(String path, String key, String value, package.HashiCorpConnectionDetails connection) {
        Logical logicalDB = this.getVaultClient(connection.address(), connection.token()).logical();
        java.util.Map<String, Object> secrets = this.secretsAtPath(logicalDB, path);
        secrets.put(key, value);
        return logicalDB.write(path, secrets);
    }

    public LogicalResponse deleteSecret(String path, String key, package.HashiCorpConnectionDetails connection) {
        Logical logicalDB = this.getVaultClient(connection.address(), connection.token()).logical();
        java.util.Map<String, Object> secrets = this.secretsAtPath(logicalDB, path);
        secrets.remove(key);
        return logicalDB.write(path, secrets);
    }

    private java.util.Map<String, Object> secretsAtPath(Logical logicalDB, String path) {
        return (java.util.Map)Option$.MODULE$.apply((Object)logicalDB.read(path)).flatMap((Function1 & Serializable & scala.Serializable)res -> Option$.MODULE$.apply((Object)res.getData())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap());
    }

    private List<String> listItemsInPath(Logical logicalDB, String path) {
        return (List)Option$.MODULE$.apply((Object)logicalDB.list(path)).flatMap((Function1 & Serializable & scala.Serializable)secrets -> Option$.MODULE$.apply((Object)secrets.getListData())).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).toList()).toList().flatten((Function1)Predef$.MODULE$.$conforms());
    }

    private List<String> safeListItemsInPath(Logical logicalDB, String path) {
        List list;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.listItemsInPath(logicalDB, path));
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(33).append("Couldn't fetch secrets from path ").append(path).toString(), exception);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            list = Nil$.MODULE$;
        } else if (try_ instanceof Success) {
            List value;
            Success success = (Success)try_;
            list = value = (List)success.value();
        } else {
            throw new MatchError((Object)try_);
        }
        return list;
    }

    private Map<String, List<String>> recurseSecretHoldersFromPath(Logical logicalDB, String initialPath) {
        return this.recursiveLookup$1((List)new .colon.colon((Object)initialPath, (List)Nil$.MODULE$), Predef$.MODULE$.Map().empty(), logicalDB);
    }

    private final Map recursiveLookup$1(List pathsToCheck, Map acc, Logical logicalDB$2) {
        block2: {
            List list;
            while (true) {
                if (Nil$.MODULE$.equals(list = pathsToCheck)) break block2;
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                String path = (String)colon2.head();
                List remainingPaths = colon2.tl$access$1();
                Tuple2 tuple2 = (Tuple2)this.safeListItemsInPath(logicalDB$2, path).foldLeft((Object)new Tuple2((Object)acc, (Object)remainingPaths), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    String subPath = (String)tuple22._2();
                    if (tuple23 == null) throw new MatchError((Object)tuple22);
                    Map currentAcc = (Map)tuple23._1();
                    List paths = (List)tuple23._2();
                    String fullPath = new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(path)).stripSuffix("/")).append("/").append(subPath).toString();
                    if (subPath.endsWith("/")) {
                        String string = fullPath;
                        Tuple2 tuple24 = new Tuple2((Object)currentAcc, (Object)paths.$colon$colon((Object)string));
                        tuple2 = tuple24;
                        return tuple2;
                    } else {
                        tuple2 = new Tuple2((Object)currentAcc.$plus(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)path), ((SeqLike)currentAcc.getOrElse((Object)path, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).$colon$plus((Object)subPath, List$.MODULE$.canBuildFrom()))), (Object)paths);
                    }
                    return tuple2;
                });
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Map updatedAcc = (Map)tuple2._1();
                List newPaths = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)updatedAcc, (Object)newPaths);
                Tuple2 tuple23 = tuple22;
                Map updatedAcc2 = (Map)tuple23._1();
                List newPaths2 = (List)tuple23._2();
                acc = updatedAcc2;
                pathsToCheck = newPaths2;
            }
            throw new MatchError((Object)list);
        }
        Map map = acc;
        return map;
    }

    private VaultUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

