/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.Joiner;
import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.SourceCodeLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractElement
implements Element {
    protected SourceCodeLocation sourceCodeLocation;
    protected List<String> comments;

    @Override
    public SourceCodeLocation getSourceCodeLocation() {
        if (this.sourceCodeLocation == null) {
            return SourceCodeLocation.UNKNOWN;
        }
        return this.sourceCodeLocation;
    }

    public void setSourceCodeLocation(SourceCodeLocation sourceCodeLocation) {
        this.sourceCodeLocation = sourceCodeLocation;
    }

    @Override
    public List<String> getCommentLines() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return this.comments;
    }

    @Override
    public String getComments() {
        return Joiner.on('\n').join(this.getCommentLines());
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public void addComment(String line) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(line);
    }
}

