/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractElement;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Group;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Oneof
extends AbstractElement
implements FieldContainer,
GroupContainer {
    protected final Message parent;
    protected String name;
    protected List<Field> fields;
    protected List<Group> groups;
    protected String namespace;

    public Oneof(Message parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Message getParent() {
        return this.parent;
    }

    public String getNamespace() {
        return this.parent.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public List<Field> getFields() {
        if (this.fields == null) {
            return Collections.emptyList();
        }
        return this.fields;
    }

    @Override
    public int getFieldCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.size();
    }

    @Override
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public void addField(Field field) {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        this.fields.add(field);
    }

    @Override
    public Field getField(String name) {
        for (Field field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Override
    public Field getField(int tag) {
        for (Field field : this.getFields()) {
            if (tag != field.getTag()) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<Group> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    @Override
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public void addGroup(Group group) {
        if (this.groups == null) {
            this.groups = new ArrayList<Group>();
        }
        this.groups.add(group);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("fields", this.fields).toString();
    }
}

