/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractUserTypeContainer;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Package;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.Syntax;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Proto
extends AbstractUserTypeContainer
implements UserTypeContainer {
    protected Module module;
    protected ProtoContext context;
    protected String filename;
    protected Syntax syntax;
    protected Package aPackage;
    protected List<Import> imports;
    protected List<Service> services;

    public Proto() {
        super(null);
    }

    public ProtoContext getContext() {
        return this.context;
    }

    public void setContext(ProtoContext context) {
        this.context = context;
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.PROTO;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public Syntax getSyntax() {
        if (this.syntax == null) {
            return Syntax.DEFAULT;
        }
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public boolean isSyntaxSet() {
        return this.syntax != null;
    }

    public Package getPackage() {
        if (this.aPackage == null) {
            return Package.DEFAULT;
        }
        return this.aPackage;
    }

    public void setPackage(Package aPackage) {
        this.aPackage = aPackage;
    }

    public boolean isPackageSet() {
        return this.aPackage != null;
    }

    public List<Import> getImports() {
        if (this.imports == null) {
            return Collections.emptyList();
        }
        return this.imports;
    }

    public void setImports(List<Import> imports) {
        this.imports = imports;
    }

    public List<Import> getPublicImports() {
        return this.getImports().stream().filter(Import::isPublic).collect(Collectors.toList());
    }

    public void addImport(Import anImport) {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>();
        }
        this.imports.add(anImport);
    }

    public List<Service> getServices() {
        if (this.services == null) {
            return Collections.emptyList();
        }
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void addService(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("filename", this.filename).toString();
    }

    @Override
    public String getNamespace() {
        if (this.aPackage == null) {
            return ".";
        }
        return "." + this.aPackage.getValue() + ".";
    }

    public String getCanonicalName() {
        if (this.aPackage == null) {
            return this.name;
        }
        return this.aPackage + "." + this.name;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

