/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import io.protostuff.compiler.model.FieldType;
import java.util.HashMap;
import java.util.Map;

public enum ScalarFieldType implements FieldType
{
    INT32,
    INT64,
    UINT32,
    UINT64,
    SINT32,
    SINT64,
    FIXED32,
    FIXED64,
    SFIXED32,
    SFIXED64,
    FLOAT,
    DOUBLE,
    BOOL,
    STRING,
    BYTES;

    private static Map<String, ScalarFieldType> map;

    public static ScalarFieldType getByName(String name) {
        return map.get(name);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    public boolean isString() {
        return this == STRING;
    }

    public boolean isBytes() {
        return this == BYTES;
    }

    public String toString() {
        return this.getName();
    }

    static {
        map = new HashMap<String, ScalarFieldType>();
        for (ScalarFieldType type : ScalarFieldType.values()) {
            map.put(type.getFullyQualifiedName(), type);
        }
    }
}

