/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.AbstractElement;
import io.protostuff.compiler.model.SourceCodeLocation;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParserBaseListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public abstract class AbstractProtoParserListener
extends ProtoParserBaseListener {
    protected final ProtoContext context;
    private final BufferedTokenStream tokens;
    private BitSet usedComments;

    protected AbstractProtoParserListener(BufferedTokenStream tokens, ProtoContext context) {
        this.context = context;
        this.tokens = tokens;
        this.usedComments = new BitSet();
    }

    protected SourceCodeLocation getSourceCodeLocation(ParserRuleContext ctx) {
        String file = this.context.getProto().getFilename();
        int line = ctx.getStart().getLine();
        return new SourceCodeLocation(file, line);
    }

    protected void attachComments(ParserRuleContext ctx, AbstractElement element, boolean addTrailingComment) {
        List<Token> tokensAfter;
        ArrayList<String> comments = new ArrayList<String>();
        Token stop = ctx.getStop();
        Token start = ctx.getStart();
        List<Token> tokensBefore = this.tokens.getHiddenTokensToLeft(start.getTokenIndex(), 1);
        if (tokensBefore != null) {
            int i;
            for (i = tokensBefore.size(); !(i <= 0 || this.usedComments.get(tokensBefore.get(i - 1).getLine()) || tokensBefore.get(i - 1).getType() != 40 && tokensBefore.get(i - 1).getText().contains("\n")); --i) {
            }
            while (i < tokensBefore.size()) {
                Token token = tokensBefore.get(i);
                if (token.getType() == 40) {
                    String text = this.getTextFromLineCommentToken(token);
                    comments.add(text);
                    this.usedComments.set(token.getLine());
                }
                ++i;
            }
        }
        if (addTrailingComment && (tokensAfter = this.tokens.getHiddenTokensToRight(stop.getTokenIndex(), 1)) != null && tokensAfter.size() > 0) {
            for (Token token : tokensAfter) {
                if (token.getType() == 40) {
                    String text = this.getTextFromLineCommentToken(token);
                    comments.add(text);
                    this.usedComments.set(token.getLine());
                    break;
                }
                if (!token.getText().contains("\n")) continue;
                break;
            }
        }
        List<String> trimComments = this.trim(comments);
        for (String comment : trimComments) {
            element.addComment(comment);
        }
    }

    protected List<String> trim(List<String> comments) {
        ArrayList<String> trimComments = new ArrayList<String>();
        int n = 0;
        boolean tryRemoveWhitespace = true;
        while (tryRemoveWhitespace) {
            boolean allLinesAreShorter = true;
            for (String comment : comments) {
                if (comment.length() <= n) continue;
                if (comment.charAt(n) != ' ') {
                    tryRemoveWhitespace = false;
                }
                allLinesAreShorter = false;
            }
            if (allLinesAreShorter) break;
            if (!tryRemoveWhitespace) continue;
            ++n;
        }
        for (String comment : comments) {
            if (comment.length() > n) {
                String substring = comment.substring(n);
                trimComments.add(substring);
                continue;
            }
            trimComments.add("");
        }
        return trimComments;
    }

    protected String getTextFromLineCommentToken(Token token) {
        String comment = token.getText().trim();
        return comment.substring(2);
    }
}

