/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.AbstractUserTypeContainer;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.ExtensionContainer;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.FieldModifier;
import io.protostuff.compiler.model.Group;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.MessageContainer;
import io.protostuff.compiler.model.Oneof;
import io.protostuff.compiler.model.Range;
import io.protostuff.compiler.model.SourceCodeLocation;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import io.protostuff.compiler.parser.Util;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MessageParseListener
extends AbstractProtoParserListener {
    public static final String MAX = "max";
    public static final String OPTION_MAP_ENTRY = ".google.protobuf.map_entry";
    public static final String MAP_ENTRY_KEY = "key";
    public static final String MAP_ENTRY_VALUE = "value";

    public MessageParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
    }

    @Override
    public void enterMessageBlock(ProtoParser.MessageBlockContext ctx) {
        UserTypeContainer parent = this.context.peek(UserTypeContainer.class);
        Message message = new Message(parent);
        this.context.push(message);
    }

    @Override
    public void exitMessageBlock(ProtoParser.MessageBlockContext ctx) {
        Message message = this.context.pop(Message.class);
        MessageContainer container = this.context.peek(MessageContainer.class);
        String name = ctx.name().getText();
        message.setName(name);
        message.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        container.addMessage(message);
        this.attachComments(ctx, message, false);
    }

    @Override
    public void exitReserved(ProtoParser.ReservedContext ctx) {
        ProtoParser.FieldNamesContext fieldNamesContext;
        Message message = this.context.peek(Message.class);
        ProtoParser.RangesContext ranges = ctx.ranges();
        if (ranges != null) {
            List<Range> result = this.getRanges(message, ranges);
            for (Range range : result) {
                message.addReservedFieldRange(range);
            }
        }
        if ((fieldNamesContext = ctx.fieldNames()) != null) {
            for (ProtoParser.FieldNameContext fieldNameContext : fieldNamesContext.fieldName()) {
                String fieldName = fieldNameContext.getText();
                fieldName = Util.removeFirstAndLastChar(fieldName);
                message.addReservedFieldName(fieldName);
            }
        }
    }

    @Override
    public void enterField(ProtoParser.FieldContext ctx) {
        FieldContainer parent = this.context.peek(FieldContainer.class);
        Field field = new Field(parent);
        this.context.push(field);
    }

    @Override
    public void exitField(ProtoParser.FieldContext ctx) {
        Field field = this.context.pop(Field.class);
        FieldContainer fieldContainer = this.context.peek(FieldContainer.class);
        String name = ctx.name().getText();
        String type = ctx.typeReference().getText();
        Integer tag = Integer.decode(ctx.INTEGER_VALUE().getText());
        this.updateModifier(ctx.fieldModifier(), field);
        field.setName(name);
        field.setTag(tag);
        field.setIndex(fieldContainer.getFieldCount() + 1);
        field.setTypeName(type);
        field.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        fieldContainer.addField(field);
        this.attachComments(ctx, field, true);
    }

    @Override
    public void enterExtendBlock(ProtoParser.ExtendBlockContext ctx) {
        UserTypeContainer parent = this.context.peek(UserTypeContainer.class);
        Extension extension = new Extension(parent);
        this.context.push(extension);
    }

    @Override
    public void exitExtendBlock(ProtoParser.ExtendBlockContext ctx) {
        Extension extension = this.context.pop(Extension.class);
        String extendeeName = ctx.typeReference().getText();
        ExtensionContainer extensionContainer = this.context.peek(AbstractUserTypeContainer.class);
        extension.setExtendeeName(extendeeName);
        extension.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        extensionContainer.addDeclaredExtension(extension);
    }

    @Override
    public void enterGroupBlock(ProtoParser.GroupBlockContext ctx) {
        Element parent = this.context.peek(Element.class);
        if (parent instanceof Extension) {
            Group group = new Group(((Extension)parent).getParent());
            this.context.push(group);
        } else if (parent instanceof UserTypeContainer) {
            Group group = new Group((UserTypeContainer)parent);
            this.context.push(group);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void exitGroupBlock(ProtoParser.GroupBlockContext ctx) {
        Group group = this.context.pop(Group.class);
        group.setName(ctx.name().getText());
        group.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        GroupContainer groupContainer = this.context.peek(GroupContainer.class);
        FieldContainer fieldContainer = this.context.peek(FieldContainer.class);
        Field field = new Field(fieldContainer);
        field.setName(group.getName().toLowerCase());
        int tag = Integer.decode(ctx.INTEGER_VALUE().getText());
        field.setTag(tag);
        field.setIndex(fieldContainer.getFieldCount() + 1);
        field.setTypeName(group.getName());
        field.setType(group);
        field.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        groupContainer.addGroup(group);
        fieldContainer.addField(field);
        this.attachComments(ctx, field, true);
    }

    @Override
    public void enterOneof(ProtoParser.OneofContext ctx) {
        Message parent = this.context.peek(Message.class);
        Oneof oneof = new Oneof(parent);
        this.context.push(oneof);
    }

    @Override
    public void exitOneof(ProtoParser.OneofContext ctx) {
        Oneof oneof = this.context.pop(Oneof.class);
        Message message = this.context.peek(Message.class);
        oneof.setName(ctx.name().getText());
        oneof.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        message.addOneof(oneof);
        this.attachComments(ctx, oneof, false);
    }

    @Override
    public void enterOneofField(ProtoParser.OneofFieldContext ctx) {
        Oneof oneof = this.context.peek(Oneof.class);
        Message message = oneof.getParent();
        Field field = new Field(message);
        field.setOneof(oneof);
        this.context.push(field);
    }

    @Override
    public void exitOneofField(ProtoParser.OneofFieldContext ctx) {
        Field field = this.context.pop(Field.class);
        Oneof oneOf = this.context.peek(Oneof.class);
        Message message = oneOf.getParent();
        String name = ctx.name().getText();
        String type = ctx.typeReference().getText();
        Integer tag = Integer.decode(ctx.INTEGER_VALUE().getText());
        field.setName(name);
        field.setTag(tag);
        field.setIndex(message.getFieldCount() + 1);
        field.setTypeName(type);
        field.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        oneOf.addField(field);
        message.addField(field);
        this.attachComments(ctx, field, true);
    }

    @Override
    public void enterOneofGroup(ProtoParser.OneofGroupContext ctx) {
        Oneof parent = this.context.peek(Oneof.class);
        Group group = new Group(parent.getParent());
        this.context.push(group);
    }

    @Override
    public void exitOneofGroup(ProtoParser.OneofGroupContext ctx) {
        Group group = this.context.pop(Group.class);
        group.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        GroupContainer container = this.context.peek(GroupContainer.class);
        container.addGroup(group);
    }

    @Override
    public void enterMap(ProtoParser.MapContext ctx) {
        Message parent = this.context.peek(Message.class);
        Field field = new Field(parent);
        this.context.push(field);
    }

    @Override
    public void exitMap(ProtoParser.MapContext ctx) {
        Field field = this.context.pop(Field.class);
        Message message = this.context.peek(Message.class);
        String name = ctx.name().getText();
        String keyTypeName = ctx.mapKey().getText();
        String valueTypeName = ctx.mapValue().getText();
        SourceCodeLocation codeLocation = this.getSourceCodeLocation(ctx);
        Message map = new Message(message);
        String mapEntryTypeName = name + "_entry";
        map.setName(mapEntryTypeName);
        map.setSourceCodeLocation(codeLocation);
        map.getOptions().set(codeLocation, OPTION_MAP_ENTRY, DynamicMessage.Value.createBoolean(true));
        Field keyField = this.createMapKeyField(map, keyTypeName, codeLocation);
        map.addField(keyField);
        Field valueField = this.createMapValueField(map, valueTypeName, codeLocation);
        map.addField(valueField);
        Integer tag = Integer.decode(ctx.tag().getText());
        field.setName(name);
        field.setTag(tag);
        field.setIndex(message.getFieldCount() + 1);
        field.setModifier(FieldModifier.REPEATED);
        field.setTypeName(mapEntryTypeName);
        field.setType(map);
        field.setSourceCodeLocation(codeLocation);
        message.addField(field);
        message.addMessage(map);
        this.attachComments(ctx, field, true);
    }

    private Field createMapValueField(Message map, String valueTypeName, SourceCodeLocation codeLocation) {
        Field valueField = new Field(map);
        valueField.setName(MAP_ENTRY_VALUE);
        valueField.setTag(2);
        valueField.setIndex(2);
        valueField.setModifier(FieldModifier.OPTIONAL);
        valueField.setTypeName(valueTypeName);
        valueField.setSourceCodeLocation(codeLocation);
        return valueField;
    }

    private Field createMapKeyField(Message map, String keyTypeName, SourceCodeLocation codeLocation) {
        Field keyField = new Field(map);
        keyField.setName(MAP_ENTRY_KEY);
        keyField.setTag(1);
        keyField.setIndex(1);
        keyField.setTypeName(keyTypeName);
        keyField.setModifier(FieldModifier.OPTIONAL);
        keyField.setSourceCodeLocation(codeLocation);
        return keyField;
    }

    @Override
    public void exitExtensions(ProtoParser.ExtensionsContext ctx) {
        Message message = this.context.peek(Message.class);
        ProtoParser.RangesContext ranges = ctx.ranges();
        List<Range> result = this.getRanges(message, ranges);
        for (Range range : result) {
            message.addExtensionRange(range);
        }
    }

    private List<Range> getRanges(Message message, ProtoParser.RangesContext ranges) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (ProtoParser.RangeContext rangeContext : ranges.range()) {
            TerminalNode fromNode = rangeContext.INTEGER_VALUE(0);
            TerminalNode toNode = rangeContext.INTEGER_VALUE(1);
            if (toNode == null) {
                toNode = rangeContext.MAX();
            }
            int from = Integer.decode(fromNode.getText());
            int to = toNode == null ? from : (MAX.equals(toNode.getText()) ? 0x1FFFFFFF : Integer.decode(toNode.getText()));
            Range range = new Range(message, from, to);
            range.setSourceCodeLocation(this.getSourceCodeLocation(rangeContext));
            result.add(range);
        }
        return result;
    }

    private void updateModifier(ProtoParser.FieldModifierContext modifierContext, Field field) {
        if (modifierContext != null) {
            if (modifierContext.OPTIONAL() != null) {
                field.setModifier(FieldModifier.OPTIONAL);
            } else if (modifierContext.REQUIRED() != null) {
                field.setModifier(FieldModifier.REQUIRED);
            } else if (modifierContext.REPEATED() != null) {
                field.setModifier(FieldModifier.REPEATED);
            } else {
                throw new IllegalStateException("not implemented");
            }
        }
    }
}

