/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Descriptor;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.ScalarFieldType;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ExtensionRegistry;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import io.protostuff.compiler.parser.ProtoWalker;
import io.protostuff.compiler.parser.TypeResolverPostProcessor;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsPostProcessor
implements ProtoContextPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsPostProcessor.class);
    private final Provider<ProtoContext> descriptorProtoProvider;

    @Inject
    public OptionsPostProcessor(@Named(value="descriptor.proto") Provider<ProtoContext> descriptorProtoProvider) {
        this.descriptorProtoProvider = descriptorProtoProvider;
    }

    @Override
    public void process(ProtoContext context) {
        ProtoWalker.newInstance(context).onProto(this::processOptions).onMessage(this::processOptions).walk();
    }

    private void processOptions(ProtoContext context, Descriptor descriptor) {
        DynamicMessage options = descriptor.getOptions();
        if (options.isEmpty()) {
            return;
        }
        String descriptorClassName = descriptor.getClass().getSimpleName();
        String descriptorName = descriptor.getName();
        LOGGER.trace("processing class={} name={}", (Object)descriptorClassName, (Object)descriptorName);
        Message sourceMessage = this.findSourceMessage(context, descriptor.getDescriptorType());
        this.processOptions(context, sourceMessage, descriptor, options);
    }

    private void processOptions(ProtoContext context, Message sourceMessage, Descriptor owningDescriptor, DynamicMessage options) {
        ExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        Map<String, Field> extensionFields = extensionRegistry.getExtensionFields(sourceMessage);
        HashMap<DynamicMessage.Key, String> fullyQualifiedNames = new HashMap<DynamicMessage.Key, String>();
        for (Map.Entry<DynamicMessage.Key, DynamicMessage.Value> entry : options.getFields()) {
            DynamicMessage.Value value;
            DynamicMessage.Key key;
            block5: {
                Field extensionField;
                String fullyQualifiedName;
                block7: {
                    block6: {
                        key = entry.getKey();
                        value = entry.getValue();
                        if (!key.isExtension()) break block5;
                        fullyQualifiedName = null;
                        extensionField = null;
                        if (!key.getName().startsWith(".")) break block6;
                        String name = key.getName();
                        if (!extensionFields.containsKey(name)) break block7;
                        fullyQualifiedName = name;
                        extensionField = extensionFields.get(fullyQualifiedName);
                        break block7;
                    }
                    UserTypeContainer owningContainer = this.getOwningContainer(owningDescriptor);
                    Deque<String> scopeLookupList = TypeResolverPostProcessor.createScopeLookupList(owningContainer);
                    for (String scope : scopeLookupList) {
                        String name = scope + key.getName();
                        if (!extensionFields.containsKey(name)) continue;
                        fullyQualifiedName = name;
                        extensionField = extensionFields.get(fullyQualifiedName);
                        break;
                    }
                }
                if (fullyQualifiedName == null) {
                    throw new ParserException(value, "Unknown option: '%s'", key.getName());
                }
                fullyQualifiedNames.put(key, fullyQualifiedName);
                this.checkFieldValue(context, owningDescriptor, extensionField, value);
                continue;
            }
            String fieldName = key.getName();
            Field field = sourceMessage.getField(fieldName);
            if (field == null) {
                throw new ParserException(value, "Unknown option: '%s'", fieldName);
            }
            this.checkFieldValue(context, owningDescriptor, field, value);
        }
        for (Map.Entry<DynamicMessage.Key, DynamicMessage.Value> entry : fullyQualifiedNames.entrySet()) {
            options.normalizeName(entry.getKey(), (String)((Object)entry.getValue()));
        }
    }

    private UserTypeContainer getOwningContainer(Descriptor descriptor) {
        Element tmp = descriptor;
        while (!(tmp instanceof UserTypeContainer)) {
            tmp = tmp.getParent();
        }
        return (UserTypeContainer)tmp;
    }

    private void checkFieldValue(ProtoContext context, Descriptor descriptor, Field field, DynamicMessage.Value value) {
        String fieldName = field.getName();
        FieldType fieldType = field.getType();
        DynamicMessage.Value.Type valueType = value.getType();
        if (fieldType instanceof ScalarFieldType) {
            ScalarFieldType scalarFieldType = (ScalarFieldType)fieldType;
            if (!this.isAssignableFrom(scalarFieldType, valueType)) {
                throw new ParserException(value, "Cannot set option '%s': expected %s value", fieldName, fieldType);
            }
        } else if (fieldType instanceof Enum) {
            Enum anEnum = (Enum)fieldType;
            Set<String> allowedNames = anEnum.getConstantNames();
            if (valueType != DynamicMessage.Value.Type.ENUM || !allowedNames.contains(value.getEnumName())) {
                throw new ParserException(value, "Cannot set option '%s': expected enum = %s", fieldName, allowedNames);
            }
        } else if (fieldType instanceof Message) {
            if (valueType != DynamicMessage.Value.Type.MESSAGE) {
                throw new ParserException(value, "Cannot set option '%s': expected message value", fieldName);
            }
            Message message = (Message)fieldType;
            this.processOptions(context, message, descriptor, value.getMessage());
        } else {
            throw new IllegalStateException("Unknown field type: " + fieldType);
        }
    }

    private boolean isAssignableFrom(ScalarFieldType target, DynamicMessage.Value.Type valueType) {
        switch (target) {
            case INT32: 
            case INT64: 
            case UINT32: 
            case UINT64: 
            case SINT32: 
            case SINT64: 
            case FIXED32: 
            case FIXED64: 
            case SFIXED32: 
            case SFIXED64: {
                return valueType == DynamicMessage.Value.Type.INTEGER;
            }
            case FLOAT: 
            case DOUBLE: {
                return valueType == DynamicMessage.Value.Type.INTEGER || valueType == DynamicMessage.Value.Type.FLOAT;
            }
            case BOOL: {
                return valueType == DynamicMessage.Value.Type.BOOLEAN;
            }
            case STRING: {
                return valueType == DynamicMessage.Value.Type.STRING;
            }
            case BYTES: {
                return valueType == DynamicMessage.Value.Type.STRING;
            }
        }
        throw new IllegalStateException("Unknown field type: " + target);
    }

    private Message findSourceMessage(ProtoContext context, DescriptorType type) {
        Message message = this.tryResolveFromContext(context, type);
        if (message == null) {
            ProtoContext descriptorProto = this.descriptorProtoProvider.get();
            return this.tryResolveFromContext(descriptorProto, type);
        }
        return message;
    }

    private Message tryResolveFromContext(ProtoContext context, DescriptorType type) {
        switch (type) {
            case PROTO: {
                return context.resolve(Message.class, ".google.protobuf.FileOptions");
            }
            case ENUM: {
                return context.resolve(Message.class, ".google.protobuf.EnumOptions");
            }
            case ENUM_CONSTANT: {
                return context.resolve(Message.class, ".google.protobuf.EnumValueOptions");
            }
            case MESSAGE: {
                return context.resolve(Message.class, ".google.protobuf.MessageOptions");
            }
            case MESSAGE_FIELD: {
                return context.resolve(Message.class, ".google.protobuf.FieldOptions");
            }
            case GROUP: {
                return context.resolve(Message.class, ".google.protobuf.MessageOptions");
            }
            case SERVICE: {
                return context.resolve(Message.class, ".google.protobuf.ServiceOptions");
            }
            case SERVICE_METHOD: {
                return context.resolve(Message.class, ".google.protobuf.MethodOptions");
            }
        }
        throw new IllegalStateException("Unknown descriptor type: " + (Object)((Object)type));
    }
}

