/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.parser.AbstractExtensionRegistry;
import io.protostuff.compiler.parser.ExtensionRegistry;
import io.protostuff.compiler.parser.LocalExtensionRegistry;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ProtoExtensionRegistry
extends AbstractExtensionRegistry {
    private final ExtensionRegistry localExtensionRegistry;
    private final ProtoContext context;
    private final ConcurrentMap<String, Collection<Extension>> extensionCache = new ConcurrentHashMap<String, Collection<Extension>>();
    private Proto proto;

    public ProtoExtensionRegistry(ProtoContext context) {
        this.context = context;
        this.proto = context.getProto();
        this.localExtensionRegistry = new LocalExtensionRegistry();
    }

    @Override
    public void registerExtension(Extension extension) {
        super.registerExtension(extension);
        this.localExtensionRegistry.registerExtension(extension);
        String fullyQualifiedName = extension.getExtendee().getFullyQualifiedName();
        this.extensionCache.remove(fullyQualifiedName);
    }

    @Override
    public Collection<Extension> getExtensions(String fullMessageName) {
        return this.extensionCache.computeIfAbsent(fullMessageName, name -> {
            ArrayList<Extension> result = new ArrayList<Extension>();
            result.addAll(this.localExtensionRegistry.getExtensions((String)name));
            ArrayDeque<Import> queue = new ArrayDeque<Import>();
            queue.addAll(this.proto.getImports());
            while (!queue.isEmpty()) {
                Import anImport = (Import)queue.poll();
                Proto proto = anImport.getProto();
                Collection<Extension> extensions = this.getExtensions(proto, (String)name);
                result.addAll(extensions);
                queue.addAll(proto.getPublicImports());
            }
            return result;
        });
    }

    private Collection<Extension> getExtensions(Proto proto, String name) {
        ProtoContext context = proto.getContext();
        ExtensionRegistry extensionRegistry = context.getExtensionRegistry();
        return extensionRegistry.getExtensions(name);
    }
}

