/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Package;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Syntax;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import io.protostuff.compiler.parser.Util;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;

public class ProtoParseListener
extends AbstractProtoParserListener {
    private final BufferedTokenStream tokens;

    protected ProtoParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
        this.tokens = tokens;
    }

    @Override
    public void enterProto(ProtoParser.ProtoContext ctx) {
        super.enterProto(ctx);
    }

    @Override
    public void exitProto(ProtoParser.ProtoContext ctx) {
        int type;
        int i;
        ArrayList<String> comments = new ArrayList<String>();
        boolean foundEmptyLine = false;
        for (i = 0; i < this.tokens.size() && this.tokens.get(i).getChannel() == 1 && this.tokens.get(i).getType() != 40; ++i) {
        }
        while (i < this.tokens.size() && this.tokens.get(i).getChannel() == 1 && this.tokens.get(i).getType() == 40) {
            Token token = this.tokens.get(i++);
            String text = this.getTextFromLineCommentToken(token);
            comments.add(text);
        }
        if (i < this.tokens.size() && ((type = this.tokens.get(i).getType()) == 6 || type == 17 || type == 18)) {
            return;
        }
        List<String> trimComments = this.trim(comments);
        for (String comment : trimComments) {
            this.context.getProto().addComment(comment);
        }
    }

    @Override
    public void exitSyntax(ProtoParser.SyntaxContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String text = ctx.STRING_VALUE().getText();
        String value = Util.removeFirstAndLastChar(text);
        Syntax syntax = new Syntax(proto, value);
        syntax.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.setSyntax(syntax);
    }

    @Override
    public void exitPackageStatement(ProtoParser.PackageStatementContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String packageName = ctx.packageName().getText();
        Package aPackage = new Package(proto, packageName);
        aPackage.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.setPackage(aPackage);
    }

    @Override
    public void exitImportStatement(ProtoParser.ImportStatementContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String text = ctx.STRING_VALUE().getText();
        String fileName = Util.removeFirstAndLastChar(text);
        Import anImport = new Import(proto, fileName, ctx.PUBLIC() != null);
        anImport.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.addImport(anImport);
    }
}

