/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator;

import com.google.common.base.Throwables;
import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.generator.OutputStreamFactory;
import io.protostuff.generator.ProtoCompiler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtoCompiler
implements ProtoCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProtoCompiler.class);
    private final OutputStreamFactory outputStreamFactory;

    public AbstractProtoCompiler(OutputStreamFactory outputStreamFactory) {
        this.outputStreamFactory = outputStreamFactory;
    }

    @Override
    public void compile(Module module) {
        try {
            String moduleOutput = module.getOutput();
            if (this.canProcessModule(module)) {
                String outputFileName = this.getModuleOutputFileName(module);
                Writer writer = this.getWriter(moduleOutput, outputFileName);
                Object object = null;
                try {
                    this.compileModule(module, writer);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            for (Proto proto : module.getProtos()) {
                if (this.canProcessProto(proto)) {
                    String outputFileName = this.getProtoOutputFileName(proto);
                    try (Writer writer = this.getWriter(moduleOutput, outputFileName);){
                        this.compileProto(proto, writer);
                    }
                }
                for (Service service : proto.getServices()) {
                    if (!this.canProcessService(service)) continue;
                    String outputFileName = this.getServiceOutputFileName(service);
                    Writer writer = this.getWriter(moduleOutput, outputFileName);
                    Throwable throwable = null;
                    try {
                        this.compileService(service, writer);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                this.processUserTypes(module, proto);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private void processUserTypes(Module module, UserTypeContainer container) throws IOException {
        Throwable throwable;
        Writer writer;
        String outputFileName;
        List<Message> messages = container.getMessages();
        List<Enum> enums = container.getEnums();
        String basedir = module.getOutput();
        for (Message message : messages) {
            if (this.canProcessMessage(message)) {
                outputFileName = this.getMessageOutputFileName(message);
                writer = this.getWriter(basedir, outputFileName);
                throwable = null;
                try {
                    this.compileMessage(message, writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            this.processUserTypes(module, message);
        }
        for (Enum anEnum : enums) {
            if (!this.canProcessEnum(anEnum)) continue;
            outputFileName = this.getEnumOutputFileName(anEnum);
            writer = this.getWriter(basedir, outputFileName);
            throwable = null;
            try {
                this.compileEnum(anEnum, writer);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    protected String appendBasedir(String basedir, String relativeFilename) {
        if (basedir.charAt(basedir.length() - 1) == this.getFolderSeparator()) {
            return basedir + relativeFilename;
        }
        return basedir + this.getFolderSeparator() + relativeFilename;
    }

    protected char getFolderSeparator() {
        return File.separatorChar;
    }

    private Writer getWriter(String basedir, String outputFileName) {
        LOGGER.info("Generate {}", (Object)outputFileName);
        String fullFileLocation = this.appendBasedir(basedir, outputFileName);
        OutputStream outputStream = this.outputStreamFactory.createStream(fullFileLocation);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        return new BufferedWriter(outputStreamWriter);
    }

    protected abstract void compileModule(Module var1, Writer var2);

    protected abstract void compileProto(Proto var1, Writer var2);

    protected abstract void compileMessage(Message var1, Writer var2);

    protected abstract void compileEnum(Enum var1, Writer var2);

    protected abstract void compileService(Service var1, Writer var2);

    protected abstract boolean canProcessModule(Module var1);

    protected abstract boolean canProcessProto(Proto var1);

    protected abstract boolean canProcessMessage(Message var1);

    protected abstract boolean canProcessEnum(Enum var1);

    protected abstract boolean canProcessService(Service var1);

    protected abstract String getModuleOutputFileName(Module var1);

    protected abstract String getProtoOutputFileName(Proto var1);

    protected abstract String getMessageOutputFileName(Message var1);

    protected abstract String getEnumOutputFileName(Enum var1);

    protected abstract String getServiceOutputFileName(Service var1);
}

