/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import io.protostuff.generator.CompilerRegistry;
import io.protostuff.generator.CompilerUtils;
import io.protostuff.generator.GeneratorException;
import io.protostuff.generator.OutputStreamFactory;
import io.protostuff.generator.ProtoCompiler;
import io.protostuff.generator.StCompiler;
import io.protostuff.generator.StCompilerFactory;
import io.protostuff.generator.html.HtmlGenerator;
import io.protostuff.generator.java.JavaGenerator;
import io.protostuff.generator.proto.ProtoGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class CompilerModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(CompilerRegistry.class);
        this.bind(CompilerUtils.class);
        this.install(new FactoryModuleBuilder().implement(ProtoCompiler.class, StCompiler.class).build(StCompilerFactory.class));
        MapBinder<String, ProtoCompiler> compilers = MapBinder.newMapBinder(this.binder(), String.class, ProtoCompiler.class);
        compilers.addBinding("html").to(HtmlGenerator.class);
        compilers.addBinding("proto").to(ProtoGenerator.class);
        compilers.addBinding("java").to(JavaGenerator.class);
    }

    @Provides
    OutputStreamFactory outputStreamFactory() {
        return location -> {
            try {
                Path path = Paths.get(location, new String[0]);
                Path dir = path.getParent();
                Files.createDirectories(dir, new FileAttribute[0]);
                return new FileOutputStream(location);
            }
            catch (IOException e) {
                throw new GeneratorException("Could not create file: %s", (Throwable)e, location);
            }
        };
    }
}

