/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator;

public class Formatter {
    private Formatter() {
    }

    public static String toUpperCase(String source) {
        return source.toUpperCase();
    }

    public static String toLowerCase(String source) {
        return source.toLowerCase();
    }

    public static String toCamelCase(String source) {
        return Formatter.toCamelCaseImpl(source).toString();
    }

    public static String toUnderscoreCase(String source) {
        return Formatter.toUnderscoreCaseImpl(source).toString();
    }

    public static String toPascalCase(String source) {
        return Formatter.toPascalCaseImpl(source).toString();
    }

    private static StringBuilder toCamelCaseImpl(String name) {
        StringBuilder buffer = new StringBuilder();
        int toUpper = 0;
        int i = 0;
        int len = name.length();
        while (i < len) {
            char c;
            if ((c = name.charAt(i++)) == '_') {
                if (i == len) break;
                if (buffer.length() == 0) continue;
                ++toUpper;
                continue;
            }
            if (toUpper != 0) {
                if (c > '`' && c < '{') {
                    buffer.append((char)(c - 32));
                    toUpper = 0;
                    continue;
                }
                if (c > '@' && c < '[') {
                    buffer.append(c);
                    toUpper = 0;
                    continue;
                }
                while (toUpper > 0) {
                    buffer.append('_');
                    --toUpper;
                }
                buffer.append(c);
                continue;
            }
            if (buffer.length() == 0 && c > '@' && c < '[') {
                buffer.append((char)(c + 32));
                continue;
            }
            buffer.append(c);
        }
        return buffer;
    }

    private static StringBuilder toPascalCaseImpl(String name) {
        StringBuilder buffer = Formatter.toCamelCaseImpl(name);
        char c = buffer.charAt(0);
        if (c > '`' && c < '{') {
            buffer.setCharAt(0, (char)(c - 32));
        }
        return buffer;
    }

    private static StringBuilder toUnderscoreCaseImpl(String name) {
        StringBuilder buffer = new StringBuilder();
        boolean toLower = false;
        boolean appendUnderscore = false;
        int i = 0;
        int len = name.length();
        while (i < len) {
            char c;
            if ((c = name.charAt(i++)) == '_') {
                if (i == len) break;
                if (buffer.length() == 0) continue;
                appendUnderscore = true;
                continue;
            }
            if (appendUnderscore) {
                buffer.append('_');
            }
            if (c > '`' && c < '{') {
                buffer.append(c);
                toLower = true;
            } else if (c > '@' && c < '[') {
                if (toLower) {
                    if (!appendUnderscore) {
                        buffer.append('_');
                    }
                    toLower = false;
                }
                buffer.append((char)(c + 32));
            } else {
                buffer.append(c);
                toLower = false;
            }
            appendUnderscore = false;
        }
        return buffer;
    }
}

