/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator;

import com.google.inject.Guice;
import com.google.inject.Injector;
import io.protostuff.compiler.ParserModule;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.FileReaderFactory;
import io.protostuff.compiler.parser.Importer;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.generator.CompilerModule;
import io.protostuff.generator.CompilerRegistry;
import io.protostuff.generator.GeneratorException;
import io.protostuff.generator.ProtoCompiler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtostuffCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtostuffCompiler.class);
    private final Injector injector = Guice.createInjector(new ParserModule(), new CompilerModule());

    public void compile(ModuleConfiguration configuration) {
        Proto proto;
        FileReaderFactory fileReaderFactory = this.injector.getInstance(FileReaderFactory.class);
        Importer importer = this.injector.getInstance(Importer.class);
        CompilerRegistry registry = this.injector.getInstance(CompilerRegistry.class);
        ProtoCompiler compiler = registry.findCompiler(configuration.getGenerator());
        if (compiler == null) {
            throw new GeneratorException("Unknown template: %s", configuration.getGenerator());
        }
        FileReader fileReader = fileReaderFactory.create(configuration.getIncludePaths());
        HashMap<String, Proto> importedFiles = new HashMap<String, Proto>();
        for (String path : configuration.getProtoFiles()) {
            LOGGER.info("Parse {}", (Object)path);
            ProtoContext context = importer.importFile(fileReader, path);
            proto = context.getProto();
            importedFiles.put(path, proto);
        }
        Module module = new Module();
        module.setTemplate(configuration.getTemplate());
        module.setName(configuration.getName());
        module.setOutput(configuration.getOutput());
        for (Map.Entry entry : importedFiles.entrySet()) {
            proto = (Proto)entry.getValue();
            module.addProto(proto);
            proto.setModule(module);
        }
        compiler.compile(module);
    }
}

