/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import io.protostuff.generator.GeneratorException;
import io.protostuff.generator.OutputStreamFactory;
import io.protostuff.generator.ProtoCompiler;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonGenerator
implements ProtoCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonGenerator.class);
    protected final OutputStreamFactory outputStreamFactory;
    protected final ObjectMapper objectMapper;

    public AbstractJsonGenerator(OutputStreamFactory outputStreamFactory) {
        this.outputStreamFactory = outputStreamFactory;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    protected void write(String file, Object data) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(data);
        LOGGER.info("Write {}", (Object)file);
        try (OutputStream os = this.outputStreamFactory.createStream(file);){
            this.objectMapper.writeValue(os, data);
        }
        catch (Exception e) {
            throw new GeneratorException("Could not write " + file, e);
        }
    }
}

