/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.enumeration.EnumConstant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableEnumConstant
implements EnumConstant {
    private final String name;
    @Nullable
    private final String description;
    private final int value;

    private ImmutableEnumConstant(String name, @Nullable String description, int value) {
        this.name = name;
        this.description = description;
        this.value = value;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    public int value() {
        return this.value;
    }

    public final ImmutableEnumConstant withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableEnumConstant(newValue, this.description, this.value);
    }

    public final ImmutableEnumConstant withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableEnumConstant(this.name, newValue, this.value);
    }

    public final ImmutableEnumConstant withValue(int value) {
        if (this.value == value) {
            return this;
        }
        int newValue = value;
        return new ImmutableEnumConstant(this.name, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEnumConstant && this.equalTo((ImmutableEnumConstant)another);
    }

    private boolean equalTo(ImmutableEnumConstant another) {
        return this.name.equals(another.name) && Objects.equal(this.description, another.description) && this.value == another.value;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.value;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("EnumConstant").add("name", this.name).add("description", this.description).add("value", this.value).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableEnumConstant fromJson(Json json) {
        Builder builder = ImmutableEnumConstant.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableEnumConstant copyOf(EnumConstant instance) {
        if (instance instanceof ImmutableEnumConstant) {
            return (ImmutableEnumConstant)instance;
        }
        return ImmutableEnumConstant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String description;
        private int value;

        private Builder() {
        }

        public final Builder from(EnumConstant instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.value(instance.value());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEnumConstant build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableEnumConstant(this.name, this.description, this.value);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build EnumConstant, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        Integer value;

        Json() {
        }
    }
}

