/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.enumeration.EnumConstant;
import io.protostuff.generator.html.json.enumeration.EnumDescriptor;
import io.protostuff.generator.html.json.index.NodeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableEnumDescriptor
implements EnumDescriptor {
    private final String name;
    private final NodeType type;
    private final String canonicalName;
    @Nullable
    private final String description;
    private final ImmutableList<EnumConstant> constants;

    private ImmutableEnumDescriptor(String name, NodeType type, String canonicalName, @Nullable String description, ImmutableList<EnumConstant> constants) {
        this.name = name;
        this.type = type;
        this.canonicalName = canonicalName;
        this.description = description;
        this.constants = constants;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public NodeType type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String canonicalName() {
        return this.canonicalName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonProperty
    public ImmutableList<EnumConstant> constants() {
        return this.constants;
    }

    public final ImmutableEnumDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableEnumDescriptor(newValue, this.type, this.canonicalName, this.description, this.constants);
    }

    public final ImmutableEnumDescriptor withType(NodeType value) {
        if (this.type == value) {
            return this;
        }
        NodeType newValue = Preconditions.checkNotNull(value);
        return new ImmutableEnumDescriptor(this.name, newValue, this.canonicalName, this.description, this.constants);
    }

    public final ImmutableEnumDescriptor withCanonicalName(String value) {
        if (this.canonicalName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableEnumDescriptor(this.name, this.type, newValue, this.description, this.constants);
    }

    public final ImmutableEnumDescriptor withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableEnumDescriptor(this.name, this.type, this.canonicalName, newValue, this.constants);
    }

    public final ImmutableEnumDescriptor withConstants(EnumConstant ... elements) {
        ImmutableList<EnumConstant> newValue = ImmutableList.copyOf(elements);
        return new ImmutableEnumDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public final ImmutableEnumDescriptor withConstants(Iterable<? extends EnumConstant> elements) {
        if (this.constants == elements) {
            return this;
        }
        ImmutableList<EnumConstant> newValue = ImmutableList.copyOf(elements);
        return new ImmutableEnumDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEnumDescriptor && this.equalTo((ImmutableEnumDescriptor)another);
    }

    private boolean equalTo(ImmutableEnumDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && this.canonicalName.equals(another.canonicalName) && Objects.equal(this.description, another.description) && this.constants.equals(another.constants);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.canonicalName.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.constants.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("EnumDescriptor").add("name", this.name).add("type", (Object)this.type).add("canonicalName", this.canonicalName).add("description", this.description).add("constants", this.constants).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableEnumDescriptor fromJson(Json json) {
        Builder builder = ImmutableEnumDescriptor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.canonicalName != null) {
            builder.canonicalName(json.canonicalName);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.constants != null) {
            builder.addAllConstants(json.constants);
        }
        return builder.build();
    }

    public static ImmutableEnumDescriptor copyOf(EnumDescriptor instance) {
        if (instance instanceof ImmutableEnumDescriptor) {
            return (ImmutableEnumDescriptor)instance;
        }
        return ImmutableEnumDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CANONICAL_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private NodeType type;
        @Nullable
        private String canonicalName;
        @Nullable
        private String description;
        private ImmutableList.Builder<EnumConstant> constantsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(EnumDescriptor instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.type(instance.type());
            this.canonicalName(instance.canonicalName());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.addAllConstants(instance.constants());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(NodeType type) {
            this.type = Preconditions.checkNotNull(type);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder canonicalName(String canonicalName) {
            this.canonicalName = Preconditions.checkNotNull(canonicalName);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder addConstants(EnumConstant element) {
            this.constantsBuilder.add((Object)element);
            return this;
        }

        public final Builder addConstants(EnumConstant ... elements) {
            this.constantsBuilder.add(elements);
            return this;
        }

        public final Builder constants(Iterable<? extends EnumConstant> elements) {
            this.constantsBuilder = ImmutableList.builder();
            return this.addAllConstants(elements);
        }

        public final Builder addAllConstants(Iterable<? extends EnumConstant> elements) {
            this.constantsBuilder.addAll(elements);
            return this;
        }

        public ImmutableEnumDescriptor build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableEnumDescriptor(this.name, this.type, this.canonicalName, this.description, (ImmutableList)this.constantsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean canonicalNameIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.canonicalNameIsSet()) {
                attributes.add("canonicalName");
            }
            return "Cannot build EnumDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        NodeType type;
        @JsonProperty
        @Nullable
        String canonicalName;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        List<EnumConstant> constants;

        Json() {
        }
    }
}

