/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.index;

import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.generator.OutputStreamFactory;
import io.protostuff.generator.html.json.AbstractJsonGenerator;
import io.protostuff.generator.html.json.index.JsonTreeNode;
import io.protostuff.generator.html.json.index.NodeData;
import io.protostuff.generator.html.json.index.NodeType;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public final class JsonIndexGenerator
extends AbstractJsonGenerator {
    @Inject
    public JsonIndexGenerator(OutputStreamFactory outputStreamFactory) {
        super(outputStreamFactory);
    }

    @Override
    public String getName() {
        return "html-data-index";
    }

    @Override
    public void compile(Module module) {
        ArrayList root = new ArrayList();
        module.getProtos().stream().forEach(proto -> root.add(JsonTreeNode.newBuilder().label(proto.getFilename()).data(NodeData.newBuilder().ref(proto.getCanonicalName()).type(NodeType.PROTO).build()).children(this.processProto((Proto)proto)).build()));
        String output = module.getOutput() + "/data/index.json";
        this.write(output, root);
    }

    private List<JsonTreeNode> processProto(Proto proto) {
        ArrayList<JsonTreeNode> result = new ArrayList<JsonTreeNode>();
        proto.getServices().stream().forEach(service -> result.add(JsonTreeNode.newBuilder().label(service.getName()).data(NodeData.newBuilder().type(NodeType.SERVICE).ref(service.getCanonicalName()).build()).build()));
        result.addAll(this.processContainer(proto));
        return result;
    }

    private List<JsonTreeNode> processContainer(UserTypeContainer proto) {
        ArrayList<JsonTreeNode> result = new ArrayList<JsonTreeNode>();
        proto.getEnums().stream().forEach(anEnum -> result.add(JsonTreeNode.newBuilder().label(anEnum.getName()).data(NodeData.newBuilder().type(NodeType.ENUM).ref(anEnum.getCanonicalName()).build()).build()));
        proto.getMessages().stream().filter(message -> !message.isMapEntry()).forEach(message -> {
            JsonTreeNode.Builder builder = JsonTreeNode.newBuilder();
            builder.label(message.getName());
            builder.data(NodeData.newBuilder().type(NodeType.MESSAGE).ref(message.getCanonicalName()).build());
            List<JsonTreeNode> children = this.processContainer((UserTypeContainer)message);
            if (!children.isEmpty()) {
                builder.children(children);
            }
            result.add(builder.build());
        });
        return result;
    }
}

