/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.index.NodeType;
import io.protostuff.generator.html.json.message.MessageDescriptor;
import io.protostuff.generator.html.json.message.MessageField;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableMessageDescriptor
implements MessageDescriptor {
    private final String name;
    private final NodeType type;
    private final String canonicalName;
    @Nullable
    private final String description;
    private final ImmutableList<MessageField> fields;

    private ImmutableMessageDescriptor(String name, NodeType type, String canonicalName, @Nullable String description, ImmutableList<MessageField> fields) {
        this.name = name;
        this.type = type;
        this.canonicalName = canonicalName;
        this.description = description;
        this.fields = fields;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public NodeType type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String canonicalName() {
        return this.canonicalName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonProperty
    public ImmutableList<MessageField> fields() {
        return this.fields;
    }

    public final ImmutableMessageDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageDescriptor(newValue, this.type, this.canonicalName, this.description, this.fields);
    }

    public final ImmutableMessageDescriptor withType(NodeType value) {
        if (this.type == value) {
            return this;
        }
        NodeType newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageDescriptor(this.name, newValue, this.canonicalName, this.description, this.fields);
    }

    public final ImmutableMessageDescriptor withCanonicalName(String value) {
        if (this.canonicalName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageDescriptor(this.name, this.type, newValue, this.description, this.fields);
    }

    public final ImmutableMessageDescriptor withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableMessageDescriptor(this.name, this.type, this.canonicalName, newValue, this.fields);
    }

    public final ImmutableMessageDescriptor withFields(MessageField ... elements) {
        ImmutableList<MessageField> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMessageDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public final ImmutableMessageDescriptor withFields(Iterable<? extends MessageField> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList<MessageField> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMessageDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageDescriptor && this.equalTo((ImmutableMessageDescriptor)another);
    }

    private boolean equalTo(ImmutableMessageDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && this.canonicalName.equals(another.canonicalName) && Objects.equal(this.description, another.description) && this.fields.equals(another.fields);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.canonicalName.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.fields.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MessageDescriptor").add("name", this.name).add("type", (Object)this.type).add("canonicalName", this.canonicalName).add("description", this.description).add("fields", this.fields).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableMessageDescriptor fromJson(Json json) {
        Builder builder = ImmutableMessageDescriptor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.canonicalName != null) {
            builder.canonicalName(json.canonicalName);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.fields != null) {
            builder.addAllFields(json.fields);
        }
        return builder.build();
    }

    public static ImmutableMessageDescriptor copyOf(MessageDescriptor instance) {
        if (instance instanceof ImmutableMessageDescriptor) {
            return (ImmutableMessageDescriptor)instance;
        }
        return ImmutableMessageDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CANONICAL_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private NodeType type;
        @Nullable
        private String canonicalName;
        @Nullable
        private String description;
        private ImmutableList.Builder<MessageField> fieldsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(MessageDescriptor instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.type(instance.type());
            this.canonicalName(instance.canonicalName());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.addAllFields(instance.fields());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(NodeType type) {
            this.type = Preconditions.checkNotNull(type);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder canonicalName(String canonicalName) {
            this.canonicalName = Preconditions.checkNotNull(canonicalName);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder addFields(MessageField element) {
            this.fieldsBuilder.add((Object)element);
            return this;
        }

        public final Builder addFields(MessageField ... elements) {
            this.fieldsBuilder.add(elements);
            return this;
        }

        public final Builder fields(Iterable<? extends MessageField> elements) {
            this.fieldsBuilder = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends MessageField> elements) {
            this.fieldsBuilder.addAll(elements);
            return this;
        }

        public ImmutableMessageDescriptor build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableMessageDescriptor(this.name, this.type, this.canonicalName, this.description, (ImmutableList)this.fieldsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean canonicalNameIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.canonicalNameIsSet()) {
                attributes.add("canonicalName");
            }
            return "Cannot build MessageDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        NodeType type;
        @JsonProperty
        @Nullable
        String canonicalName;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        List<MessageField> fields;

        Json() {
        }
    }
}

