/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import io.protostuff.generator.html.json.message.MessageField;
import io.protostuff.generator.html.json.message.MessageFieldModifier;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableMessageField
implements MessageField {
    private final String name;
    private final String typeId;
    private final MessageFieldModifier modifier;
    private final int tag;
    @Nullable
    private final String description;
    private final boolean isMap;
    @Nullable
    private final String mapKeyTypeId;
    @Nullable
    private final String mapValueTypeId;
    @Nullable
    private final String oneof;

    private ImmutableMessageField(Builder builder) {
        this.name = builder.name;
        this.typeId = builder.typeId;
        this.modifier = builder.modifier;
        this.tag = builder.tag;
        this.description = builder.description;
        this.mapKeyTypeId = builder.mapKeyTypeId;
        this.mapValueTypeId = builder.mapValueTypeId;
        this.oneof = builder.oneof;
        this.isMap = builder.isMapIsSet() ? builder.isMap : MessageField.super.isMap();
    }

    private ImmutableMessageField(String name, String typeId, MessageFieldModifier modifier, int tag, @Nullable String description, boolean isMap, @Nullable String mapKeyTypeId, @Nullable String mapValueTypeId, @Nullable String oneof) {
        this.name = name;
        this.typeId = typeId;
        this.modifier = modifier;
        this.tag = tag;
        this.description = description;
        this.isMap = isMap;
        this.mapKeyTypeId = mapKeyTypeId;
        this.mapValueTypeId = mapValueTypeId;
        this.oneof = oneof;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String typeId() {
        return this.typeId;
    }

    @Override
    @JsonProperty
    public MessageFieldModifier modifier() {
        return this.modifier;
    }

    @Override
    @JsonProperty
    public int tag() {
        return this.tag;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    public boolean isMap() {
        return this.isMap;
    }

    @Override
    @JsonProperty
    @Nullable
    public String mapKeyTypeId() {
        return this.mapKeyTypeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String mapValueTypeId() {
        return this.mapValueTypeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String oneof() {
        return this.oneof;
    }

    public final ImmutableMessageField withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageField(newValue, this.typeId, this.modifier, this.tag, this.description, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withTypeId(String value) {
        if (this.typeId == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageField(this.name, newValue, this.modifier, this.tag, this.description, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withModifier(MessageFieldModifier value) {
        if (this.modifier == value) {
            return this;
        }
        MessageFieldModifier newValue = Preconditions.checkNotNull(value);
        return new ImmutableMessageField(this.name, this.typeId, newValue, this.tag, this.description, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withTag(int value) {
        if (this.tag == value) {
            return this;
        }
        int newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, newValue, this.description, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, this.tag, newValue, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withIsMap(boolean value) {
        if (this.isMap == value) {
            return this;
        }
        boolean newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, this.tag, this.description, newValue, this.mapKeyTypeId, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withMapKeyTypeId(@Nullable String value) {
        if (this.mapKeyTypeId == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, this.tag, this.description, this.isMap, newValue, this.mapValueTypeId, this.oneof);
    }

    public final ImmutableMessageField withMapValueTypeId(@Nullable String value) {
        if (this.mapValueTypeId == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, this.tag, this.description, this.isMap, this.mapKeyTypeId, newValue, this.oneof);
    }

    public final ImmutableMessageField withOneof(@Nullable String value) {
        if (this.oneof == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableMessageField(this.name, this.typeId, this.modifier, this.tag, this.description, this.isMap, this.mapKeyTypeId, this.mapValueTypeId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageField && this.equalTo((ImmutableMessageField)another);
    }

    private boolean equalTo(ImmutableMessageField another) {
        return this.name.equals(another.name) && this.typeId.equals(another.typeId) && this.modifier.equals((Object)another.modifier) && this.tag == another.tag && Objects.equal(this.description, another.description) && this.isMap == another.isMap && Objects.equal(this.mapKeyTypeId, another.mapKeyTypeId) && Objects.equal(this.mapValueTypeId, another.mapValueTypeId) && Objects.equal(this.oneof, another.oneof);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.typeId.hashCode();
        h = h * 17 + this.modifier.hashCode();
        h = h * 17 + this.tag;
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Booleans.hashCode(this.isMap);
        h = h * 17 + Objects.hashCode(this.mapKeyTypeId);
        h = h * 17 + Objects.hashCode(this.mapValueTypeId);
        h = h * 17 + Objects.hashCode(this.oneof);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MessageField").add("name", this.name).add("typeId", this.typeId).add("modifier", (Object)this.modifier).add("tag", this.tag).add("description", this.description).add("isMap", this.isMap).add("mapKeyTypeId", this.mapKeyTypeId).add("mapValueTypeId", this.mapValueTypeId).add("oneof", this.oneof).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableMessageField fromJson(Json json) {
        Builder builder = ImmutableMessageField.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.typeId != null) {
            builder.typeId(json.typeId);
        }
        if (json.modifier != null) {
            builder.modifier(json.modifier);
        }
        if (json.tag != null) {
            builder.tag(json.tag);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.isMap != null) {
            builder.isMap(json.isMap);
        }
        if (json.mapKeyTypeId != null) {
            builder.mapKeyTypeId(json.mapKeyTypeId);
        }
        if (json.mapValueTypeId != null) {
            builder.mapValueTypeId(json.mapValueTypeId);
        }
        if (json.oneof != null) {
            builder.oneof(json.oneof);
        }
        return builder.build();
    }

    public static ImmutableMessageField copyOf(MessageField instance) {
        if (instance instanceof ImmutableMessageField) {
            return (ImmutableMessageField)instance;
        }
        return ImmutableMessageField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE_ID = 2L;
        private static final long INIT_BIT_MODIFIER = 4L;
        private static final long INIT_BIT_TAG = 8L;
        private static final long OPT_BIT_IS_MAP = 1L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private String typeId;
        @Nullable
        private MessageFieldModifier modifier;
        private int tag;
        @Nullable
        private String description;
        private boolean isMap;
        @Nullable
        private String mapKeyTypeId;
        @Nullable
        private String mapValueTypeId;
        @Nullable
        private String oneof;

        private Builder() {
        }

        public final Builder from(MessageField instance) {
            String oneofValue;
            String mapValueTypeIdValue;
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.typeId(instance.typeId());
            this.modifier(instance.modifier());
            this.tag(instance.tag());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.isMap(instance.isMap());
            String mapKeyTypeIdValue = instance.mapKeyTypeId();
            if (mapKeyTypeIdValue != null) {
                this.mapKeyTypeId(mapKeyTypeIdValue);
            }
            if ((mapValueTypeIdValue = instance.mapValueTypeId()) != null) {
                this.mapValueTypeId(mapValueTypeIdValue);
            }
            if ((oneofValue = instance.oneof()) != null) {
                this.oneof(oneofValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder typeId(String typeId) {
            this.typeId = Preconditions.checkNotNull(typeId);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder modifier(MessageFieldModifier modifier) {
            this.modifier = Preconditions.checkNotNull(modifier);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tag(int tag) {
            this.tag = tag;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder isMap(boolean isMap) {
            this.isMap = isMap;
            this.optBits |= 1L;
            return this;
        }

        public final Builder mapKeyTypeId(@Nullable String mapKeyTypeId) {
            this.mapKeyTypeId = mapKeyTypeId;
            return this;
        }

        public final Builder mapValueTypeId(@Nullable String mapValueTypeId) {
            this.mapValueTypeId = mapValueTypeId;
            return this;
        }

        public final Builder oneof(@Nullable String oneof) {
            this.oneof = oneof;
            return this;
        }

        public ImmutableMessageField build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableMessageField(this);
        }

        private boolean isMapIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean modifierIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tagIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIdIsSet()) {
                attributes.add("typeId");
            }
            if (!this.modifierIsSet()) {
                attributes.add("modifier");
            }
            if (!this.tagIsSet()) {
                attributes.add("tag");
            }
            return "Cannot build MessageField, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        String typeId;
        @JsonProperty
        @Nullable
        MessageFieldModifier modifier;
        @JsonProperty
        @Nullable
        Integer tag;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        Boolean isMap;
        @JsonProperty
        @Nullable
        String mapKeyTypeId;
        @JsonProperty
        @Nullable
        String mapValueTypeId;
        @JsonProperty
        @Nullable
        String oneof;

        Json() {
        }
    }
}

