/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.message;

import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldModifier;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.generator.OutputStreamFactory;
import io.protostuff.generator.html.json.AbstractJsonGenerator;
import io.protostuff.generator.html.json.index.NodeType;
import io.protostuff.generator.html.json.message.ImmutableMessageDescriptor;
import io.protostuff.generator.html.json.message.ImmutableMessageField;
import io.protostuff.generator.html.json.message.MessageFieldModifier;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class JsonMessageGenerator
extends AbstractJsonGenerator {
    @Inject
    public JsonMessageGenerator(OutputStreamFactory outputStreamFactory) {
        super(outputStreamFactory);
    }

    @Override
    public String getName() {
        return "html-data-message";
    }

    @Override
    public void compile(Module module) {
        module.getProtos().stream().forEach(proto -> this.rec(module, (UserTypeContainer)proto));
    }

    private void rec(Module module, UserTypeContainer container) {
        container.getMessages().stream().forEach(message -> {
            this.process(module, (Message)message);
            this.rec(module, (UserTypeContainer)message);
        });
    }

    private void process(Module module, Message message) {
        ImmutableMessageDescriptor descriptor = ImmutableMessageDescriptor.builder().type(NodeType.MESSAGE).name(message.getName()).canonicalName(message.getCanonicalName()).description(message.getComments()).addAllFields(message.getFields().stream().map(field -> {
            ImmutableMessageField.Builder builder = ImmutableMessageField.builder().name(field.getName()).typeId(field.getType().getCanonicalName()).modifier(this.getModifier((Field)field)).tag(field.getTag()).description(field.getComments()).oneof(field.isOneofPart() ? field.getOneof().getName() : null);
            boolean isMap = field.isMap();
            if (isMap) {
                builder.isMap(true);
                builder.mapKeyTypeId(this.getMapKeyType((Field)field));
                builder.mapValueTypeId(this.getMapValueType((Field)field));
            }
            return builder.build();
        }).collect(Collectors.toList())).build();
        String output = module.getOutput() + "/data/type/" + message.getCanonicalName() + ".json";
        this.write(output, descriptor);
    }

    private String getMapKeyType(Field field) {
        Message message = (Message)field.getType();
        Field key = message.getField("key");
        return key.getType().getCanonicalName();
    }

    private String getMapValueType(Field field) {
        Message message = (Message)field.getType();
        Field value = message.getField("value");
        return value.getType().getCanonicalName();
    }

    private MessageFieldModifier getModifier(Field field) {
        FieldModifier modifier = field.getModifier();
        String modifierString = modifier.toString();
        return MessageFieldModifier.fromString(modifierString);
    }
}

