/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.proto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.index.NodeType;
import io.protostuff.generator.html.json.proto.ProtoDescriptor;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableProtoDescriptor
implements ProtoDescriptor {
    private final String name;
    private final NodeType type;
    private final String canonicalName;
    private final String filename;
    @Nullable
    private final String description;

    private ImmutableProtoDescriptor(String name, NodeType type, String canonicalName, String filename, @Nullable String description) {
        this.name = name;
        this.type = type;
        this.canonicalName = canonicalName;
        this.filename = filename;
        this.description = description;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public NodeType type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String canonicalName() {
        return this.canonicalName;
    }

    @Override
    @JsonProperty
    public String filename() {
        return this.filename;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    public final ImmutableProtoDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableProtoDescriptor(newValue, this.type, this.canonicalName, this.filename, this.description);
    }

    public final ImmutableProtoDescriptor withType(NodeType value) {
        if (this.type == value) {
            return this;
        }
        NodeType newValue = Preconditions.checkNotNull(value);
        return new ImmutableProtoDescriptor(this.name, newValue, this.canonicalName, this.filename, this.description);
    }

    public final ImmutableProtoDescriptor withCanonicalName(String value) {
        if (this.canonicalName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableProtoDescriptor(this.name, this.type, newValue, this.filename, this.description);
    }

    public final ImmutableProtoDescriptor withFilename(String value) {
        if (this.filename == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableProtoDescriptor(this.name, this.type, this.canonicalName, newValue, this.description);
    }

    public final ImmutableProtoDescriptor withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableProtoDescriptor(this.name, this.type, this.canonicalName, this.filename, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtoDescriptor && this.equalTo((ImmutableProtoDescriptor)another);
    }

    private boolean equalTo(ImmutableProtoDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && this.canonicalName.equals(another.canonicalName) && this.filename.equals(another.filename) && Objects.equal(this.description, another.description);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.canonicalName.hashCode();
        h = h * 17 + this.filename.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ProtoDescriptor").add("name", this.name).add("type", (Object)this.type).add("canonicalName", this.canonicalName).add("filename", this.filename).add("description", this.description).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableProtoDescriptor fromJson(Json json) {
        Builder builder = ImmutableProtoDescriptor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.canonicalName != null) {
            builder.canonicalName(json.canonicalName);
        }
        if (json.filename != null) {
            builder.filename(json.filename);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableProtoDescriptor copyOf(ProtoDescriptor instance) {
        if (instance instanceof ImmutableProtoDescriptor) {
            return (ImmutableProtoDescriptor)instance;
        }
        return ImmutableProtoDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CANONICAL_NAME = 4L;
        private static final long INIT_BIT_FILENAME = 8L;
        private long initBits = 15L;
        @Nullable
        private String name;
        @Nullable
        private NodeType type;
        @Nullable
        private String canonicalName;
        @Nullable
        private String filename;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder from(ProtoDescriptor instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.type(instance.type());
            this.canonicalName(instance.canonicalName());
            this.filename(instance.filename());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(NodeType type) {
            this.type = Preconditions.checkNotNull(type);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder canonicalName(String canonicalName) {
            this.canonicalName = Preconditions.checkNotNull(canonicalName);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder filename(String filename) {
            this.filename = Preconditions.checkNotNull(filename);
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public ImmutableProtoDescriptor build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableProtoDescriptor(this.name, this.type, this.canonicalName, this.filename, this.description);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean canonicalNameIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean filenameIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.canonicalNameIsSet()) {
                attributes.add("canonicalName");
            }
            if (!this.filenameIsSet()) {
                attributes.add("filename");
            }
            return "Cannot build ProtoDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        NodeType type;
        @JsonProperty
        @Nullable
        String canonicalName;
        @JsonProperty
        @Nullable
        String filename;
        @JsonProperty
        @Nullable
        String description;

        Json() {
        }
    }
}

