/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.index.NodeType;
import io.protostuff.generator.html.json.service.ServiceDescriptor;
import io.protostuff.generator.html.json.service.ServiceMethod;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableServiceDescriptor
implements ServiceDescriptor {
    private final String name;
    private final NodeType type;
    private final String canonicalName;
    @Nullable
    private final String description;
    private final ImmutableList<ServiceMethod> methods;

    private ImmutableServiceDescriptor(String name, NodeType type, String canonicalName, @Nullable String description, ImmutableList<ServiceMethod> methods) {
        this.name = name;
        this.type = type;
        this.canonicalName = canonicalName;
        this.description = description;
        this.methods = methods;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public NodeType type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String canonicalName() {
        return this.canonicalName;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonProperty
    public ImmutableList<ServiceMethod> methods() {
        return this.methods;
    }

    public final ImmutableServiceDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceDescriptor(newValue, this.type, this.canonicalName, this.description, this.methods);
    }

    public final ImmutableServiceDescriptor withType(NodeType value) {
        if (this.type == value) {
            return this;
        }
        NodeType newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceDescriptor(this.name, newValue, this.canonicalName, this.description, this.methods);
    }

    public final ImmutableServiceDescriptor withCanonicalName(String value) {
        if (this.canonicalName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceDescriptor(this.name, this.type, newValue, this.description, this.methods);
    }

    public final ImmutableServiceDescriptor withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableServiceDescriptor(this.name, this.type, this.canonicalName, newValue, this.methods);
    }

    public final ImmutableServiceDescriptor withMethods(ServiceMethod ... elements) {
        ImmutableList<ServiceMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public final ImmutableServiceDescriptor withMethods(Iterable<? extends ServiceMethod> elements) {
        if (this.methods == elements) {
            return this;
        }
        ImmutableList<ServiceMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceDescriptor(this.name, this.type, this.canonicalName, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceDescriptor && this.equalTo((ImmutableServiceDescriptor)another);
    }

    private boolean equalTo(ImmutableServiceDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && this.canonicalName.equals(another.canonicalName) && Objects.equal(this.description, another.description) && this.methods.equals(another.methods);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.canonicalName.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.methods.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceDescriptor").add("name", this.name).add("type", (Object)this.type).add("canonicalName", this.canonicalName).add("description", this.description).add("methods", this.methods).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableServiceDescriptor fromJson(Json json) {
        Builder builder = ImmutableServiceDescriptor.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.canonicalName != null) {
            builder.canonicalName(json.canonicalName);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.methods != null) {
            builder.addAllMethods(json.methods);
        }
        return builder.build();
    }

    public static ImmutableServiceDescriptor copyOf(ServiceDescriptor instance) {
        if (instance instanceof ImmutableServiceDescriptor) {
            return (ImmutableServiceDescriptor)instance;
        }
        return ImmutableServiceDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CANONICAL_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private NodeType type;
        @Nullable
        private String canonicalName;
        @Nullable
        private String description;
        private ImmutableList.Builder<ServiceMethod> methodsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(ServiceDescriptor instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.type(instance.type());
            this.canonicalName(instance.canonicalName());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.addAllMethods(instance.methods());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(NodeType type) {
            this.type = Preconditions.checkNotNull(type);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder canonicalName(String canonicalName) {
            this.canonicalName = Preconditions.checkNotNull(canonicalName);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder addMethods(ServiceMethod element) {
            this.methodsBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethods(ServiceMethod ... elements) {
            this.methodsBuilder.add(elements);
            return this;
        }

        public final Builder methods(Iterable<? extends ServiceMethod> elements) {
            this.methodsBuilder = ImmutableList.builder();
            return this.addAllMethods(elements);
        }

        public final Builder addAllMethods(Iterable<? extends ServiceMethod> elements) {
            this.methodsBuilder.addAll(elements);
            return this;
        }

        public ImmutableServiceDescriptor build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableServiceDescriptor(this.name, this.type, this.canonicalName, this.description, (ImmutableList)this.methodsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean canonicalNameIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.canonicalNameIsSet()) {
                attributes.add("canonicalName");
            }
            return "Cannot build ServiceDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        NodeType type;
        @JsonProperty
        @Nullable
        String canonicalName;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        List<ServiceMethod> methods;

        Json() {
        }
    }
}

