/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.html.json.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.protostuff.generator.html.json.service.ServiceMethod;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableServiceMethod
implements ServiceMethod {
    private final String name;
    @Nullable
    private final String description;
    private final String argTypeId;
    private final String returnTypeId;

    private ImmutableServiceMethod(String name, @Nullable String description, String argTypeId, String returnTypeId) {
        this.name = name;
        this.description = description;
        this.argTypeId = argTypeId;
        this.returnTypeId = returnTypeId;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    public String argTypeId() {
        return this.argTypeId;
    }

    @Override
    @JsonProperty
    public String returnTypeId() {
        return this.returnTypeId;
    }

    public final ImmutableServiceMethod withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceMethod(newValue, this.description, this.argTypeId, this.returnTypeId);
    }

    public final ImmutableServiceMethod withDescription(@Nullable String value) {
        if (this.description == value) {
            return this;
        }
        String newValue = value;
        return new ImmutableServiceMethod(this.name, newValue, this.argTypeId, this.returnTypeId);
    }

    public final ImmutableServiceMethod withArgTypeId(String value) {
        if (this.argTypeId == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceMethod(this.name, this.description, newValue, this.returnTypeId);
    }

    public final ImmutableServiceMethod withReturnTypeId(String value) {
        if (this.returnTypeId == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableServiceMethod(this.name, this.description, this.argTypeId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceMethod && this.equalTo((ImmutableServiceMethod)another);
    }

    private boolean equalTo(ImmutableServiceMethod another) {
        return this.name.equals(another.name) && Objects.equal(this.description, another.description) && this.argTypeId.equals(another.argTypeId) && this.returnTypeId.equals(another.returnTypeId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.argTypeId.hashCode();
        h = h * 17 + this.returnTypeId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceMethod").add("name", this.name).add("description", this.description).add("argTypeId", this.argTypeId).add("returnTypeId", this.returnTypeId).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableServiceMethod fromJson(Json json) {
        Builder builder = ImmutableServiceMethod.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.argTypeId != null) {
            builder.argTypeId(json.argTypeId);
        }
        if (json.returnTypeId != null) {
            builder.returnTypeId(json.returnTypeId);
        }
        return builder.build();
    }

    public static ImmutableServiceMethod copyOf(ServiceMethod instance) {
        if (instance instanceof ImmutableServiceMethod) {
            return (ImmutableServiceMethod)instance;
        }
        return ImmutableServiceMethod.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ARG_TYPE_ID = 2L;
        private static final long INIT_BIT_RETURN_TYPE_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String argTypeId;
        @Nullable
        private String returnTypeId;

        private Builder() {
        }

        public final Builder from(ServiceMethod instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            String descriptionValue = instance.description();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            this.argTypeId(instance.argTypeId());
            this.returnTypeId(instance.returnTypeId());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder argTypeId(String argTypeId) {
            this.argTypeId = Preconditions.checkNotNull(argTypeId);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder returnTypeId(String returnTypeId) {
            this.returnTypeId = Preconditions.checkNotNull(returnTypeId);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableServiceMethod build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableServiceMethod(this.name, this.description, this.argTypeId, this.returnTypeId);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean argTypeIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean returnTypeIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.argTypeIdIsSet()) {
                attributes.add("argTypeId");
            }
            if (!this.returnTypeIdIsSet()) {
                attributes.add("returnTypeId");
            }
            return "Cannot build ServiceMethod, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String name;
        @JsonProperty
        @Nullable
        String description;
        @JsonProperty
        @Nullable
        String argTypeId;
        @JsonProperty
        @Nullable
        String returnTypeId;

        Json() {
        }
    }
}

