/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.java;

import com.google.common.collect.ImmutableMap;
import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Oneof;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.ScalarFieldType;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import io.protostuff.generator.ObjectExtender;
import io.protostuff.generator.ProtoCompiler;
import io.protostuff.generator.SimpleObjectExtender;
import io.protostuff.generator.StCompilerFactory;
import io.protostuff.generator.java.EnumUtil;
import io.protostuff.generator.java.MessageFieldUtil;
import io.protostuff.generator.java.MessageUtil;
import io.protostuff.generator.java.ProtoUtil;
import io.protostuff.generator.java.ScalarFieldTypeUtil;
import io.protostuff.generator.java.ServiceUtil;
import io.protostuff.generator.java.UserTypeUtil;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.stringtemplate.v4.AttributeRenderer;

public class JavaGenerator
implements ProtoCompiler {
    public static final String GENERATOR_NAME = "java";
    private final Map<Class<?>, AttributeRenderer> rendererMap;
    private final Map<Class<?>, ObjectExtender<?>> extenderMap;
    private final StCompilerFactory compilerFactory;

    @Inject
    public JavaGenerator(StCompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
        this.rendererMap = new HashMap();
        this.extenderMap = ImmutableMap.builder().put(Proto.class, SimpleObjectExtender.newBuilder().property("generator", ProtoUtil::getGeneratorInfo).property("javaPackage", ProtoUtil::getPackage).property("javaPackagePath", ProtoUtil::getPackagePath).build()).put(ScalarFieldType.class, SimpleObjectExtender.newBuilder().property("javaWrapperType", ScalarFieldTypeUtil::getWrapperType).property("javaPrimitiveType", ScalarFieldTypeUtil::getPrimitiveType).build()).put(Message.class, SimpleObjectExtender.newBuilder().property("javaName", UserTypeUtil::getClassName).property("javaFullName", UserTypeUtil::getCanonicalName).property("hasFields", MessageUtil::hasFields).property("javaBitFieldNames", MessageUtil::bitFieldNames).build()).put(Field.class, SimpleObjectExtender.newBuilder().property("javaType", MessageFieldUtil::getFieldType).property("javaRepeatedType", MessageFieldUtil::getRepeatedFieldType).property("javaIterableType", MessageFieldUtil::getIterableFieldType).property("javaWrapperType", MessageFieldUtil::getWrapperFieldType).property("javaName", MessageFieldUtil::getFieldName).property("jsonName", MessageFieldUtil::getJsonFieldName).property("javaGetterName", MessageFieldUtil::getFieldGetterName).property("javaSetterName", MessageFieldUtil::getFieldSetterName).property("javaCleanerName", MessageFieldUtil::getFieldCleanerName).property("javaRepeatedGetterName", MessageFieldUtil::getRepeatedFieldGetterName).property("javaRepeatedSetterName", MessageFieldUtil::getRepeatedFieldSetterName).property("javaRepeatedAdderName", MessageFieldUtil::getRepeatedFieldAdderName).property("javaRepeatedAddAllName", MessageFieldUtil::getRepeatedFieldAddAllName).property("javaRepeatedGetCountMethodName", MessageFieldUtil::repeatedGetCountMethodName).property("javaRepeatedGetByIndexMethodName", MessageFieldUtil::repeatedGetByIndexMethodName).property("javaMapGetterName", MessageFieldUtil::getMapGetterName).property("javaMapType", MessageFieldUtil::getMapFieldType).property("javaMapKeyType", MessageFieldUtil::getMapFieldKeyType).property("javaMapValueType", MessageFieldUtil::getMapFieldValueType).property("javaMapAdderName", MessageFieldUtil::getMapFieldAdderName).property("javaMapAddAllName", MessageFieldUtil::getMapFieldAddAllName).property("javaMapGetByKeyMethodName", MessageFieldUtil::mapGetByKeyMethodName).property("javaIsMessage", MessageFieldUtil::isMessage).property("javaHasMethodName", MessageFieldUtil::getHasMethodName).property("javaBuilderGetterName", MessageFieldUtil::getBuilderGetterName).property("javaBuilderSetterName", MessageFieldUtil::getBuilderSetterName).property("javaBuilderRepeatedSetterName", MessageFieldUtil::getRepeatedBuilderSetterName).property("javaDefaultValue", MessageFieldUtil::getDefaultValue).property("javaIsNumericType", MessageFieldUtil::isNumericType).property("javaIsBooleanType", MessageFieldUtil::isBooleanType).property("javaIsScalarNullableType", MessageFieldUtil::isScalarNullableType).property("protostuffReadMethod", MessageFieldUtil::protostuffReadMethod).property("protostuffWriteMethod", MessageFieldUtil::protostuffWriteMethod).property("toStringPart", MessageFieldUtil::toStringPart).property("javaBitFieldName", MessageFieldUtil::bitFieldName).property("javaBitFieldIndex", MessageFieldUtil::bitFieldIndex).property("javaBitFieldMask", MessageFieldUtil::bitFieldMask).property("javaOneofConstantName", MessageFieldUtil::javaOneofConstantName).build()).put(Oneof.class, SimpleObjectExtender.newBuilder().property("javaName", MessageUtil::getOneofEnumClassName).property("javaNotSetConstantName", MessageUtil::getOneofNotSetConstantName).property("javaCaseGetterName", MessageUtil::getOneofCaseGetterName).property("javaCaseCleanerName", MessageUtil::getOneofCaseCleanerName).property("javaFieldName", MessageUtil::getOneofFieldName).property("javaCaseFieldName", MessageUtil::getOneofCaseFieldName).build()).put(Enum.class, SimpleObjectExtender.newBuilder().property("javaName", UserTypeUtil::getClassName).property("javaFullName", UserTypeUtil::getCanonicalName).build()).put(EnumConstant.class, SimpleObjectExtender.newBuilder().property("javaName", EnumUtil::getName).build()).put(Service.class, SimpleObjectExtender.newBuilder().property("javaName", ServiceUtil::getClassName).build()).put(ServiceMethod.class, SimpleObjectExtender.newBuilder().property("javaName", ServiceUtil::getMethodName).build()).build();
    }

    @Override
    public String getName() {
        return GENERATOR_NAME;
    }

    @Override
    public void compile(Module module) {
        ProtoCompiler generator = this.compilerFactory.create(module.getTemplate(), this.rendererMap, this.extenderMap);
        generator.compile(module);
    }
}

