/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.generator.java;

import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.UserType;
import io.protostuff.generator.Formatter;
import io.protostuff.generator.java.ProtoUtil;

public class UserTypeUtil {
    public static String getClassName(UserType userType) {
        String name = userType.getName();
        return Formatter.toPascalCase(name);
    }

    public static String getCanonicalName(UserType userType) {
        String canonicalName;
        String name = UserTypeUtil.getClassName(userType);
        if (userType.isNested()) {
            Message parent = (Message)userType.getParent();
            canonicalName = UserTypeUtil.getCanonicalName(parent) + '.' + name;
        } else {
            Proto proto = userType.getProto();
            String aPackage = ProtoUtil.getPackage(proto);
            canonicalName = aPackage.isEmpty() ? name : aPackage + '.' + name;
        }
        return canonicalName;
    }
}

