/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.parser.ProtoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Formatter {
    public String format(String var1);

    public static enum BUILTIN implements Formatter
    {
        UPPER{

            @Override
            public String format(String str) {
                return str.toUpperCase();
            }
        }
        ,
        LOWER{

            @Override
            public String format(String str) {
                return str.toLowerCase();
            }
        }
        ,
        CC{

            @Override
            public String format(String str) {
                return ProtoUtil.toCamelCase((String)str).toString();
            }
        }
        ,
        CCU{

            @Override
            public String format(String str) {
                return ProtoUtil.toCamelCase((String)str).append('_').toString();
            }
        }
        ,
        UC{

            @Override
            public String format(String str) {
                return ProtoUtil.toUnderscoreCase((String)str).toString();
            }
        }
        ,
        UCU{

            @Override
            public String format(String str) {
                return ProtoUtil.toUnderscoreCase((String)str).append('_').toString();
            }
        }
        ,
        UUC{

            @Override
            public String format(String str) {
                return ProtoUtil.toUnderscoreCase((String)str).toString().toUpperCase();
            }
        }
        ,
        PC{

            @Override
            public String format(String str) {
                return ProtoUtil.toPascalCase((String)str).toString();
            }
        }
        ,
        PCS{

            @Override
            public String format(String str) {
                StringBuilder buffer = ProtoUtil.toUnderscoreCase((String)str);
                char c = buffer.charAt(0);
                if (c > '`' && c < '{') {
                    buffer.setCharAt(0, (char)(c - 32));
                }
                int len = buffer.length();
                for (int i = 1; i < len; ++i) {
                    c = buffer.charAt(i);
                    if (' ' == c) {
                        if (++i == len || (c = buffer.charAt(i)) <= '`' || c >= '{') continue;
                        buffer.setCharAt(i, (char)(c - 32));
                        continue;
                    }
                    if (c != '_' || len == i + 1) continue;
                    buffer.setCharAt(i, ' ');
                    c = buffer.charAt(i + 1);
                    if (c <= '`' || c >= '{') continue;
                    buffer.setCharAt(++i, (char)(c - 32));
                }
                return buffer.toString();
            }
        }
        ,
        PSC{

            @Override
            public String format(String str) {
                return PCS.format(str);
            }
        }
        ,
        PLURAL{

            @Override
            public String format(String str) {
                return BUILTIN.pluralize(str);
            }
        }
        ,
        SINGULAR{

            @Override
            public String format(String str) {
                return BUILTIN.singularize(str);
            }
        }
        ,
        TRIM{

            @Override
            public String format(String str) {
                return str.trim();
            }
        }
        ,
        CUT_L{

            @Override
            public String format(String str) {
                if (str.isEmpty()) {
                    return str;
                }
                return str.substring(1, str.length());
            }
        }
        ,
        CUT_R{

            @Override
            public String format(String str) {
                if (str.isEmpty()) {
                    return str;
                }
                return str.substring(0, str.length() - 1);
            }
        };

        private static List<String[]> singulars;
        private static List<String[]> plurals;
        private static List<String[]> irregulars;
        private static List<String> uncountables;

        private static void addPlural(String rule, String replacement) {
            plurals.add(0, new String[]{rule, replacement});
        }

        private static void addSingular(String rule, String replacement) {
            singulars.add(0, new String[]{rule, replacement});
        }

        private static void addIrregular(String rule, String replacement) {
            irregulars.add(new String[]{rule, replacement});
        }

        private static String gsub(String word, String rule, String replacement) {
            Pattern pattern = Pattern.compile(rule, 2);
            Matcher matcher = pattern.matcher(word);
            return matcher.find() ? matcher.replaceFirst(replacement) : null;
        }

        private static String pluralize(String word) {
            if (uncountables.contains(word)) {
                return word;
            }
            for (String[] irregular : irregulars) {
                if (!irregular[0].equalsIgnoreCase(word)) continue;
                return irregular[1];
            }
            for (String[] pair : plurals) {
                String plural = BUILTIN.gsub(word, pair[0], pair[1]);
                if (plural == null) continue;
                return plural;
            }
            return word;
        }

        private static String singularize(String word) {
            if (uncountables.contains(word)) {
                return word;
            }
            for (String[] irregular : irregulars) {
                if (!irregular[1].equalsIgnoreCase(word)) continue;
                return irregular[0];
            }
            for (String[] pair : singulars) {
                String singular = BUILTIN.gsub(word, pair[0], pair[1]);
                if (singular == null) continue;
                return singular;
            }
            return word;
        }

        public static void addAllTo(Map<String, Formatter> map) {
            for (BUILTIN bf : BUILTIN.values()) {
                map.put(bf.name(), bf);
            }
        }

        static {
            singulars = new ArrayList<String[]>();
            plurals = new ArrayList<String[]>();
            irregulars = new ArrayList<String[]>();
            uncountables = new ArrayList<String>();
            BUILTIN.addPlural("$", "s");
            BUILTIN.addPlural("s$", "s");
            BUILTIN.addPlural("(ax|test)is$", "$1es");
            BUILTIN.addPlural("(octop|vir)us$", "$1i");
            BUILTIN.addPlural("(alias|status)$", "$1es");
            BUILTIN.addPlural("(bu)s$", "$1ses");
            BUILTIN.addPlural("(buffal|tomat)o$", "$1oes");
            BUILTIN.addPlural("([ti])um$", "$1a");
            BUILTIN.addPlural("sis$", "ses");
            BUILTIN.addPlural("(?:([^f])fe|([lr])f)$", "$1$2ves");
            BUILTIN.addPlural("(hive)$", "$1s");
            BUILTIN.addPlural("([^aeiouy]|qu)y$", "$1ies");
            BUILTIN.addPlural("(x|ch|ss|sh)$", "$1es");
            BUILTIN.addPlural("(matr|vert|ind)(?:ix|ex)$", "$1ices");
            BUILTIN.addPlural("([m|l])ouse$", "$1ice");
            BUILTIN.addPlural("^(ox)$", "$1en");
            BUILTIN.addPlural("(quiz)$", "$1zes");
            BUILTIN.addSingular("s$", "");
            BUILTIN.addSingular("(n)ews$", "$1ews");
            BUILTIN.addSingular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1sis");
            BUILTIN.addSingular("(^analy)ses$", "$1sis");
            BUILTIN.addSingular("([^f])ves$", "$1fe");
            BUILTIN.addSingular("(hive)s$", "$1");
            BUILTIN.addSingular("(tive)s$", "$1");
            BUILTIN.addSingular("([lr])ves$", "$1f");
            BUILTIN.addSingular("([^aeiouy]|qu)ies$", "$1y");
            BUILTIN.addSingular("(s)eries$", "$1eries");
            BUILTIN.addSingular("(m)ovies$", "$1ovie");
            BUILTIN.addSingular("(x|ch|ss|sh)es$", "$1");
            BUILTIN.addSingular("([m|l])ice$", "$1ouse");
            BUILTIN.addSingular("(bus)es$", "$1");
            BUILTIN.addSingular("(o)es$", "$1");
            BUILTIN.addSingular("(shoe)s$", "$1");
            BUILTIN.addSingular("(cris|ax|test)es$", "$1is");
            BUILTIN.addSingular("(octop|vir)i$", "$1us");
            BUILTIN.addSingular("(alias|status)es$", "$1");
            BUILTIN.addSingular("^(ox)en", "$1");
            BUILTIN.addSingular("(vert|ind)ices$", "$1ex");
            BUILTIN.addSingular("(matr)ices$", "$1ix");
            BUILTIN.addSingular("(quiz)zes$", "$1");
            BUILTIN.addSingular("(database)s$", "$1");
            BUILTIN.addIrregular("person", "people");
            BUILTIN.addIrregular("man", "men");
            BUILTIN.addIrregular("child", "children");
            BUILTIN.addIrregular("sex", "sexes");
            BUILTIN.addIrregular("move", "moves");
            uncountables = Arrays.asList("equipment", "information", "rice", "money", "species", "series", "fish", "sheep", "data", "metadata");
        }
    }
}

