/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.WriteSession;
import io.protostuff.WriteSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class JsonXOutput
extends WriteSession
implements Output,
StatefulOutput {
    private static final byte START_OBJECT = 123;
    private static final byte END_OBJECT = 125;
    private static final byte START_ARRAY = 91;
    private static final byte END_ARRAY = 93;
    private static final byte COMMA = 44;
    private static final byte QUOTE = 34;
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] KEY_SUFFIX_ARRAY = new byte[]{34, 58, 91};
    private static final byte[] KEY_SUFFIX_ARRAY_OBJECT = new byte[]{34, 58, 91, 123};
    private static final byte[] KEY_SUFFIX_ARRAY_STRING = new byte[]{34, 58, 91, 34};
    private static final byte[] KEY_SUFFIX_OBJECT = new byte[]{34, 58, 123};
    private static final byte[] KEY_SUFFIX_STRING = new byte[]{34, 58, 34};
    private static final byte[] KEY_SUFFIX = new byte[]{34, 58};
    private static final byte[] COMMA_AND_QUOTE = new byte[]{44, 34};
    private static final byte[] COMMA_AND_START_OBJECT = new byte[]{44, 123};
    private static final byte[] END_ARRAY_AND_END_OBJECT = new byte[]{93, 125};
    private static final byte[] END_ARRAY__COMMA__QUOTE = new byte[]{93, 44, 34};
    private Schema<?> schema;
    private final boolean numeric;
    private boolean lastRepeated;
    private int lastNumber;
    static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    static final int[] sOutputEscapes;

    public JsonXOutput(LinkedBuffer head, boolean numeric, Schema<?> schema) {
        super(head);
        this.numeric = numeric;
        this.schema = schema;
    }

    public JsonXOutput(LinkedBuffer head, OutputStream out, WriteSession.FlushHandler flushHandler, int nextBufferSize, boolean numeric, Schema<?> schema) {
        super(head, out, flushHandler, nextBufferSize);
        this.numeric = numeric;
        this.schema = schema;
    }

    public JsonXOutput(LinkedBuffer head, OutputStream out, boolean numeric, Schema<?> schema) {
        super(head, out);
        this.numeric = numeric;
        this.schema = schema;
    }

    public void reset() {
        this.lastRepeated = false;
        this.lastNumber = 0;
    }

    public JsonXOutput clear() {
        super.clear();
        return this;
    }

    public JsonXOutput use(Schema<?> schema) {
        this.schema = schema;
        return this;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public int getLastNumber() {
        return this.lastNumber;
    }

    public boolean isLastRepeated() {
        return this.lastRepeated;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    JsonXOutput writeCommaAndStartObject() throws IOException {
        this.tail = this.sink.writeByteArray(COMMA_AND_START_OBJECT, (WriteSession)this, this.tail);
        return this;
    }

    JsonXOutput writeStartObject() throws IOException {
        this.tail = this.sink.writeByte((byte)123, (WriteSession)this, this.tail);
        return this;
    }

    JsonXOutput writeEndObject() throws IOException {
        this.tail = this.sink.writeByte((byte)125, (WriteSession)this, this.tail);
        return this;
    }

    JsonXOutput writeStartArray() throws IOException {
        this.tail = this.sink.writeByte((byte)91, (WriteSession)this, this.tail);
        return this;
    }

    JsonXOutput writeEndArray() throws IOException {
        this.tail = this.sink.writeByte((byte)93, (WriteSession)this, this.tail);
        return this;
    }

    private LinkedBuffer writeKey(int fieldNumber, WriteSink sink, byte[] keySuffix) throws IOException {
        if (this.numeric) {
            if (this.lastRepeated) {
                return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrFromInt(fieldNumber, (WriteSession)this, sink.writeByteArray(END_ARRAY__COMMA__QUOTE, (WriteSession)this, this.tail)));
            }
            if (this.lastNumber == 0) {
                return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrFromInt(fieldNumber, (WriteSession)this, sink.writeByte((byte)34, (WriteSession)this, this.tail)));
            }
            return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrFromInt(fieldNumber, (WriteSession)this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
        }
        if (this.lastRepeated) {
            return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrAscii(this.schema.getFieldName(fieldNumber), (WriteSession)this, sink.writeByteArray(END_ARRAY__COMMA__QUOTE, (WriteSession)this, this.tail)));
        }
        if (this.lastNumber == 0) {
            return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrAscii(this.schema.getFieldName(fieldNumber), (WriteSession)this, sink.writeByte((byte)34, (WriteSession)this, this.tail)));
        }
        return sink.writeByteArray(keySuffix, (WriteSession)this, sink.writeStrAscii(this.schema.getFieldName(fieldNumber), (WriteSession)this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByteArray(value ? TRUE : FALSE, (WriteSession)this, sink.writeByte((byte)44, (WriteSession)this, this.tail));
            return;
        }
        this.tail = sink.writeByteArray(value ? TRUE : FALSE, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY : KEY_SUFFIX));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByte((byte)34, (WriteSession)this, sink.writeByteArrayB64(value, 0, value.length, (WriteSession)this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
            return;
        }
        this.tail = sink.writeByte((byte)34, (WriteSession)this, sink.writeByteArrayB64(value, 0, value.length, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY_STRING : KEY_SUFFIX_STRING)));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (utf8String) {
            if (this.lastNumber == fieldNumber) {
                this.tail = sink.writeByte((byte)34, (WriteSession)this, JsonXOutput.writeUTF8Escaped(value, offset, length, sink, this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
                return;
            }
            this.tail = sink.writeByte((byte)34, (WriteSession)this, JsonXOutput.writeUTF8Escaped(value, offset, length, sink, this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY_STRING : KEY_SUFFIX_STRING)));
            this.lastNumber = fieldNumber;
            this.lastRepeated = repeated;
            return;
        }
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByte((byte)34, (WriteSession)this, sink.writeByteArrayB64(value, offset, length, (WriteSession)this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
            return;
        }
        this.tail = sink.writeByte((byte)34, (WriteSession)this, sink.writeByteArrayB64(value, offset, length, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY_STRING : KEY_SUFFIX_STRING)));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromDouble(value, (WriteSession)this, sink.writeByte((byte)44, (WriteSession)this, this.tail));
            return;
        }
        this.tail = sink.writeStrFromDouble(value, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY : KEY_SUFFIX));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromFloat(value, (WriteSession)this, sink.writeByte((byte)44, (WriteSession)this, this.tail));
            return;
        }
        this.tail = sink.writeStrFromFloat(value, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY : KEY_SUFFIX));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromInt(value, (WriteSession)this, sink.writeByte((byte)44, (WriteSession)this, this.tail));
            return;
        }
        this.tail = sink.writeStrFromInt(value, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY : KEY_SUFFIX));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromLong(value, (WriteSession)this, sink.writeByte((byte)44, (WriteSession)this, this.tail));
            return;
        }
        this.tail = sink.writeStrFromLong(value, (WriteSession)this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY : KEY_SUFFIX));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByte((byte)34, (WriteSession)this, JsonXOutput.writeUTF8Escaped(value, sink, this, sink.writeByteArray(COMMA_AND_QUOTE, (WriteSession)this, this.tail)));
            return;
        }
        this.tail = sink.writeByte((byte)34, (WriteSession)this, JsonXOutput.writeUTF8Escaped(value, sink, this, this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY_STRING : KEY_SUFFIX_STRING)));
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        Schema<?> lastSchema = this.schema;
        this.tail = this.lastNumber == fieldNumber ? sink.writeByteArray(COMMA_AND_START_OBJECT, (WriteSession)this, this.tail) : this.writeKey(fieldNumber, sink, repeated ? KEY_SUFFIX_ARRAY_OBJECT : KEY_SUFFIX_OBJECT);
        this.schema = schema;
        this.lastNumber = 0;
        this.lastRepeated = false;
        schema.writeTo((Output)this, value);
        this.tail = this.lastRepeated ? sink.writeByteArray(END_ARRAY_AND_END_OBJECT, (WriteSession)this, this.tail) : sink.writeByte((byte)125, (WriteSession)this, this.tail);
        this.lastNumber = fieldNumber;
        this.lastRepeated = repeated;
        this.schema = lastSchema;
    }

    private static LinkedBuffer writeUTF8Escaped(byte[] input, int inStart, int inLen, WriteSink sink, WriteSession session, LinkedBuffer lb) throws IOException {
        int lastStart = inStart;
        for (int i = 0; i < inLen; ++i) {
            int dumpLen;
            int escape;
            byte b;
            if ((b = input[inStart++]) > 127 || (escape = sOutputEscapes[b]) == 0) continue;
            if (escape < 0) {
                dumpLen = inStart - lastStart - 1;
                if (dumpLen != 0) {
                    lb = sink.writeByteArray(input, lastStart, dumpLen, session, lb);
                }
                lastStart = inStart;
                if (lb.offset + 6 > lb.buffer.length) {
                    lb = sink.drain(session, lb);
                }
                int value = -(escape + 1);
                lb.buffer[lb.offset++] = 92;
                lb.buffer[lb.offset++] = 117;
                lb.buffer[lb.offset++] = 48;
                lb.buffer[lb.offset++] = 48;
                lb.buffer[lb.offset++] = HEX_BYTES[value >> 4];
                lb.buffer[lb.offset++] = HEX_BYTES[value & 0xF];
                session.size += 6;
                continue;
            }
            dumpLen = inStart - lastStart - 1;
            if (dumpLen != 0) {
                lb = sink.writeByteArray(input, lastStart, dumpLen, session, lb);
            }
            lastStart = inStart;
            if (lb.offset + 2 > lb.buffer.length) {
                lb = sink.drain(session, lb);
            }
            lb.buffer[lb.offset++] = 92;
            lb.buffer[lb.offset++] = (byte)escape;
            session.size += 2;
        }
        int remaining = inStart - lastStart;
        return remaining == 0 ? lb : sink.writeByteArray(input, lastStart, remaining, session, lb);
    }

    private static LinkedBuffer writeUTF8Escaped(String str, WriteSink sink, WriteSession session, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        byte[] buffer = lb.buffer;
        int limit = buffer.length;
        int offset = lb.offset;
        int size = len;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                int escape = sOutputEscapes[c];
                if (escape == 0) {
                    if (offset == limit) {
                        lb.offset = offset;
                        lb = sink.drain(session, lb);
                        offset = lb.offset;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                    buffer[offset++] = (byte)c;
                    continue;
                }
                if (escape < 0) {
                    if (offset + 6 > limit) {
                        lb.offset = offset;
                        lb = sink.drain(session, lb);
                        offset = lb.offset;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                    int value = -(escape + 1);
                    buffer[offset++] = 92;
                    buffer[offset++] = 117;
                    buffer[offset++] = 48;
                    buffer[offset++] = 48;
                    buffer[offset++] = HEX_BYTES[value >> 4];
                    buffer[offset++] = HEX_BYTES[value & 0xF];
                    size += 5;
                    continue;
                }
                if (offset + 2 > limit) {
                    lb.offset = offset;
                    lb = sink.drain(session, lb);
                    offset = lb.offset;
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
                buffer[offset++] = 92;
                buffer[offset++] = (byte)escape;
                ++size;
                continue;
            }
            if (c < '\u0800') {
                if (offset + 2 > limit) {
                    lb.offset = offset;
                    lb = sink.drain(session, lb);
                    offset = lb.offset;
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                ++size;
                continue;
            }
            if (offset + 3 > limit) {
                lb.offset = offset;
                lb = sink.drain(session, lb);
                offset = lb.offset;
                buffer = lb.buffer;
                limit = buffer.length;
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            size += 2;
        }
        session.size += size;
        lb.offset = offset;
        return lb;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }

    static {
        int[] table = new int[128];
        for (int i = 0; i < 32; ++i) {
            table[i] = -(i + 1);
        }
        table[34] = 34;
        table[92] = 92;
        table[8] = 98;
        table[9] = 116;
        table[12] = 102;
        table[10] = 110;
        table[13] = 114;
        sOutputEscapes = table;
    }
}

