/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import io.protostuff.JsonIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public final class SmileIOUtil {
    public static final Factory DEFAULT_SMILE_FACTORY = new Factory();

    private SmileIOUtil() {
    }

    public static Pipe newPipe(byte[] data, boolean numeric) throws IOException {
        return SmileIOUtil.newPipe(data, 0, data.length, numeric);
    }

    public static Pipe newPipe(byte[] data, int offset, int length, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)data, false);
        SmileParser parser = SmileIOUtil.newSmileParser(null, data, offset, offset + length, false, context);
        return JsonIOUtil.newPipe((JsonParser)parser, numeric);
    }

    public static Pipe newPipe(InputStream in, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false);
        SmileParser parser = SmileIOUtil.newSmileParser(in, context.allocReadIOBuffer(), 0, 0, true, context);
        return JsonIOUtil.newPipe((JsonParser)parser, numeric);
    }

    public static SmileParser newSmileParser(InputStream in, byte[] buf, int offset, int limit) throws IOException {
        return SmileIOUtil.newSmileParser(in, buf, offset, limit, false, new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false));
    }

    static SmileParser newSmileParser(InputStream in, byte[] buf, int offset, int limit, boolean bufferRecyclable, IOContext context) throws IOException {
        return new SmileParser(context, DEFAULT_SMILE_FACTORY.getParserFeatures(), DEFAULT_SMILE_FACTORY.getSmileParserFeatures(), DEFAULT_SMILE_FACTORY.getCodec(), DEFAULT_SMILE_FACTORY.getRootByteSymbols().makeChild(1), in, buf, offset, limit, bufferRecyclable);
    }

    public static SmileGenerator newSmileGenerator(OutputStream out, byte[] buf) {
        return SmileIOUtil.newSmileGenerator(out, buf, 0, false, new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)out, false));
    }

    static SmileGenerator newSmileGenerator(OutputStream out, byte[] buf, int offset, boolean bufferRecyclable, IOContext context) {
        return new SmileGenerator(context, DEFAULT_SMILE_FACTORY.getGeneratorFeatures(), DEFAULT_SMILE_FACTORY.getSmileGeneratorFeatures(), DEFAULT_SMILE_FACTORY.getCodec(), out, buf, offset, bufferRecyclable);
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        SmileIOUtil.mergeFrom(data, 0, data.length, message, schema, numeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)data, false);
        try (SmileParser parser = SmileIOUtil.newSmileParser(null, data, offset, offset + length, false, context);){
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false);
        try (SmileParser parser = SmileIOUtil.newSmileParser(in, context.allocReadIOBuffer(), 0, 0, true, context);){
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false);
        try (SmileParser parser = SmileIOUtil.newSmileParser(in, buffer.buffer, 0, 0, false, context);){
            JsonIOUtil.mergeFrom((JsonParser)parser, message, schema, numeric);
        }
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SmileIOUtil.writeTo(baos, message, schema, numeric);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SmileIOUtil.writeTo(baos, message, schema, numeric, buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)out, false);
        try (SmileGenerator generator = SmileIOUtil.newSmileGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);){
            JsonIOUtil.writeTo((JsonGenerator)generator, message, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)out, false);
        try (SmileGenerator generator = SmileIOUtil.newSmileGenerator(out, buffer.buffer, 0, false, context);){
            JsonIOUtil.writeTo((JsonGenerator)generator, message, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)out, false);
        try (SmileGenerator generator = SmileIOUtil.newSmileGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);){
            JsonIOUtil.writeListTo((JsonGenerator)generator, messages, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)out, false);
        try (SmileGenerator generator = SmileIOUtil.newSmileGenerator(out, buffer.buffer, 0, false, context);){
            JsonIOUtil.writeListTo((JsonGenerator)generator, messages, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false);
        try (SmileParser parser = SmileIOUtil.newSmileParser(in, context.allocReadIOBuffer(), 0, 0, true, context);){
            List<T> list = JsonIOUtil.parseListFrom((JsonParser)parser, schema, numeric);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_SMILE_FACTORY._getBufferRecycler(), (Object)in, false);
        try (SmileParser parser = SmileIOUtil.newSmileParser(in, buffer.buffer, 0, 0, false, context);){
            List<T> list = JsonIOUtil.parseListFrom((JsonParser)parser, schema, numeric);
            return list;
        }
    }

    static {
        DEFAULT_SMILE_FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        DEFAULT_SMILE_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public static final class Factory
    extends SmileFactory {
        public ByteQuadsCanonicalizer getRootByteSymbols() {
            return this._byteSymbolCanonicalizer;
        }

        public int getParserFeatures() {
            return this._parserFeatures;
        }

        public int getSmileParserFeatures() {
            return this._smileParserFeatures;
        }

        public int getGeneratorFeatures() {
            return this._generatorFeatures;
        }

        public int getSmileGeneratorFeatures() {
            return this._smileGeneratorFeatures;
        }
    }
}

