/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.maven;

import io.protostuff.compiler.maven.AbstractGeneratorMojo;
import io.protostuff.compiler.model.ImmutableModuleConfiguration;
import io.protostuff.compiler.model.ModuleConfiguration;
import io.protostuff.generator.ProtostuffCompiler;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="java", threadSafe=true, configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JavaGeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter
    private File target;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProtostuffCompiler compiler = new ProtostuffCompiler();
        Path sourcePath = this.getSourcePath();
        String output = this.computeSourceOutputDir(this.target);
        List<String> protoFiles = this.findProtoFiles(sourcePath);
        ImmutableModuleConfiguration moduleConfiguration = ImmutableModuleConfiguration.builder().name("java").includePaths(Collections.singletonList(sourcePath)).generator("java").output(output).protoFiles(protoFiles).build();
        compiler.compile((ModuleConfiguration)moduleConfiguration);
        this.addGeneratedSourcesToProject(output);
    }
}

