/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.AnnotationContainer;
import io.protostuff.parser.ConfiguredReference;
import io.protostuff.parser.EnumField;
import io.protostuff.parser.HasName;
import io.protostuff.parser.HasOptions;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class EnumGroup
extends AnnotationContainer
implements HasName,
HasOptions {
    public static final boolean ENUM_ALLOW_ALIAS = Boolean.parseBoolean("protostuff.enum_allow_alias");
    final String name;
    final Message parentMessage;
    final Proto proto;
    final LinkedHashMap<String, Value> values = new LinkedHashMap();
    final ArrayList<Value> sortedValues = new ArrayList();
    final LinkedHashMap<String, Object> standardOptions = new LinkedHashMap();
    final LinkedHashMap<String, Object> extraOptions = new LinkedHashMap();
    private ArrayList<Value> indexedValues;
    private ArrayList<Value> uniqueSortedValues;

    public EnumGroup(String name, Message parentMessage, Proto proto) {
        this.name = name;
        this.parentMessage = parentMessage;
        if (parentMessage != null) {
            this.proto = parentMessage.getProto();
            parentMessage.addNestedEnumGroup(this);
        } else {
            this.proto = proto;
            proto.addEnumGroup(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isNested()) {
            buffer.append(this.parentMessage.getFullName()).append('.').append(this.name);
        } else {
            buffer.append(this.getProto().getPackageName()).append('.').append(this.name);
        }
        return buffer.toString();
    }

    public String getJavaFullName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isNested()) {
            buffer.append(this.parentMessage.getJavaFullName()).append('.').append(this.name);
        } else {
            buffer.append(this.getProto().getJavaPackageName()).append('.').append(this.name);
        }
        return buffer.toString();
    }

    public String getRelativeName() {
        return this.isNested() ? this.parentMessage.getRelativeName() + "." + this.name : this.name;
    }

    public Message getParentMessage() {
        return this.parentMessage;
    }

    public boolean isNested() {
        return this.parentMessage != null;
    }

    @Override
    public Proto getProto() {
        return this.proto;
    }

    @Override
    public void putStandardOption(String key, Object value) {
        this.putExtraOption(key, value);
        this.standardOptions.put(key, value);
    }

    @Override
    public void putExtraOption(String key, Object value) {
        if (this.extraOptions.put(key, value) != null) {
            throw EnumGroup.err("Duplicate enum option: " + key, this.getProto());
        }
    }

    public LinkedHashMap<String, Object> getStandardOptions() {
        return this.standardOptions;
    }

    public Object getStandardOption(String key) {
        return this.standardOptions.get(key);
    }

    public LinkedHashMap<String, Object> getExtraOptions() {
        return this.extraOptions;
    }

    public LinkedHashMap<String, Object> getO() {
        return this.getOptions();
    }

    public LinkedHashMap<String, Object> getOptions() {
        return this.extraOptions;
    }

    public <V> V getExtraOption(String key) {
        return (V)this.extraOptions.get(key);
    }

    public Value getValue(int index) {
        if (this.indexedValues == null) {
            this.indexedValues = new ArrayList<Value>(this.values.values());
        }
        return this.indexedValues.get(index);
    }

    public Value getValue(String name) {
        return this.values.get(name);
    }

    public Collection<Value> getValues() {
        return this.values.values();
    }

    public LinkedHashMap<String, Value> getValueMap() {
        return this.values;
    }

    public ArrayList<Value> getSortedValues() {
        return this.sortedValues;
    }

    public Value getFirstValue() {
        if (this.indexedValues == null) {
            this.indexedValues = new ArrayList<Value>(this.values.values());
        }
        return this.indexedValues.get(0);
    }

    public int getValueCount() {
        return this.values.size();
    }

    void add(Value value) {
        if (this.values.put(value.name, value) != null) {
            throw EnumGroup.err("The enum " + this.name + " has duplicate names: " + value.name, this.getProto());
        }
        this.sortedValues.add(value);
    }

    void cacheFullyQualifiedName() {
        Boolean b = (Boolean)((LinkedHashMap)this.getOptions()).get("allow_alias");
        if (b != null) {
            if (b.booleanValue()) {
                Collections.sort(this.sortedValues);
            } else {
                Collections.sort(this.sortedValues, Value.NO_ALIAS_COMPARATOR);
            }
        } else if (ENUM_ALLOW_ALIAS) {
            Collections.sort(this.sortedValues);
        } else {
            Collections.sort(this.sortedValues, Value.NO_ALIAS_COMPARATOR);
        }
        Proto proto = this.getProto();
        String fullName = this.getFullName();
        proto.fullyQualifiedEnumGroups.put(fullName, this);
        if (!this.standardOptions.isEmpty()) {
            proto.references.add(new ConfiguredReference(this.standardOptions, this.extraOptions, fullName));
        }
        for (Value v : this.values.values()) {
            if (v.field.standardOptions.isEmpty()) continue;
            proto.references.add(new ConfiguredReference(v.field.standardOptions, v.field.extraOptions, fullName));
        }
    }

    public ArrayList<Value> getUniqueSortedValues() {
        if (this.uniqueSortedValues != null) {
            return this.uniqueSortedValues;
        }
        this.uniqueSortedValues = new ArrayList();
        Value last = null;
        for (Value v : this.sortedValues) {
            if (last == null || v.number != last.number) {
                this.uniqueSortedValues.add(v);
            }
            last = v;
        }
        return this.uniqueSortedValues;
    }

    public String toString() {
        return '{' + "name:" + this.name + ',' + "values:" + this.values + '}';
    }

    public static class Value
    extends AnnotationContainer
    implements Comparable<Value>,
    HasName {
        public static final Comparator<Value> NO_ALIAS_COMPARATOR = new Comparator<Value>(){

            @Override
            public int compare(Value v1, Value v2) {
                if (v1.number == v2.number) {
                    throw AnnotationContainer.err("The enum value " + v2.enumGroup.getName() + "." + v2.getName() + " cannot have the same number as " + v1.enumGroup.getName() + "." + v1.getName(), v2.enumGroup.getProto());
                }
                return v1.number - v2.number;
            }
        };
        final String name;
        final int number;
        final EnumGroup enumGroup;
        public final EnumField field = new EnumField(this);

        public Value(String name, int number, EnumGroup enumGroup) {
            this.name = name;
            this.number = number;
            this.enumGroup = enumGroup;
            this.field.enumGroup = enumGroup;
            this.field.name = name;
            enumGroup.add(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        @Override
        public Proto getProto() {
            return this.enumGroup.getProto();
        }

        public EnumGroup getEnumGroup() {
            return this.enumGroup;
        }

        public EnumGroup getEg() {
            return this.enumGroup;
        }

        public LinkedHashMap<String, Object> getStandardOptions() {
            return this.field.getStandardOptions();
        }

        public LinkedHashMap<String, Object> getExtraOptions() {
            return this.field.getExtraOptions();
        }

        public LinkedHashMap<String, Object> getO() {
            return this.getOptions();
        }

        public LinkedHashMap<String, Object> getOptions() {
            return this.field.getOptions();
        }

        public String toString() {
            return this.name + ':' + this.number;
        }

        @Override
        public int compareTo(Value o) {
            return o.number < this.number ? 1 : -1;
        }
    }
}

