/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.HasName;
import io.protostuff.parser.Proto;
import java.util.LinkedHashMap;

public class ConfiguredReference {
    public static final boolean RESOLVE_ENUM_VALUE_REF = Boolean.getBoolean("protostuff.resolve_enum_value_ref");
    final LinkedHashMap<String, Object> source;
    final LinkedHashMap<String, Object> destination;
    String enclosingNamespace;

    public ConfiguredReference(LinkedHashMap<String, Object> source, LinkedHashMap<String, Object> destination, String enclosingNamespace) {
        this.source = source;
        this.destination = destination;
        this.enclosingNamespace = enclosingNamespace;
    }

    void resolve(Proto proto) {
        ConfiguredReference.resolve(proto, this.source, this.destination, this.enclosingNamespace);
    }

    static void resolve(Proto proto, LinkedHashMap<String, Object> source, LinkedHashMap<String, Object> destination, String enclosingNamespace) {
        String[] keys;
        for (String key : keys = source.keySet().toArray(new String[source.size()])) {
            EnumGroup eg;
            EnumGroup.Value v;
            String egName;
            int dot;
            Object val = source.get(key);
            if (!(val instanceof String)) continue;
            String refName = (String)val;
            String ns = enclosingNamespace == null ? proto.getPackageName() : enclosingNamespace;
            HasName hn = proto.findReference(refName, ns);
            if (hn != null) {
                destination.put(key, hn);
                continue;
            }
            if (!RESOLVE_ENUM_VALUE_REF || (dot = refName.lastIndexOf(46)) <= 0 || !((hn = proto.findReference(egName = refName.substring(0, dot), ns)) instanceof EnumGroup) || (v = (eg = (EnumGroup)hn).getValue(refName.substring(dot + 1))) == null) continue;
            destination.put(key, v);
        }
    }
}

