/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public final class XmlIOFactoryUtil {
    static final String CONFIGURED_INPUT_FACTORY = System.getProperty("javax.xml.stream.XMLInputFactory");
    static final String CONFIGURED_OUTPUT_FACTORY = System.getProperty("javax.xml.stream.XMLOutputFactory");
    static final boolean CHECK_PARENT = Boolean.getBoolean("protostuff.loader.check_parent");
    private static final String[] INPUT_FACTORY_IMPLS = new String[]{"com.fasterxml.aalto.stax.InputFactoryImpl", "com.ctc.wstx.stax.WstxInputFactory", "com.sun.xml.fastinfoset.stax.factory.StAXInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl"};
    private static final String[] OUTPUT_FACTORY_IMPLS = new String[]{"com.fasterxml.aalto.stax.OutputFactoryImpl", "com.ctc.wstx.stax.WstxOutputFactory", "com.sun.xml.fastinfoset.stax.factory.StAXOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl"};
    public static final XMLInputFactory DEFAULT_INPUT_FACTORY = XmlIOFactoryUtil.newXMLInputFactory();
    public static final XMLOutputFactory DEFAULT_OUTPUT_FACTORY = XmlIOFactoryUtil.newXMLOutputFactory();

    private XmlIOFactoryUtil() {
    }

    static XMLInputFactory newXMLInputFactory() {
        if (CONFIGURED_INPUT_FACTORY != null) {
            Class<?> c = XmlIOFactoryUtil.loadClass(CONFIGURED_INPUT_FACTORY, XmlIOFactoryUtil.class, CHECK_PARENT);
            if (c == null) {
                throw new IllegalStateException("Could not load class: " + CONFIGURED_INPUT_FACTORY);
            }
            try {
                return (XMLInputFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : INPUT_FACTORY_IMPLS) {
            Class<?> c = XmlIOFactoryUtil.loadClass(s, XmlIOFactoryUtil.class, CHECK_PARENT);
            if (c == null) continue;
            try {
                return (XMLInputFactory)c.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot find impl for javax.xml.stream.XMLInputFactory");
    }

    static XMLOutputFactory newXMLOutputFactory() {
        if (CONFIGURED_OUTPUT_FACTORY != null) {
            Class<?> c = XmlIOFactoryUtil.loadClass(CONFIGURED_OUTPUT_FACTORY, XmlIOFactoryUtil.class, CHECK_PARENT);
            if (c == null) {
                throw new IllegalStateException("Could not load class: " + CONFIGURED_OUTPUT_FACTORY);
            }
            try {
                return (XMLOutputFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : OUTPUT_FACTORY_IMPLS) {
            Class<?> c = XmlIOFactoryUtil.loadClass(s, XmlIOFactoryUtil.class, CHECK_PARENT);
            if (c == null) continue;
            try {
                return (XMLOutputFactory)c.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot find impl for javax.xml.stream.XMLOutputFactory");
    }

    static Class<?> loadClass(String className, Class<?> context, boolean checkParent) {
        Class<?> clazz;
        block5: {
            clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (context == null) break block5;
                ClassLoader loader = context.getClassLoader();
                while (loader != null) {
                    try {
                        clazz = loader.loadClass(className);
                        return clazz;
                    }
                    catch (ClassNotFoundException e1) {
                        loader = checkParent ? loader.getParent() : null;
                    }
                }
            }
        }
        return clazz;
    }
}

