/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.XmlIOFactoryUtil;
import io.protostuff.XmlInput;
import io.protostuff.XmlInputException;
import io.protostuff.XmlOutput;
import io.protostuff.XmlOutputException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class XmlIOUtil {
    public static final String XML_ENCODING = "UTF-8";
    public static final String XML_VERSION = "1.0";

    private XmlIOUtil() {
    }

    public static Pipe newPipe(byte[] data) throws IOException {
        return XmlIOUtil.newPipe(data, 0, data.length);
    }

    public static Pipe newPipe(byte[] data, int offset, int length) throws IOException {
        return XmlIOUtil.newPipe(new ByteArrayInputStream(data, offset, length));
    }

    public static Pipe newPipe(InputStream in) throws IOException {
        try {
            return XmlIOUtil.newPipe(XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY.createXMLStreamReader(in, XML_ENCODING));
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    public static Pipe newPipe(Reader reader) throws IOException {
        try {
            return XmlIOUtil.newPipe(XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY.createXMLStreamReader(reader));
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    public static Pipe newPipe(final XMLStreamReader parser) {
        final XmlInput xmlInput = new XmlInput(parser);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                try {
                    if (parser.nextTag() != 1 || !pipeSchema.wrappedSchema.messageName().equals(parser.getLocalName())) {
                        throw new XmlInputException("Expected token START_ELEMENT: " + pipeSchema.wrappedSchema.messageName());
                    }
                    if (parser.nextTag() == 2) {
                        return null;
                    }
                }
                catch (XMLStreamException e) {
                    throw new XmlInputException(e);
                }
                return xmlInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        // empty catch block
                    }
                    return;
                }
                assert (input == xmlInput);
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
            }
        };
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema) {
        XmlIOUtil.mergeFrom(data, 0, data.length, message, schema, XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int len, T message, Schema<T> schema) {
        XmlIOUtil.mergeFrom(data, offset, len, message, schema, XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int len, T message, Schema<T> schema, XMLInputFactory inFactory) {
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        try {
            XmlIOUtil.mergeFrom(in, message, schema, inFactory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        XmlIOUtil.mergeFrom(in, message, schema, XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, XMLInputFactory inFactory) throws IOException {
        XMLStreamReader parser = null;
        try {
            parser = inFactory.createXMLStreamReader(in, XML_ENCODING);
            XmlIOUtil.mergeFrom(parser, message, schema);
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> void mergeFrom(Reader r, T message, Schema<T> schema) throws IOException {
        XmlIOUtil.mergeFrom(r, message, schema, XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY);
    }

    public static <T> void mergeFrom(Reader r, T message, Schema<T> schema, XMLInputFactory inFactory) throws IOException {
        XMLStreamReader parser = null;
        try {
            parser = inFactory.createXMLStreamReader(r);
            XmlIOUtil.mergeFrom(parser, message, schema);
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> void mergeFrom(XMLStreamReader parser, T message, Schema<T> schema) throws IOException, XMLStreamException, XmlInputException {
        if (parser.nextTag() != 1 || !schema.messageName().equals(parser.getLocalName())) {
            throw new XmlInputException("Expected token START_ELEMENT: " + schema.messageName());
        }
        if (parser.nextTag() == 2) {
            return;
        }
        schema.mergeFrom((Input)new XmlInput(parser), message);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema) {
        return XmlIOUtil.toByteArray(message, schema, XmlIOFactoryUtil.DEFAULT_OUTPUT_FACTORY);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, XMLOutputFactory outFactory) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XmlIOUtil.writeTo(out, message, schema, outFactory);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return out.toByteArray();
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema) throws IOException {
        XmlIOUtil.writeTo(out, message, schema, XmlIOFactoryUtil.DEFAULT_OUTPUT_FACTORY);
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, XMLOutputFactory outFactory) throws IOException {
        XMLStreamWriter writer = null;
        try {
            writer = outFactory.createXMLStreamWriter(out, XML_ENCODING);
            writer.writeStartDocument(XML_ENCODING, XML_VERSION);
            XmlIOUtil.writeTo(writer, message, schema);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> void writeTo(Writer w, T message, Schema<T> schema) throws IOException {
        XmlIOUtil.writeTo(w, message, schema, XmlIOFactoryUtil.DEFAULT_OUTPUT_FACTORY);
    }

    public static <T> void writeTo(Writer w, T message, Schema<T> schema, XMLOutputFactory outFactory) throws IOException {
        XMLStreamWriter writer = null;
        try {
            writer = outFactory.createXMLStreamWriter(w);
            writer.writeStartDocument(XML_ENCODING, XML_VERSION);
            XmlIOUtil.writeTo(writer, message, schema);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> void writeTo(XMLStreamWriter writer, T message, Schema<T> schema) throws IOException, XMLStreamException, XmlOutputException {
        writer.writeStartElement(schema.messageName());
        schema.writeTo((Output)new XmlOutput(writer, schema), message);
        writer.writeEndElement();
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema) throws IOException {
        XmlIOUtil.writeListTo(out, messages, schema, XmlIOFactoryUtil.DEFAULT_OUTPUT_FACTORY);
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, XMLOutputFactory outFactory) throws IOException {
        XMLStreamWriter writer = null;
        try {
            writer = outFactory.createXMLStreamWriter(out, XML_ENCODING);
            writer.writeStartDocument(XML_ENCODING, XML_VERSION);
            XmlIOUtil.writeListTo(writer, messages, schema);
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> void writeListTo(XMLStreamWriter writer, List<T> messages, Schema<T> schema) throws IOException, XMLStreamException {
        writer.writeStartElement("list");
        if (messages.isEmpty()) {
            writer.writeEndElement();
            return;
        }
        String simpleName = schema.messageName();
        XmlOutput output = new XmlOutput(writer, schema);
        for (T m : messages) {
            writer.writeStartElement(simpleName);
            schema.writeTo((Output)output, m);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema) throws IOException {
        return XmlIOUtil.parseListFrom(in, schema, XmlIOFactoryUtil.DEFAULT_INPUT_FACTORY);
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, XMLInputFactory inFactory) throws IOException {
        XMLStreamReader parser = null;
        try {
            parser = inFactory.createXMLStreamReader(in);
            List<T> list = XmlIOUtil.parseListFrom(parser, schema);
            return list;
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public static <T> List<T> parseListFrom(XMLStreamReader parser, Schema<T> schema) throws IOException, XMLStreamException {
        if (parser.nextTag() != 1 || !"list".equals(parser.getLocalName())) {
            throw new XmlInputException("Expected token START_ELEMENT: list");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        XmlInput input = new XmlInput(parser);
        int tag = parser.nextTag();
        while (tag != 2) {
            if (tag != 1 || !schema.messageName().equals(parser.getLocalName())) {
                throw new XmlInputException("Expected token START_ELEMENT: " + schema.messageName());
            }
            Object message = schema.newMessage();
            if (parser.nextTag() == 2) {
                list.add(message);
            } else {
                schema.mergeFrom((Input)input, message);
                list.add(message);
            }
            tag = parser.nextTag();
        }
        return list;
    }
}

