/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.B64Code;
import io.protostuff.ByteString;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import io.protostuff.XmlInputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XmlInput
implements Input {
    private static final byte[] EMPTY = new byte[0];
    private final XMLStreamReader parser;
    private boolean emptyMessage = false;

    public XmlInput(XMLStreamReader parser) {
        this.parser = parser;
    }

    private int next() throws IOException {
        try {
            return this.parser.next();
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private int nextTag() throws IOException {
        try {
            return this.parser.nextTag();
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private byte[] getB64Decoded() throws IOException {
        try {
            int next = this.parser.next();
            while (true) {
                switch (next) {
                    case 4: {
                        byte[] decoded = B64Code.cdecode((char[])this.parser.getTextCharacters(), (int)this.parser.getTextStart(), (int)this.parser.getTextLength());
                        while (2 != this.parser.next()) {
                        }
                        this.parser.nextTag();
                        return decoded;
                    }
                    case 2: {
                        this.parser.nextTag();
                        return EMPTY;
                    }
                }
                next = this.parser.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    private String getText() throws IOException {
        try {
            String text = this.parser.getElementText();
            this.parser.nextTag();
            return text;
        }
        catch (XMLStreamException e) {
            throw new XmlInputException(e);
        }
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        String name = this.parser.getLocalName();
        while (true) {
            switch (this.next()) {
                case 2: {
                    if (name.equals(this.parser.getLocalName())) {
                        this.nextTag();
                        return;
                    }
                    throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                }
                case 1: 
                case 8: {
                    throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                }
            }
        }
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (this.emptyMessage) {
            this.emptyMessage = false;
            return 0;
        }
        if (this.parser.getEventType() == 2) {
            return 0;
        }
        String name = this.parser.getLocalName();
        int num = schema.getFieldNumber(name);
        if (num == 0) {
            while (true) {
                switch (this.next()) {
                    case 2: {
                        if (name.equals(this.parser.getLocalName())) {
                            this.nextTag();
                            return this.readFieldNumber(schema);
                        }
                        throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                    }
                    case 1: 
                    case 8: {
                        throw new XmlInputException("Unknown field: " + name + " on message " + schema.messageFullName());
                    }
                }
            }
        }
        return num;
    }

    public int readInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readUInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readSInt32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readFixed32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public int readSFixed32() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public long readInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readUInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readSInt64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readFixed64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public long readSFixed64() throws IOException {
        return Long.parseLong(this.getText());
    }

    public float readFloat() throws IOException {
        return Float.parseFloat(this.getText());
    }

    public double readDouble() throws IOException {
        return Double.parseDouble(this.getText());
    }

    public boolean readBool() throws IOException {
        return Boolean.parseBoolean(this.getText());
    }

    public int readEnum() throws IOException {
        return Integer.parseInt(this.getText());
    }

    public String readString() throws IOException {
        return this.getText();
    }

    public ByteString readBytes() throws IOException {
        return ByteString.wrap((byte[])this.readByteArray());
    }

    public byte[] readByteArray() throws IOException {
        return this.getB64Decoded();
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        boolean bl = this.emptyMessage = this.nextTag() == 2;
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.nextTag();
        return value;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        if (utf8String) {
            output.writeString(fieldNumber, this.readString(), repeated);
        } else {
            output.writeByteArray(fieldNumber, this.readByteArray(), repeated);
        }
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    public void readBytes(ByteBuffer bb) throws IOException {
        bb.put(this.getB64Decoded());
    }
}

