/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.B64Code;
import io.protostuff.ByteString;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.StringSerializer;
import io.protostuff.XmlOutputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlOutput
implements Output,
StatefulOutput {
    static final char[] EMPTY = new char[0];
    private final XMLStreamWriter writer;
    private Schema<?> schema;

    public XmlOutput(XMLStreamWriter writer) {
        this(writer, null);
    }

    public XmlOutput(XMLStreamWriter writer, Schema<?> schema) {
        this.writer = writer;
        this.schema = schema;
    }

    public XmlOutput use(Schema<?> schema) {
        this.schema = schema;
        return this;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    private static void write(XMLStreamWriter writer, String name, String value) throws IOException {
        try {
            writer.writeStartElement(name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
    }

    private static void writeB64Encoded(XMLStreamWriter writer, String name, char[] value) throws IOException {
        try {
            writer.writeStartElement(name);
            writer.writeCharacters(value, 0, value.length);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Long.toString(value));
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Float.toString(value));
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Double.toString(value));
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), String.valueOf(value));
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), Integer.toString(value));
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        XmlOutput.write(this.writer, this.schema.getFieldName(fieldNumber), value);
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        XmlOutput.writeB64Encoded(this.writer, this.schema.getFieldName(fieldNumber), value.length == 0 ? EMPTY : B64Code.cencode((byte[])value));
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        if (utf8String) {
            this.writeString(fieldNumber, StringSerializer.STRING.deser((byte[])value, (int)offset, (int)length), repeated);
        } else {
            XmlOutput.writeB64Encoded(this.writer, this.schema.getFieldName(fieldNumber), length == 0 ? EMPTY : B64Code.cencode((byte[])value, (int)offset, (int)length));
        }
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        Schema<?> lastSchema = this.schema;
        this.schema = schema;
        XMLStreamWriter writer = this.writer;
        try {
            writer.writeStartElement(lastSchema.getFieldName(fieldNumber));
            schema.writeTo((Output)this, value);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlOutputException(e);
        }
        this.schema = lastSchema;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

