/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.WriteSession;
import io.protostuff.XmlXOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class XmlXIOUtil {
    static final byte[] HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();

    private XmlXIOUtil() {
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        XmlXOutput output = new XmlXOutput(buffer, schema);
        String name = schema.messageName();
        try {
            output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByte((byte)60, (WriteSession)output, output.sink.writeByteArray(HEADER, (WriteSession)output, output.tail))));
            schema.writeTo((Output)output, message);
            output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByteArray(XmlXOutput.START_SLASH_TAG, (WriteSession)output, output.tail)));
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> int writeTo(LinkedBuffer buffer, T message, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        XmlXOutput output = new XmlXOutput(buffer, schema);
        String name = schema.messageName();
        try {
            output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByte((byte)60, (WriteSession)output, output.sink.writeByteArray(HEADER, (WriteSession)output, output.tail))));
            schema.writeTo((Output)output, message);
            output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByteArray(XmlXOutput.START_SLASH_TAG, (WriteSession)output, output.tail)));
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        XmlXOutput output = new XmlXOutput(buffer, out, schema);
        String name = schema.messageName();
        output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByte((byte)60, (WriteSession)output, output.sink.writeByteArray(HEADER, (WriteSession)output, output.tail))));
        schema.writeTo((Output)output, message);
        output.tail = output.sink.writeByte((byte)62, (WriteSession)output, output.sink.writeStrAscii(name, (WriteSession)output, output.sink.writeByteArray(XmlXOutput.START_SLASH_TAG, (WriteSession)output, output.tail)));
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        return output.size;
    }
}

