/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.WriteSession;
import io.protostuff.WriteSink;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class YamlOutput
extends WriteSession
implements Output,
StatefulOutput {
    public static final int LINE_BREAK_LEN = "crlf".equalsIgnoreCase(System.getProperty("yamloutput.linebreak")) ? 2 : 1;
    public static final int EXTRA_INDENT = Integer.getInteger("yamloutput.extra_indent", 0);
    private static final byte[] COLON_AND_SPACE = new byte[]{58, 32};
    private static final byte[] DASH_AND_SPACE = new byte[]{45, 32};
    private static final byte[] EMPTY_ARRAY = new byte[]{91, 93};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte EXCLAMATION = 33;
    private int indent = 0;
    private int lastNumber = 0;
    private Schema<?> schema;

    public YamlOutput(LinkedBuffer buffer, Schema<?> schema) {
        super(buffer);
        this.schema = schema;
    }

    public YamlOutput(LinkedBuffer buffer, OutputStream out, WriteSession.FlushHandler flushHandler, int nextBufferSize, Schema<?> schema) {
        super(buffer, out, flushHandler, nextBufferSize);
        this.schema = schema;
    }

    public YamlOutput(LinkedBuffer buffer, OutputStream out, Schema<?> schema) {
        super(buffer, out);
        this.schema = schema;
    }

    public void reset() {
        this.indent = 0;
        this.lastNumber = 0;
    }

    public YamlOutput clear() {
        super.clear();
        return this;
    }

    public YamlOutput use(Schema<?> schema) {
        this.schema = schema;
        return this;
    }

    public void updateLast(Schema<?> schema, Schema<?> lastSchema) {
        if (lastSchema != null && lastSchema == this.schema) {
            this.schema = schema;
        }
    }

    YamlOutput writeSequenceDelim() throws IOException {
        this.tail = this.sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(this.indent, this.sink, this, this.tail));
        this.indent = YamlOutput.inc(this.indent, 2);
        return this;
    }

    private static int inc(int target, int byAmount) {
        return target + byAmount + EXTRA_INDENT;
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByteArray(value ? TRUE : FALSE, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeByteArray(value ? TRUE : FALSE, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromDouble(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeStrFromDouble(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromFloat(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeStrFromFloat(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeEnum(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromInt(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeStrFromInt(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, value, repeated);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrFromLong(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeStrFromLong(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.writeInt64(fieldNumber, value, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeStrUTF8(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeStrUTF8(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] value, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByteArrayB64(value, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeByteArrayB64(value, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        if (utf8String) {
            if (this.lastNumber == fieldNumber) {
                this.tail = sink.writeByteArray(value, offset, length, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
                return;
            }
            this.tail = sink.writeByteArray(value, offset, length, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
            this.lastNumber = fieldNumber;
            return;
        }
        if (this.lastNumber == fieldNumber) {
            this.tail = sink.writeByteArrayB64(value, offset, length, (WriteSession)this, sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(YamlOutput.inc(this.indent, 2), sink, this, this.tail)));
            return;
        }
        this.tail = sink.writeByteArrayB64(value, offset, length, (WriteSession)this, YamlOutput.writeKey(this.schema.getFieldName(fieldNumber), this.indent, repeated, sink, this, this.tail));
        this.lastNumber = fieldNumber;
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        WriteSink sink = this.sink;
        int lastIndent = this.indent;
        Schema<?> lastSchema = this.schema;
        if (this.lastNumber != fieldNumber) {
            this.tail = YamlOutput.writeTag(schema.messageName(), repeated, sink, this, YamlOutput.writeKey(lastSchema.getFieldName(fieldNumber), lastIndent, false, sink, this, this.tail));
        }
        if (repeated) {
            int indentRepeated = YamlOutput.inc(lastIndent, 2);
            this.tail = sink.writeByteArray(DASH_AND_SPACE, (WriteSession)this, YamlOutput.newLine(indentRepeated, sink, this, this.tail));
            this.indent = YamlOutput.inc(indentRepeated, 2);
        } else {
            this.indent = YamlOutput.inc(lastIndent, 2);
        }
        this.schema = schema;
        this.lastNumber = 0;
        schema.writeTo((Output)this, value);
        this.schema = lastSchema;
        this.lastNumber = fieldNumber;
        this.indent = lastIndent;
    }

    static LinkedBuffer writeTag(String name, boolean repeated, WriteSink sink, WriteSession session, LinkedBuffer lb) throws IOException {
        lb = sink.writeStrAscii(name, session, sink.writeByte((byte)33, session, lb));
        if (repeated) {
            return sink.writeByteArray(EMPTY_ARRAY, session, lb);
        }
        return lb;
    }

    private static LinkedBuffer writeKey(String name, int indent, boolean repeated, WriteSink sink, WriteSession session, LinkedBuffer lb) throws IOException {
        lb = sink.writeByteArray(COLON_AND_SPACE, session, sink.writeStrAscii(name, session, YamlOutput.newLine(indent, sink, session, lb)));
        if (repeated) {
            return sink.writeByteArray(DASH_AND_SPACE, session, YamlOutput.newLine(YamlOutput.inc(indent, 2), sink, session, lb));
        }
        return lb;
    }

    private static LinkedBuffer newLine(int indent, WriteSink sink, WriteSession session, LinkedBuffer lb) throws IOException {
        int totalSize = LINE_BREAK_LEN + indent;
        session.size += totalSize;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = sink.drain(session, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        if (LINE_BREAK_LEN == 2) {
            buffer[offset++] = 13;
        }
        buffer[offset++] = 10;
        for (int i = 0; i < indent; ++i) {
            buffer[offset++] = 32;
        }
        assert (offset == lb.offset + totalSize);
        lb.offset = offset;
        return lb;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

