/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.WriteSession;
import io.protostuff.YamlOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class YamlIOUtil {
    private static final byte[] START_DIRECTIVE = new byte[]{45, 45, 45, 32};

    public static <T> byte[] toByteArray(T message, Schema<T> schema, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        YamlOutput output = new YamlOutput(buffer, schema);
        try {
            output.tail = YamlOutput.writeTag(schema.messageName(), false, output.sink, output, output.sink.writeByteArray(START_DIRECTIVE, (WriteSession)output, buffer));
            schema.writeTo((Output)output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> int writeTo(LinkedBuffer buffer, T message, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        YamlOutput output = new YamlOutput(buffer, schema);
        try {
            output.tail = YamlOutput.writeTag(schema.messageName(), false, output.sink, output, output.sink.writeByteArray(START_DIRECTIVE, (WriteSession)output, buffer));
            schema.writeTo((Output)output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        YamlOutput output = new YamlOutput(buffer, out, schema);
        output.tail = YamlOutput.writeTag(schema.messageName(), false, output.sink, output, output.sink.writeByteArray(START_DIRECTIVE, (WriteSession)output, buffer));
        schema.writeTo((Output)output, message);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        return output.getSize();
    }

    public static <T> int writeListTo(LinkedBuffer buffer, List<T> messages, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        YamlOutput output = new YamlOutput(buffer, schema);
        try {
            output.tail = YamlOutput.writeTag(schema.messageName(), true, output.sink, output, output.sink.writeByteArray(START_DIRECTIVE, (WriteSession)output, buffer));
            for (T m : messages) {
                schema.writeTo((Output)output.writeSequenceDelim(), m);
                output.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeListTo(OutputStream out, List<T> messages, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        YamlOutput output = new YamlOutput(buffer, out, schema);
        output.tail = YamlOutput.writeTag(schema.messageName(), true, output.sink, output, output.sink.writeByteArray(START_DIRECTIVE, (WriteSession)output, buffer));
        for (T m : messages) {
            schema.writeTo((Output)output.writeSequenceDelim(), m);
            output.reset();
        }
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        return output.getSize();
    }
}

