/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.apis

import io.provenance.eventstream.stream.models.ABCIInfoResponse
import io.provenance.eventstream.stream.models.ABCIQueryResponse
import io.provenance.eventstream.stream.models.ErrorResponse

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.provenance.eventstream.stream.infrastructure.ApiClient
import io.provenance.eventstream.stream.infrastructure.ClientException
import io.provenance.eventstream.stream.infrastructure.ClientError
import io.provenance.eventstream.stream.infrastructure.ServerException
import io.provenance.eventstream.stream.infrastructure.ServerError
import io.provenance.eventstream.stream.infrastructure.MultiValueMap
import io.provenance.eventstream.stream.infrastructure.RequestConfig
import io.provenance.eventstream.stream.infrastructure.RequestMethod
import io.provenance.eventstream.stream.infrastructure.ResponseType
import io.provenance.eventstream.stream.infrastructure.Success
import io.provenance.eventstream.stream.infrastructure.toMultiValue

class ABCIApi(basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("io.provenance.eventstream.stream.baseUrl", "https://rpc.cosmos.network")
        }
    }

    /**
    * Get some info about the application.
    * Get some info about the application. 
    * @return ABCIInfoResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun abciInfo() : ABCIInfoResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = abciInfoRequestConfig()

        val localVarResponse = request<Unit, ABCIInfoResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ABCIInfoResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation abciInfo
    *
    * @return RequestConfig
    */
    fun abciInfoRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/abci_info",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Query the application for some information.
    * Query the application for some information. 
    * @param path Path to the data (\&quot;/a/b/c\&quot;) 
    * @param `data` Data 
    * @param height Height (0 means latest) (optional, default to 0)
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @return ABCIQueryResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun abciQuery(path: kotlin.String, `data`: kotlin.String, height: kotlin.Int?, prove: kotlin.Boolean?) : ABCIQueryResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = abciQueryRequestConfig(path = path, `data` = `data`, height = height, prove = prove)

        val localVarResponse = request<Unit, ABCIQueryResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ABCIQueryResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation abciQuery
    *
    * @param path Path to the data (\&quot;/a/b/c\&quot;) 
    * @param `data` Data 
    * @param height Height (0 means latest) (optional, default to 0)
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @return RequestConfig
    */
    fun abciQueryRequestConfig(path: kotlin.String, `data`: kotlin.String, height: kotlin.Int?, prove: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("path", listOf(path.toString()))
                put("data", listOf(`data`.toString()))
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/abci_query",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

}
