/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.apis

import io.provenance.eventstream.stream.models.BlockResponse
import io.provenance.eventstream.stream.models.BlockResultsResponse
import io.provenance.eventstream.stream.models.BlockSearchResponse
import io.provenance.eventstream.stream.models.BlockchainResponse
import io.provenance.eventstream.stream.models.BroadcastEvidenceResponse
import io.provenance.eventstream.stream.models.CommitResponse
import io.provenance.eventstream.stream.models.ConsensusParamsResponse
import io.provenance.eventstream.stream.models.ConsensusStateResponse
import io.provenance.eventstream.stream.models.DumpConsensusResponse
import io.provenance.eventstream.stream.models.EmptyResponse
import io.provenance.eventstream.stream.models.ErrorResponse
import io.provenance.eventstream.stream.models.GenesisResponse
import io.provenance.eventstream.stream.models.NetInfoResponse
import io.provenance.eventstream.stream.models.NumUnconfirmedTransactionsResponse
import io.provenance.eventstream.stream.models.StatusResponse
import io.provenance.eventstream.stream.models.TxResponse
import io.provenance.eventstream.stream.models.TxSearchResponse
import io.provenance.eventstream.stream.models.UnconfirmedTransactionsResponse
import io.provenance.eventstream.stream.models.ValidatorsResponse

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.provenance.eventstream.stream.infrastructure.ApiClient
import io.provenance.eventstream.stream.infrastructure.ClientException
import io.provenance.eventstream.stream.infrastructure.ClientError
import io.provenance.eventstream.stream.infrastructure.ServerException
import io.provenance.eventstream.stream.infrastructure.ServerError
import io.provenance.eventstream.stream.infrastructure.MultiValueMap
import io.provenance.eventstream.stream.infrastructure.RequestConfig
import io.provenance.eventstream.stream.infrastructure.RequestMethod
import io.provenance.eventstream.stream.infrastructure.ResponseType
import io.provenance.eventstream.stream.infrastructure.Success
import io.provenance.eventstream.stream.infrastructure.toMultiValue

class InfoApi(basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("io.provenance.eventstream.stream.baseUrl", "https://rpc.cosmos.network")
        }
    }

    /**
    * Get block at a specified height
    * Get Block. 
    * @param height height to return. If no height is provided, it will fetch the latest block. (optional, default to 0)
    * @return BlockResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun block(height: kotlin.Long?) : BlockResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = blockRequestConfig(height = height)

        val localVarResponse = request<Unit, BlockResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation block
    *
    * @param height height to return. If no height is provided, it will fetch the latest block. (optional, default to 0)
    * @return RequestConfig
    */
    fun blockRequestConfig(height: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get block by hash
    * Get Block By Hash. 
    * @param hash block hash 
    * @return BlockResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockByHash(hash: kotlin.String) : BlockResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = blockByHashRequestConfig(hash = hash)

        val localVarResponse = request<Unit, BlockResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation blockByHash
    *
    * @param hash block hash 
    * @return RequestConfig
    */
    fun blockByHashRequestConfig(hash: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("hash", listOf(hash.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_by_hash",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get block results at a specified height
    * Get block_results. 
    * @param height height to return. If no height is provided, it will fetch informations regarding the latest block. (optional, default to 0)
    * @return BlockResultsResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockResults(height: kotlin.Long?) : BlockResultsResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = blockResultsRequestConfig(height = height)

        val localVarResponse = request<Unit, BlockResultsResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockResultsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation blockResults
    *
    * @param height height to return. If no height is provided, it will fetch informations regarding the latest block. (optional, default to 0)
    * @return RequestConfig
    */
    fun blockResultsRequestConfig(height: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_results",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Search for blocks by BeginBlock and EndBlock events
    * Search for blocks by BeginBlock and EndBlock events.  See /subscribe for the query syntax. 
    * @param query Query 
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @param orderBy Order in which blocks are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height. If empty, default sorting will be still applied. (optional, default to "desc")
    * @return BlockSearchResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockSearch(query: kotlin.String, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : BlockSearchResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = blockSearchRequestConfig(query = query, page = page, perPage = perPage, orderBy = orderBy)

        val localVarResponse = request<Unit, BlockSearchResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockSearchResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation blockSearch
    *
    * @param query Query 
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @param orderBy Order in which blocks are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height. If empty, default sorting will be still applied. (optional, default to "desc")
    * @return RequestConfig
    */
    fun blockSearchRequestConfig(query: kotlin.String, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/block_search",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get block headers (max: 20) for minHeight &lt;&#x3D; height &lt;&#x3D; maxHeight.
    * Get block headers for minHeight &lt;&#x3D; height maxHeight.  At most 20 items will be returned. 
    * @param minHeight Minimum block height to return (optional)
    * @param maxHeight Maximum block height to return (optional)
    * @return BlockchainResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun blockchain(minHeight: kotlin.Long?, maxHeight: kotlin.Long?) : BlockchainResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = blockchainRequestConfig(minHeight = minHeight, maxHeight = maxHeight)

        val localVarResponse = request<Unit, BlockchainResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BlockchainResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation blockchain
    *
    * @param minHeight Minimum block height to return (optional)
    * @param maxHeight Maximum block height to return (optional)
    * @return RequestConfig
    */
    fun blockchainRequestConfig(minHeight: kotlin.Long?, maxHeight: kotlin.Long?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (minHeight != null) {
                    put("minHeight", listOf(minHeight.toString()))
                }
                if (maxHeight != null) {
                    put("maxHeight", listOf(maxHeight.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/blockchain",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Broadcast evidence of the misbehavior.
    * Broadcast evidence of the misbehavior. 
    * @param evidence JSON evidence 
    * @return BroadcastEvidenceResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastEvidence(evidence: kotlin.String) : BroadcastEvidenceResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastEvidenceRequestConfig(evidence = evidence)

        val localVarResponse = request<Unit, BroadcastEvidenceResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastEvidenceResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation broadcastEvidence
    *
    * @param evidence JSON evidence 
    * @return RequestConfig
    */
    fun broadcastEvidenceRequestConfig(evidence: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("evidence", listOf(evidence.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_evidence",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get commit results at a specified height
    * Get Commit. 
    * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
    * @return CommitResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun commit(height: kotlin.Int?) : CommitResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = commitRequestConfig(height = height)

        val localVarResponse = request<Unit, CommitResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CommitResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation commit
    *
    * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
    * @return RequestConfig
    */
    fun commitRequestConfig(height: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/commit",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get consensus parameters
    * Get consensus parameters. 
    * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
    * @return ConsensusParamsResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun consensusParams(height: kotlin.Int?) : ConsensusParamsResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = consensusParamsRequestConfig(height = height)

        val localVarResponse = request<Unit, ConsensusParamsResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ConsensusParamsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation consensusParams
    *
    * @param height height to return. If no height is provided, it will fetch commit informations regarding the latest block. (optional, default to 0)
    * @return RequestConfig
    */
    fun consensusParamsRequestConfig(height: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/consensus_params",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get consensus state
    * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
    * @return ConsensusStateResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun consensusState() : ConsensusStateResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = consensusStateRequestConfig()

        val localVarResponse = request<Unit, ConsensusStateResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ConsensusStateResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation consensusState
    *
    * @return RequestConfig
    */
    fun consensusStateRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/consensus_state",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get consensus state
    * Get consensus state.  Not safe to call from inside the ABCI application during a block execution. 
    * @return DumpConsensusResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dumpConsensusState() : DumpConsensusResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = dumpConsensusStateRequestConfig()

        val localVarResponse = request<Unit, DumpConsensusResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DumpConsensusResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation dumpConsensusState
    *
    * @return RequestConfig
    */
    fun dumpConsensusStateRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dump_consensus_state",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get Genesis
    * Get genesis. 
    * @return GenesisResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun genesis() : GenesisResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = genesisRequestConfig()

        val localVarResponse = request<Unit, GenesisResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as GenesisResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation genesis
    *
    * @return RequestConfig
    */
    fun genesisRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/genesis",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Node heartbeat
    * Get node health. Returns empty result (200 OK) on success, no response - in case of an error. 
    * @return EmptyResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun health() : EmptyResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = healthRequestConfig()

        val localVarResponse = request<Unit, EmptyResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation health
    *
    * @return RequestConfig
    */
    fun healthRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/health",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Network informations
    * Get network info. 
    * @return NetInfoResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun netInfo() : NetInfoResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = netInfoRequestConfig()

        val localVarResponse = request<Unit, NetInfoResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NetInfoResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation netInfo
    *
    * @return RequestConfig
    */
    fun netInfoRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/net_info",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get data about unconfirmed transactions
    * Get data about unconfirmed transactions 
    * @return NumUnconfirmedTransactionsResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun numUnconfirmedTxs() : NumUnconfirmedTransactionsResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = numUnconfirmedTxsRequestConfig()

        val localVarResponse = request<Unit, NumUnconfirmedTransactionsResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as NumUnconfirmedTransactionsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation numUnconfirmedTxs
    *
    * @return RequestConfig
    */
    fun numUnconfirmedTxsRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/num_unconfirmed_txs",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Node Status
    * Get Tendermint status including node info, pubkey, latest block hash, app hash, block height and time. 
    * @return StatusResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun status() : StatusResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = statusRequestConfig()

        val localVarResponse = request<Unit, StatusResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as StatusResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation status
    *
    * @return RequestConfig
    */
    fun statusRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/status",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get transactions by hash
    * Get a trasasction 
    * @param hash transaction Hash to retrive 
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @return TxResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun tx(hash: kotlin.String, prove: kotlin.Boolean?) : TxResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = txRequestConfig(hash = hash, prove = prove)

        val localVarResponse = request<Unit, TxResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation tx
    *
    * @param hash transaction Hash to retrive 
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @return RequestConfig
    */
    fun txRequestConfig(hash: kotlin.String, prove: kotlin.Boolean?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("hash", listOf(hash.toString()))
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/tx",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Search for transactions
    * Search for transactions w/ their results.  See /subscribe for the query syntax. 
    * @param query Query 
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @param orderBy Order in which transactions are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height &amp; index. If empty, default sorting will be still applied. (optional, default to "asc")
    * @return TxSearchResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun txSearch(query: kotlin.String, prove: kotlin.Boolean?, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : TxSearchResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = txSearchRequestConfig(query = query, prove = prove, page = page, perPage = perPage, orderBy = orderBy)

        val localVarResponse = request<Unit, TxSearchResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as TxSearchResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation txSearch
    *
    * @param query Query 
    * @param prove Include proofs of the transactions inclusion in the block (optional, default to false)
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @param orderBy Order in which transactions are sorted (\&quot;asc\&quot; or \&quot;desc\&quot;), by height &amp; index. If empty, default sorting will be still applied. (optional, default to "asc")
    * @return RequestConfig
    */
    fun txSearchRequestConfig(query: kotlin.String, prove: kotlin.Boolean?, page: kotlin.Int?, perPage: kotlin.Int?, orderBy: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
                if (prove != null) {
                    put("prove", listOf(prove.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
                if (orderBy != null) {
                    put("order_by", listOf(orderBy.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/tx_search",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get the list of unconfirmed transactions
    * Get list of unconfirmed transactions 
    * @param limit Maximum number of unconfirmed transactions to return (max 100) (optional, default to 30)
    * @return UnconfirmedTransactionsResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unconfirmedTxs(limit: kotlin.Int?) : UnconfirmedTransactionsResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = unconfirmedTxsRequestConfig(limit = limit)

        val localVarResponse = request<Unit, UnconfirmedTransactionsResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as UnconfirmedTransactionsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation unconfirmedTxs
    *
    * @param limit Maximum number of unconfirmed transactions to return (max 100) (optional, default to 30)
    * @return RequestConfig
    */
    fun unconfirmedTxsRequestConfig(limit: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (limit != null) {
                    put("limit", listOf(limit.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unconfirmed_txs",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Get validator set at a specified height
    * Get Validators. Validators are sorted by voting power. 
    * @param height height to return. If no height is provided, it will fetch validator set which corresponds to the latest block. (optional, default to 0)
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @return ValidatorsResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun validators(height: kotlin.Int?, page: kotlin.Int?, perPage: kotlin.Int?) : ValidatorsResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = validatorsRequestConfig(height = height, page = page, perPage = perPage)

        val localVarResponse = request<Unit, ValidatorsResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as ValidatorsResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation validators
    *
    * @param height height to return. If no height is provided, it will fetch validator set which corresponds to the latest block. (optional, default to 0)
    * @param page Page number (1-based) (optional, default to 1)
    * @param perPage Number of entries per page (max: 100) (optional, default to 30)
    * @return RequestConfig
    */
    fun validatorsRequestConfig(height: kotlin.Int?, page: kotlin.Int?, perPage: kotlin.Int?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (height != null) {
                    put("height", listOf(height.toString()))
                }
                if (page != null) {
                    put("page", listOf(page.toString()))
                }
                if (perPage != null) {
                    put("per_page", listOf(perPage.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/validators",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

}
