/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.apis

import io.provenance.eventstream.stream.models.BroadcastTxCommitResponse
import io.provenance.eventstream.stream.models.BroadcastTxResponse
import io.provenance.eventstream.stream.models.CheckTxResponse
import io.provenance.eventstream.stream.models.ErrorResponse

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.provenance.eventstream.stream.infrastructure.ApiClient
import io.provenance.eventstream.stream.infrastructure.ClientException
import io.provenance.eventstream.stream.infrastructure.ClientError
import io.provenance.eventstream.stream.infrastructure.ServerException
import io.provenance.eventstream.stream.infrastructure.ServerError
import io.provenance.eventstream.stream.infrastructure.MultiValueMap
import io.provenance.eventstream.stream.infrastructure.RequestConfig
import io.provenance.eventstream.stream.infrastructure.RequestMethod
import io.provenance.eventstream.stream.infrastructure.ResponseType
import io.provenance.eventstream.stream.infrastructure.Success
import io.provenance.eventstream.stream.infrastructure.toMultiValue

class TxApi(basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("io.provenance.eventstream.stream.baseUrl", "https://rpc.cosmos.network")
        }
    }

    /**
    * Returns right away, with no response. Does not wait for CheckTx nor DeliverTx results.
    * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322) 3. node can be offline  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
    * @param tx The transaction 
    * @return BroadcastTxResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxAsync(tx: kotlin.String) : BroadcastTxResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxAsyncRequestConfig(tx = tx)

        val localVarResponse = request<Unit, BroadcastTxResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation broadcastTxAsync
    *
    * @param tx The transaction 
    * @return RequestConfig
    */
    fun broadcastTxAsyncRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_async",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Returns with the responses from CheckTx and DeliverTx.
    * IMPORTANT: use only for testing and development. In production, use BroadcastTxSync or BroadcastTxAsync. You can subscribe for the transaction result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html  CONTRACT: only returns error if mempool.CheckTx() errs or if we timeout waiting for tx to commit.  If CheckTx or DeliverTx fail, no error will be returned, but the returned result will contain a non-OK ABCI code.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
    * @param tx The transaction 
    * @return BroadcastTxCommitResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxCommit(tx: kotlin.String) : BroadcastTxCommitResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxCommitRequestConfig(tx = tx)

        val localVarResponse = request<Unit, BroadcastTxCommitResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxCommitResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation broadcastTxCommit
    *
    * @param tx The transaction 
    * @return RequestConfig
    */
    fun broadcastTxCommitRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_commit",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Returns with the response from CheckTx. Does not wait for DeliverTx result.
    * If you want to be sure that the transaction is included in a block, you can subscribe for the result using JSONRPC via a websocket. See https://docs.tendermint.com/master/app-dev/subscribing-to-events-via-websocket.html If you haven&#39;t received anything after a couple of blocks, resend it. If the same happens again, send it to some other node. A few reasons why it could happen:  1. malicious node can drop or pretend it had committed your tx 2. malicious proposer (not necessary the one you&#39;re communicating with) can drop transactions, which might become valid in the future (https://github.com/tendermint/tendermint/issues/3322)   Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
    * @param tx The transaction 
    * @return BroadcastTxResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun broadcastTxSync(tx: kotlin.String) : BroadcastTxResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = broadcastTxSyncRequestConfig(tx = tx)

        val localVarResponse = request<Unit, BroadcastTxResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as BroadcastTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation broadcastTxSync
    *
    * @param tx The transaction 
    * @return RequestConfig
    */
    fun broadcastTxSyncRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/broadcast_tx_sync",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Checks the transaction without executing it.
    * The transaction won&#39;t be added to the mempool.  Please refer to https://docs.tendermint.com/master/tendermint-core/using-tendermint.html#formatting for formatting/encoding rules. 
    * @param tx The transaction 
    * @return CheckTxResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun checkTx(tx: kotlin.String) : CheckTxResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = checkTxRequestConfig(tx = tx)

        val localVarResponse = request<Unit, CheckTxResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as CheckTxResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation checkTx
    *
    * @param tx The transaction 
    * @return RequestConfig
    */
    fun checkTxRequestConfig(tx: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("tx", listOf(tx.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/check_tx",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

}
