/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.apis

import io.provenance.eventstream.stream.models.DialResp
import io.provenance.eventstream.stream.models.ErrorResponse

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.provenance.eventstream.stream.infrastructure.ApiClient
import io.provenance.eventstream.stream.infrastructure.ClientException
import io.provenance.eventstream.stream.infrastructure.ClientError
import io.provenance.eventstream.stream.infrastructure.ServerException
import io.provenance.eventstream.stream.infrastructure.ServerError
import io.provenance.eventstream.stream.infrastructure.MultiValueMap
import io.provenance.eventstream.stream.infrastructure.RequestConfig
import io.provenance.eventstream.stream.infrastructure.RequestMethod
import io.provenance.eventstream.stream.infrastructure.ResponseType
import io.provenance.eventstream.stream.infrastructure.Success
import io.provenance.eventstream.stream.infrastructure.toMultiValue

class UnsafeApi(basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("io.provenance.eventstream.stream.baseUrl", "https://rpc.cosmos.network")
        }
    }

    /**
    * Add Peers/Persistent Peers (unsafe)
    * Set a persistent peer, this route in under unsafe, and has to manually enabled to use.  **Example:** curl &#39;localhost:26657/dial_peers?peers&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&amp;persistent&#x3D;false&#39; 
    * @param persistent Have the peers you are dialing be persistent (optional)
    * @param unconditional Have the peers you are dialing be unconditional (optional)
    * @param `private` Have the peers you are dialing be private (optional)
    * @param peers array of peers to dial (optional)
    * @return DialResp
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dialPeers(persistent: kotlin.Boolean?, unconditional: kotlin.Boolean?, `private`: kotlin.Boolean?, peers: kotlin.collections.List<kotlin.String>?) : DialResp = withContext(Dispatchers.IO) {
        val localVariableConfig = dialPeersRequestConfig(persistent = persistent, unconditional = unconditional, `private` = `private`, peers = peers)

        val localVarResponse = request<Unit, DialResp>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DialResp
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation dialPeers
    *
    * @param persistent Have the peers you are dialing be persistent (optional)
    * @param unconditional Have the peers you are dialing be unconditional (optional)
    * @param `private` Have the peers you are dialing be private (optional)
    * @param peers array of peers to dial (optional)
    * @return RequestConfig
    */
    fun dialPeersRequestConfig(persistent: kotlin.Boolean?, unconditional: kotlin.Boolean?, `private`: kotlin.Boolean?, peers: kotlin.collections.List<kotlin.String>?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (persistent != null) {
                    put("persistent", listOf(persistent.toString()))
                }
                if (unconditional != null) {
                    put("unconditional", listOf(unconditional.toString()))
                }
                if (`private` != null) {
                    put("private", listOf(`private`.toString()))
                }
                if (peers != null) {
                    put("peers", toMultiValue(peers.toList(), "multi"))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dial_peers",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Dial Seeds (Unsafe)
    * Dial a peer, this route in under unsafe, and has to manually enabled to use    **Example:** curl &#39;localhost:26657/dial_seeds?seeds&#x3D;\\[\&quot;f9baeaa15fedf5e1ef7448dd60f46c01f1a9e9c4@1.2.3.4:26656\&quot;,\&quot;0491d373a8e0fcf1023aaf18c51d6a1d0d4f31bd@5.6.7.8:26656\&quot;\\]&#39; 
    * @param peers list of seed nodes to dial (optional)
    * @return DialResp
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun dialSeeds(peers: kotlin.collections.List<kotlin.String>?) : DialResp = withContext(Dispatchers.IO) {
        val localVariableConfig = dialSeedsRequestConfig(peers = peers)

        val localVarResponse = request<Unit, DialResp>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as DialResp
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation dialSeeds
    *
    * @param peers list of seed nodes to dial (optional)
    * @return RequestConfig
    */
    fun dialSeedsRequestConfig(peers: kotlin.collections.List<kotlin.String>?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                if (peers != null) {
                    put("peers", toMultiValue(peers.toList(), "multi"))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/dial_seeds",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

}
